/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.Nothing;
import io.github.bucket4j.distributed.remote.BucketNotFoundError;
import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.remote.ConfigurationNeedToBeReplacedError;
import io.github.bucket4j.distributed.remote.UnsupportedNamedTypeError;
import io.github.bucket4j.distributed.remote.UnsupportedTypeError;
import io.github.bucket4j.distributed.remote.UsageOfObsoleteApiError;
import io.github.bucket4j.distributed.remote.UsageOfUnsupportedApiError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.serialization.SerializationHandles;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CommandResult<T>
implements ComparableByContent<CommandResult> {
    public static final CommandResult<Nothing> NOTHING = CommandResult.success(Nothing.INSTANCE, PrimitiveSerializationHandles.NULL_HANDLE);
    public static final CommandResult<Long> ZERO = CommandResult.success(Long.valueOf(0L), PrimitiveSerializationHandles.LONG_HANDLE);
    public static final CommandResult<Long> MAX_VALUE = CommandResult.success(Long.valueOf(Long.MAX_VALUE), PrimitiveSerializationHandles.LONG_HANDLE);
    public static final CommandResult<Boolean> TRUE = CommandResult.success(Boolean.valueOf(true), PrimitiveSerializationHandles.BOOLEAN_HANDLE);
    public static final CommandResult<Boolean> FALSE = CommandResult.success(Boolean.valueOf(false), PrimitiveSerializationHandles.BOOLEAN_HANDLE);
    private static final CommandResult<?> NOT_FOUND = new CommandResult<BucketNotFoundError>(new BucketNotFoundError(), BucketNotFoundError.SERIALIZATION_HANDLE.getTypeId());
    private static final CommandResult<?> CONFIGURATION_NEED_TO_BE_REPLACED = new CommandResult<ConfigurationNeedToBeReplacedError>(new ConfigurationNeedToBeReplacedError(), ConfigurationNeedToBeReplacedError.SERIALIZATION_HANDLE.getTypeId());
    private static final CommandResult<?> NULL = new CommandResult<Object>(null, PrimitiveSerializationHandles.NULL_HANDLE.getTypeId());
    private T data;
    private int resultTypeId;
    public static SerializationHandle<CommandResult<?>> SERIALIZATION_HANDLE = new SerializationHandle<CommandResult<?>>(){

        @Override
        public <S> CommandResult<?> deserialize(DeserializationAdapter<S> adapter2, S input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int typeId = adapter2.readInt(input);
            SerializationHandle handle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(typeId);
            Object resultData = handle.deserialize(adapter2, input);
            return CommandResult.success(resultData, typeId);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, CommandResult<?> result, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter2.writeInt(output, ((CommandResult)result).resultTypeId);
            SerializationHandle<Object> handle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(((CommandResult)result).resultTypeId);
            handle.serialize(adapter2, output, ((CommandResult)result).data, backwardCompatibilityVersion, scope);
        }

        @Override
        public int getTypeId() {
            return 10;
        }

        @Override
        public Class<CommandResult<?>> getSerializedType() {
            return CommandResult.class;
        }

        @Override
        public CommandResult<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            Map dataSnapshot = (Map)snapshot.get("data");
            String typeName = (String)dataSnapshot.get("type");
            SerializationHandle<?> handle = SerializationHandles.CORE_HANDLES.getHandleByTypeName(typeName);
            Object resultData = handle.fromJsonCompatibleSnapshot(dataSnapshot);
            return CommandResult.success(resultData, handle.getTypeId());
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(CommandResult<?> result, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("version", Versions.v_7_0_0.getNumber());
            SerializationHandle<Object> handle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(((CommandResult)result).resultTypeId);
            Map<String, Object> valueSnapshot = handle.toJsonCompatibleSnapshot(((CommandResult)result).data, backwardCompatibilityVersion, scope);
            valueSnapshot.put("type", handle.getTypeName());
            snapshot.put("data", valueSnapshot);
            return snapshot;
        }

        @Override
        public String getTypeName() {
            return "CommandResult";
        }
    };

    public CommandResult(T data, int resultTypeId) {
        this.data = data;
        this.resultTypeId = resultTypeId;
    }

    public static <R> CommandResult<R> success(R data, SerializationHandle dataSerializer) {
        return new CommandResult<R>(data, dataSerializer.getTypeId());
    }

    public static <R> CommandResult<R> success(R data, int resultTypeId) {
        return new CommandResult<R>(data, resultTypeId);
    }

    public static <R> CommandResult<R> bucketNotFound() {
        return NOT_FOUND;
    }

    public static <R> CommandResult<R> configurationNeedToBeReplaced() {
        return CONFIGURATION_NEED_TO_BE_REPLACED;
    }

    public static <R> CommandResult<R> empty() {
        return NULL;
    }

    public static CommandResult<?> unsupportedType(int typeId) {
        UnsupportedTypeError error = new UnsupportedTypeError(typeId);
        return new CommandResult<UnsupportedTypeError>(error, UnsupportedTypeError.SERIALIZATION_HANDLE.getTypeId());
    }

    public static CommandResult<?> unsupportedNamedType(String typeName) {
        UnsupportedNamedTypeError error = new UnsupportedNamedTypeError(typeName);
        return new CommandResult<UnsupportedNamedTypeError>(error, UnsupportedNamedTypeError.SERIALIZATION_HANDLE.getTypeId());
    }

    public static CommandResult<?> usageOfUnsupportedApiException(int requestedFormatNumber, int maxSupportedFormatNumber) {
        UsageOfUnsupportedApiError error = new UsageOfUnsupportedApiError(requestedFormatNumber, maxSupportedFormatNumber);
        return new CommandResult<UsageOfUnsupportedApiError>(error, UsageOfUnsupportedApiError.SERIALIZATION_HANDLE.getTypeId());
    }

    public static CommandResult<?> usageOfObsoleteApiException(int requestedFormatNumber, int minSupportedFormatNumber) {
        UsageOfObsoleteApiError error = new UsageOfObsoleteApiError(requestedFormatNumber, minSupportedFormatNumber);
        return new CommandResult<UsageOfObsoleteApiError>(error, UsageOfObsoleteApiError.SERIALIZATION_HANDLE.getTypeId());
    }

    public T getData() {
        if (this.data instanceof CommandError) {
            CommandError error = (CommandError)this.data;
            throw error.asException();
        }
        return this.data;
    }

    public boolean isBucketNotFound() {
        return this.data instanceof BucketNotFoundError;
    }

    public boolean isConfigurationNeedToBeReplaced() {
        return this.data instanceof ConfigurationNeedToBeReplacedError;
    }

    public boolean isError() {
        return this.data instanceof CommandError;
    }

    public int getResultTypeId() {
        return this.resultTypeId;
    }

    @Override
    public boolean equalsByContent(CommandResult other) {
        return this.resultTypeId == other.resultTypeId && ComparableByContent.equals(this.data, other.data);
    }
}

