/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.Nothing;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ForceAddTokensCommand
implements RemoteCommand<Nothing>,
ComparableByContent<ForceAddTokensCommand> {
    private static final long serialVersionUID = 1L;
    private long tokensToAdd;
    public static final SerializationHandle<ForceAddTokensCommand> SERIALIZATION_HANDLE = new SerializationHandle<ForceAddTokensCommand>(){

        @Override
        public <I> ForceAddTokensCommand deserialize(DeserializationAdapter<I> adapter2, I input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToAdd = adapter2.readLong(input);
            return new ForceAddTokensCommand(tokensToAdd);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, ForceAddTokensCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter2.writeLong(output, command.tokensToAdd);
        }

        @Override
        public int getTypeId() {
            return 38;
        }

        @Override
        public Class<ForceAddTokensCommand> getSerializedType() {
            return ForceAddTokensCommand.class;
        }

        @Override
        public ForceAddTokensCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToAdd = this.readLongValue(snapshot, "tokensToAdd");
            return new ForceAddTokensCommand(tokensToAdd);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ForceAddTokensCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("tokensToAdd", command.tokensToAdd);
            return result;
        }

        @Override
        public String getTypeName() {
            return "ForceAddTokensCommand";
        }
    };

    public ForceAddTokensCommand(long tokensToAdd) {
        this.tokensToAdd = tokensToAdd;
    }

    public long getTokensToAdd() {
        return this.tokensToAdd;
    }

    @Override
    public CommandResult<Nothing> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        state.forceAddTokens(this.tokensToAdd);
        mutableEntry.set(state);
        return CommandResult.NOTHING;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return true;
    }

    @Override
    public long estimateTokensToConsume() {
        return 0L;
    }

    @Override
    public long getConsumedTokens(Nothing result) {
        return 0L;
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.v_7_0_0;
    }

    @Override
    public boolean equalsByContent(ForceAddTokensCommand other) {
        return this.tokensToAdd == other.tokensToAdd;
    }
}

