/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReplaceConfigurationCommand
implements RemoteCommand<Nothing>,
ComparableByContent<ReplaceConfigurationCommand> {
    private final TokensInheritanceStrategy tokensInheritanceStrategy;
    private final BucketConfiguration newConfiguration;
    public static final SerializationHandle<ReplaceConfigurationCommand> SERIALIZATION_HANDLE = new SerializationHandle<ReplaceConfigurationCommand>(){

        @Override
        public <S> ReplaceConfigurationCommand deserialize(DeserializationAdapter<S> adapter2, S input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration newConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter2, input);
            TokensInheritanceStrategy tokensInheritanceStrategy = TokensInheritanceStrategy.getById(adapter2.readByte(input));
            return new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, ReplaceConfigurationCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter2, output, command.newConfiguration, backwardCompatibilityVersion, scope);
            adapter2.writeByte(output, command.tokensInheritanceStrategy.getId());
        }

        @Override
        public int getTypeId() {
            return 32;
        }

        @Override
        public Class<ReplaceConfigurationCommand> getSerializedType() {
            return ReplaceConfigurationCommand.class;
        }

        @Override
        public ReplaceConfigurationCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            TokensInheritanceStrategy tokensInheritanceStrategy = TokensInheritanceStrategy.valueOf((String)snapshot.get("tokensInheritanceStrategy"));
            BucketConfiguration newConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot((Map)snapshot.get("newConfiguration"));
            return new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ReplaceConfigurationCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("tokensInheritanceStrategy", command.tokensInheritanceStrategy.toString());
            result.put("newConfiguration", BucketConfiguration.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(command.newConfiguration, backwardCompatibilityVersion, scope));
            return result;
        }

        @Override
        public String getTypeName() {
            return "ReplaceConfigurationCommand";
        }
    };

    public ReplaceConfigurationCommand(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.newConfiguration = newConfiguration;
        this.tokensInheritanceStrategy = tokensInheritanceStrategy;
    }

    @Override
    public CommandResult<Nothing> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        state.replaceConfiguration(this.newConfiguration, this.tokensInheritanceStrategy, currentTimeNanos);
        mutableEntry.set(state);
        return CommandResult.empty();
    }

    public BucketConfiguration getNewConfiguration() {
        return this.newConfiguration;
    }

    public TokensInheritanceStrategy getTokensInheritanceStrategy() {
        return this.tokensInheritanceStrategy;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(ReplaceConfigurationCommand other) {
        return ComparableByContent.equals(this.newConfiguration, other.newConfiguration) && this.tokensInheritanceStrategy == other.tokensInheritanceStrategy;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return true;
    }

    @Override
    public long estimateTokensToConsume() {
        return 0L;
    }

    @Override
    public long getConsumedTokens(Nothing result) {
        return 0L;
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.v_7_0_0;
    }
}

