/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReserveAndCalculateTimeToSleepCommand
implements RemoteCommand<Long>,
ComparableByContent<ReserveAndCalculateTimeToSleepCommand> {
    private long tokensToConsume;
    private long waitIfBusyNanosLimit;
    public static final SerializationHandle<ReserveAndCalculateTimeToSleepCommand> SERIALIZATION_HANDLE = new SerializationHandle<ReserveAndCalculateTimeToSleepCommand>(){

        @Override
        public <S> ReserveAndCalculateTimeToSleepCommand deserialize(DeserializationAdapter<S> adapter2, S input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToConsume = adapter2.readLong(input);
            long waitIfBusyNanosLimit = adapter2.readLong(input);
            return new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, waitIfBusyNanosLimit);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, ReserveAndCalculateTimeToSleepCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter2.writeLong(output, command.tokensToConsume);
            adapter2.writeLong(output, command.waitIfBusyNanosLimit);
        }

        @Override
        public int getTypeId() {
            return 23;
        }

        @Override
        public Class<ReserveAndCalculateTimeToSleepCommand> getSerializedType() {
            return ReserveAndCalculateTimeToSleepCommand.class;
        }

        @Override
        public ReserveAndCalculateTimeToSleepCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToConsume = this.readLongValue(snapshot, "tokensToConsume");
            long waitIfBusyNanosLimit = this.readLongValue(snapshot, "waitIfBusyNanosLimit");
            return new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, waitIfBusyNanosLimit);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ReserveAndCalculateTimeToSleepCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("tokensToConsume", command.tokensToConsume);
            result.put("waitIfBusyNanosLimit", command.waitIfBusyNanosLimit);
            return result;
        }

        @Override
        public String getTypeName() {
            return "ReserveAndCalculateTimeToSleepCommand";
        }
    };

    public ReserveAndCalculateTimeToSleepCommand(long tokensToConsume, long waitIfBusyNanosLimit) {
        this.tokensToConsume = tokensToConsume;
        this.waitIfBusyNanosLimit = waitIfBusyNanosLimit;
    }

    @Override
    public CommandResult<Long> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = state.calculateDelayNanosAfterWillBePossibleToConsume(this.tokensToConsume, currentTimeNanos, false);
        if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > this.waitIfBusyNanosLimit) {
            return CommandResult.MAX_VALUE;
        }
        state.consume(this.tokensToConsume);
        mutableEntry.set(state);
        return CommandResult.success(Long.valueOf(nanosToCloseDeficit), PrimitiveSerializationHandles.LONG_HANDLE);
    }

    public long getTokensToConsume() {
        return this.tokensToConsume;
    }

    public long getWaitIfBusyNanosLimit() {
        return this.waitIfBusyNanosLimit;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(ReserveAndCalculateTimeToSleepCommand other) {
        return this.tokensToConsume == other.tokensToConsume && this.waitIfBusyNanosLimit == other.waitIfBusyNanosLimit;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return false;
    }

    @Override
    public long estimateTokensToConsume() {
        return this.tokensToConsume;
    }

    @Override
    public long getConsumedTokens(Long result) {
        return result;
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.v_7_0_0;
    }
}

