/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SyncCommand
implements RemoteCommand<Nothing>,
ComparableByContent<SyncCommand> {
    private final long unsynchronizedTokens;
    private final long nanosSinceLastSync;
    public static final SerializationHandle<SyncCommand> SERIALIZATION_HANDLE = new SerializationHandle<SyncCommand>(){

        @Override
        public <S> SyncCommand deserialize(DeserializationAdapter<S> adapter2, S input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long unsynchronizedTokens = adapter2.readLong(input);
            long nanosSinceLastSync = adapter2.readLong(input);
            return new SyncCommand(unsynchronizedTokens, nanosSinceLastSync);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, SyncCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter2.writeLong(output, command.unsynchronizedTokens);
            adapter2.writeLong(output, command.nanosSinceLastSync);
        }

        @Override
        public int getTypeId() {
            return 36;
        }

        @Override
        public Class<SyncCommand> getSerializedType() {
            return SyncCommand.class;
        }

        @Override
        public SyncCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long unsynchronizedTokens = this.readLongValue(snapshot, "unsynchronizedTokens");
            long nanosSinceLastSync = this.readLongValue(snapshot, "nanosSinceLastSync");
            return new SyncCommand(unsynchronizedTokens, nanosSinceLastSync);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(SyncCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("unsynchronizedTokens", command.unsynchronizedTokens);
            result.put("nanosSinceLastSync", command.nanosSinceLastSync);
            return result;
        }

        @Override
        public String getTypeName() {
            return "SyncCommand";
        }
    };

    public SyncCommand(long unsynchronizedTokens, long nanosSinceLastSync) {
        if (unsynchronizedTokens < 0L) {
            throw BucketExceptions.nonPositiveTokensLimitToSync(unsynchronizedTokens);
        }
        if (nanosSinceLastSync < 0L) {
            throw BucketExceptions.nonPositiveLimitToSync(nanosSinceLastSync);
        }
        this.unsynchronizedTokens = unsynchronizedTokens;
        this.nanosSinceLastSync = nanosSinceLastSync;
    }

    public long getNanosSinceLastSync() {
        return this.nanosSinceLastSync;
    }

    public long getUnsynchronizedTokens() {
        return this.unsynchronizedTokens;
    }

    @Override
    public CommandResult<Nothing> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        mutableEntry.set(state);
        return CommandResult.NOTHING;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(SyncCommand other) {
        return this.unsynchronizedTokens == other.unsynchronizedTokens && this.nanosSinceLastSync == other.nanosSinceLastSync;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return this.unsynchronizedTokens <= unsynchronizedTokens && this.nanosSinceLastSync <= nanosSinceLastSync;
    }

    @Override
    public long estimateTokensToConsume() {
        return 0L;
    }

    @Override
    public long getConsumedTokens(Nothing result) {
        return 0L;
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.v_7_0_0;
    }
}

