/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.util.concurrent.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AsyncBatchHelper<T, R, CT, CR> {
    private static final WaitingTask<?, ?> QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS = new WaitingTask(null);
    private static final WaitingTask<?, ?> QUEUE_EMPTY = new WaitingTask(null);
    private final Function<List<T>, CT> taskCombiner;
    private final Function<CT, CompletableFuture<CR>> asyncCombinedTaskExecutor;
    private final Function<T, CompletableFuture<R>> asyncTaskExecutor;
    private final BiFunction<CT, CR, List<R>> combinedResultSplitter;
    private final AtomicReference<WaitingTask> headReference = new AtomicReference(QUEUE_EMPTY);

    public static <T, R, CT, CR> AsyncBatchHelper<T, R, CT, CR> create(Function<List<T>, CT> taskCombiner, Function<CT, CompletableFuture<CR>> asyncCombinedTaskExecutor, Function<T, CompletableFuture<R>> asyncTaskExecutor, BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        return new AsyncBatchHelper<T, R, CT, CR>(taskCombiner, asyncCombinedTaskExecutor, asyncTaskExecutor, combinedResultSplitter);
    }

    public static <T, R, CT, CR> AsyncBatchHelper<T, R, CT, CR> create(final Function<List<T>, CT> taskCombiner, final Function<CT, CompletableFuture<CR>> asyncCombinedTaskExecutor, final BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        Function asyncTaskExecutor = new Function<T, CompletableFuture<R>>(){

            @Override
            public CompletableFuture<R> apply(T task) {
                Object combinedTask = taskCombiner.apply(Collections.singletonList(task));
                CompletableFuture resultFuture = (CompletableFuture)asyncCombinedTaskExecutor.apply(combinedTask);
                return resultFuture.thenApply(combinedResult -> {
                    List results = (List)combinedResultSplitter.apply(combinedTask, combinedResult);
                    return results.get(0);
                });
            }
        };
        return new AsyncBatchHelper<T, R, CT, CR>(taskCombiner, asyncCombinedTaskExecutor, asyncTaskExecutor, combinedResultSplitter);
    }

    private AsyncBatchHelper(Function<List<T>, CT> taskCombiner, Function<CT, CompletableFuture<CR>> asyncCombinedTaskExecutor, Function<T, CompletableFuture<R>> asyncTaskExecutor, BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        this.taskCombiner = Objects.requireNonNull(taskCombiner);
        this.asyncCombinedTaskExecutor = Objects.requireNonNull(asyncCombinedTaskExecutor);
        this.asyncTaskExecutor = Objects.requireNonNull(asyncTaskExecutor);
        this.combinedResultSplitter = Objects.requireNonNull(combinedResultSplitter);
    }

    public CompletableFuture<R> executeAsync(T task) {
        WaitingTask<T, R> waitingTask = this.lockExclusivelyOrEnqueue(task);
        if (waitingTask != null) {
            return waitingTask.future;
        }
        try {
            return this.asyncTaskExecutor.apply(task).whenComplete((result, error) -> this.scheduleNextBatchAsync());
        }
        catch (Throwable error2) {
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(error2);
            return failedFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextBatchAsync() {
        List<WaitingTask<T, R>> waitingNodes = this.takeAllWaitingTasksOrFreeLock();
        if (waitingNodes.isEmpty()) {
            return;
        }
        try {
            ArrayList commandsInBatch = new ArrayList(waitingNodes.size());
            for (WaitingTask<T, R> waitingNode : waitingNodes) {
                commandsInBatch.add(waitingNode.wrappedTask);
            }
            CT multiCommand = this.taskCombiner.apply(commandsInBatch);
            CompletableFuture<CR> combinedFuture = this.asyncCombinedTaskExecutor.apply(multiCommand);
            ((CompletableFuture)combinedFuture.whenComplete((multiResult, error) -> this.completeWaitingFutures(multiCommand, waitingNodes, (CR)multiResult, (Throwable)error))).whenComplete((multiResult, error) -> this.scheduleNextBatchAsync());
        }
        catch (Throwable e) {
            try {
                for (WaitingTask<T, R> waitingNode : waitingNodes) {
                    waitingNode.future.completeExceptionally(e);
                }
            }
            finally {
                this.scheduleNextBatchAsync();
            }
        }
    }

    private void completeWaitingFutures(CT combinedTask, List<WaitingTask<T, R>> waitingNodes, CR multiResult, Throwable error) {
        if (error != null) {
            for (WaitingTask<T, R> waitingNode : waitingNodes) {
                try {
                    waitingNode.future.completeExceptionally(error);
                }
                catch (Throwable t2) {
                    waitingNode.future.completeExceptionally(t2);
                }
            }
        } else {
            List<R> singleResults = this.combinedResultSplitter.apply(combinedTask, multiResult);
            for (int i = 0; i < waitingNodes.size(); ++i) {
                try {
                    waitingNodes.get((int)i).future.complete(singleResults.get(i));
                    continue;
                }
                catch (Throwable t3) {
                    waitingNodes.get((int)i).future.completeExceptionally(t3);
                }
            }
        }
    }

    private WaitingTask<T, R> lockExclusivelyOrEnqueue(T command) {
        WaitingTask waitingTask = new WaitingTask(command);
        while (true) {
            WaitingTask previous;
            if ((previous = this.headReference.get()) == QUEUE_EMPTY) {
                if (!this.headReference.compareAndSet(previous, QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS)) continue;
                return null;
            }
            waitingTask.previous = previous;
            if (this.headReference.compareAndSet(previous, waitingTask)) {
                return waitingTask;
            }
            waitingTask.previous = null;
        }
    }

    private List<WaitingTask<T, R>> takeAllWaitingTasksOrFreeLock() {
        WaitingTask head;
        while (true) {
            if ((head = this.headReference.get()) == QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS) {
                if (!this.headReference.compareAndSet(QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS, QUEUE_EMPTY)) continue;
                return Collections.emptyList();
            }
            if (this.headReference.compareAndSet(head, QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS)) break;
        }
        WaitingTask current = head;
        ArrayList<WaitingTask<T, R>> waitingNodes = new ArrayList<WaitingTask<T, R>>();
        while (current != QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS) {
            waitingNodes.add(current);
            WaitingTask tmp = current.previous;
            current.previous = null;
            current = tmp;
        }
        Collections.reverse(waitingNodes);
        return waitingNodes;
    }

    private static class WaitingTask<T, R> {
        public final T wrappedTask;
        public final CompletableFuture<R> future = new CompletableFuture();
        public WaitingTask<T, R> previous;

        WaitingTask(T task) {
            this.wrappedTask = task;
        }
    }
}

