/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core;

import io.github.xanthic.cache.api.CacheProvider;
import io.github.xanthic.cache.api.domain.MisconfigurationPolicy;
import io.github.xanthic.cache.api.exception.NoDefaultCacheImplementationException;
import io.github.xanthic.cache.core.AbstractCacheProvider;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheApiSettings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheApiSettings.class);
    private final Map<Class<? extends CacheProvider>, CacheProvider> providers = Collections.synchronizedMap(new IdentityHashMap(16));
    private final AtomicReference<Class<? extends CacheProvider>> defaultCacheProvider = new AtomicReference();
    private volatile MisconfigurationPolicy defaultMisconfigurationPolicy = MisconfigurationPolicy.IGNORE;

    private CacheApiSettings() {
        this.populateProviders();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setDefaultCacheProvider(@NotNull CacheProvider provider) {
        Class<@NotNull ?> clazz = provider.getClass();
        this.registerCacheProvider(clazz, provider);
        this.defaultCacheProvider.set(clazz);
        log.debug("Xanthic: Default cache provider was set to {}.", (Object)clazz.getSimpleName());
    }

    @NotNull
    public CacheProvider getDefaultCacheProvider() {
        Class<? extends CacheProvider> clazz = this.defaultCacheProvider.get();
        if (clazz == null) {
            throw new NoDefaultCacheImplementationException("default cache provider is not set, no cache implementations available!");
        }
        CacheProvider provider = this.providers.get(clazz);
        if (provider == null) {
            log.trace("Xanthic: Constructing lazily registered cache provider {}...", (Object)clazz.getSimpleName());
            provider = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.providers.put(clazz, provider);
        }
        return provider;
    }

    public void registerCacheProvider(@NonNull Class<? extends CacheProvider> cacheProviderClass, @Nullable CacheProvider cacheProvider) {
        if (cacheProviderClass == null) {
            throw new NullPointerException("cacheProviderClass is marked non-null but is null");
        }
        if (this.providers.put(cacheProviderClass, cacheProvider) == null) {
            log.trace("Xanthic: Initially registered cache provider {}", (Object)cacheProviderClass.getCanonicalName());
        }
        if (this.defaultCacheProvider.compareAndSet(null, cacheProviderClass)) {
            log.info("Xanthic: Automatically set default cache provider to {}.", (Object)cacheProviderClass.getSimpleName());
        }
    }

    private void populateProviders() {
        ServiceLoader<AbstractCacheProvider> loader;
        log.debug("Xanthic: Registering canonical cache providers from the classpath...");
        try {
            loader = CacheApiSettings.getServiceLoader();
        }
        catch (ServiceConfigurationError e) {
            log.error("Failed to create CacheProvider service loader!", e);
            return;
        }
        TreeSet<AbstractCacheProvider> loaded = new TreeSet<AbstractCacheProvider>(Comparator.comparingInt(AbstractCacheProvider::getDiscoveryOrder).thenComparing(provider -> provider.getClass().getName()).thenComparingInt(Object::hashCode));
        Iterator<AbstractCacheProvider> it = loader.iterator();
        while (it.hasNext()) {
            AbstractCacheProvider provider2;
            try {
                provider2 = it.next();
            }
            catch (AccessControlException | ServiceConfigurationError e) {
                log.error("Failed to instantiate cache provider via service loader!", e);
                continue;
            }
            loaded.add(provider2);
        }
        loaded.forEach(provider -> this.registerCacheProvider((Class<? extends CacheProvider>)provider.getClass(), (CacheProvider)provider));
        log.debug("Xanthic: Loaded {} canonical cache provider(s) on settings construction!", (Object)this.providers.size());
    }

    @NotNull
    public static CacheApiSettings getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static ServiceLoader<AbstractCacheProvider> getServiceLoader() {
        ClassLoader classLoader = CacheApiSettings.class.getClassLoader();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(AbstractCacheProvider.class, classLoader);
            return AccessController.doPrivileged(action);
        }
        return ServiceLoader.load(AbstractCacheProvider.class, classLoader);
    }

    @Generated
    public MisconfigurationPolicy getDefaultMisconfigurationPolicy() {
        return this.defaultMisconfigurationPolicy;
    }

    @Generated
    public void setDefaultMisconfigurationPolicy(MisconfigurationPolicy defaultMisconfigurationPolicy) {
        this.defaultMisconfigurationPolicy = defaultMisconfigurationPolicy;
    }

    private static class SingletonHolder {
        private static final CacheApiSettings INSTANCE = new CacheApiSettings();

        private SingletonHolder() {
        }
    }
}

