/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core;

import io.github.xanthic.cache.api.CacheProvider;
import io.github.xanthic.cache.api.ICacheSpec;
import io.github.xanthic.cache.api.RemovalListener;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.api.exception.MisconfiguredCacheException;
import io.github.xanthic.cache.core.CacheApiSettings;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheApiSpec<K, V>
implements ICacheSpec<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheApiSpec.class);
    private CacheProvider provider;
    private Long maxSize;
    private Duration expiryTime;
    private ExpiryType expiryType;
    private RemovalListener<K, V> removalListener;
    private ScheduledExecutorService executor;
    private Boolean highContention;

    @Override
    @NotNull
    public CacheProvider provider() {
        return this.provider != null ? this.provider : CacheApiSettings.getInstance().getDefaultCacheProvider();
    }

    public void validate() {
        if (this.provider == null) {
            throw new MisconfiguredCacheException("provider must not be null! You have not set a provider and no default cache provider was found - see https://xanthic.github.io/provider/ for instructions on how to add cache providers to your project.");
        }
        if (this.maxSize != null && this.maxSize < 0L) {
            throw new MisconfiguredCacheException("maxSize may not be negative!");
        }
        if (this.expiryTime != null && this.expiryTime.isNegative()) {
            throw new MisconfiguredCacheException("expiryTime may not be negative!");
        }
        if (this.expiryTime != null && this.expiryType == null) {
            log.warn("Cache specification enables expiry time but does not specify ExpiryType");
        }
    }

    @NotNull
    public static <K, V> CacheApiSpec<K, V> process(@NotNull Consumer<CacheApiSpec<K, V>> spec) {
        CacheApiSpec<K, V> data = new CacheApiSpec<K, V>();
        spec.accept(data);
        if (data.provider == null) {
            data.provider(CacheApiSettings.getInstance().getDefaultCacheProvider());
            log.debug("No cache provider explicitly specified; cache defaults to {}!", (Object)data.provider.getClass().getCanonicalName());
        }
        data.validate();
        return data;
    }

    @Override
    @Generated
    public Long maxSize() {
        return this.maxSize;
    }

    @Override
    @Generated
    public Duration expiryTime() {
        return this.expiryTime;
    }

    @Override
    @Generated
    public ExpiryType expiryType() {
        return this.expiryType;
    }

    @Override
    @Generated
    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    @Override
    @Generated
    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    @Generated
    public Boolean highContention() {
        return this.highContention;
    }

    @Generated
    public CacheApiSpec<K, V> provider(CacheProvider provider) {
        this.provider = provider;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> maxSize(Long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> expiryTime(Duration expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> expiryType(ExpiryType expiryType) {
        this.expiryType = expiryType;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> removalListener(RemovalListener<K, V> removalListener) {
        this.removalListener = removalListener;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> executor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Generated
    public CacheApiSpec<K, V> highContention(Boolean highContention) {
        this.highContention = highContention;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheApiSpec)) {
            return false;
        }
        CacheApiSpec other = (CacheApiSpec)o;
        Long this$maxSize = this.maxSize();
        Long other$maxSize = other.maxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        Boolean this$highContention = this.highContention();
        Boolean other$highContention = other.highContention();
        if (this$highContention == null ? other$highContention != null : !((Object)this$highContention).equals(other$highContention)) {
            return false;
        }
        CacheProvider this$provider = this.provider();
        CacheProvider other$provider = other.provider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        Duration this$expiryTime = this.expiryTime();
        Duration other$expiryTime = other.expiryTime();
        if (this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime)) {
            return false;
        }
        ExpiryType this$expiryType = this.expiryType();
        ExpiryType other$expiryType = other.expiryType();
        if (this$expiryType == null ? other$expiryType != null : !((Object)((Object)this$expiryType)).equals((Object)other$expiryType)) {
            return false;
        }
        RemovalListener<K, V> this$removalListener = this.removalListener();
        RemovalListener<K, V> other$removalListener = other.removalListener();
        if (this$removalListener == null ? other$removalListener != null : !this$removalListener.equals(other$removalListener)) {
            return false;
        }
        ScheduledExecutorService this$executor = this.executor();
        ScheduledExecutorService other$executor = other.executor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxSize = this.maxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        Boolean $highContention = this.highContention();
        result = result * 59 + ($highContention == null ? 43 : ((Object)$highContention).hashCode());
        CacheProvider $provider = this.provider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        Duration $expiryTime = this.expiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        ExpiryType $expiryType = this.expiryType();
        result = result * 59 + ($expiryType == null ? 43 : ((Object)((Object)$expiryType)).hashCode());
        RemovalListener<K, V> $removalListener = this.removalListener();
        result = result * 59 + ($removalListener == null ? 43 : $removalListener.hashCode());
        ScheduledExecutorService $executor = this.executor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CacheApiSpec(provider=" + this.provider() + ", maxSize=" + this.maxSize() + ", expiryTime=" + this.expiryTime() + ", expiryType=" + (Object)((Object)this.expiryType()) + ", removalListener=" + this.removalListener() + ", executor=" + this.executor() + ", highContention=" + this.highContention() + ")";
    }

    @Generated
    private CacheApiSpec() {
    }
}

