/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core;

import io.github.xanthic.cache.api.Cache;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.0.0")
public abstract class LockedAbstractCache<K, V>
implements Cache<K, V> {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public V get(@NotNull K key) {
        return (V)this.read(() -> this.getUnlocked(key));
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        return (V)this.write(() -> {
            V old = this.getUnlocked(key);
            this.putUnlocked(key, value);
            return old;
        });
    }

    @Override
    public V remove(@NotNull K key) {
        return (V)this.write(() -> {
            V value = this.getUnlocked(key);
            this.removeUnlocked(key);
            return value;
        });
    }

    @Override
    public void clear() {
        this.write(() -> {
            this.clearUnlocked();
            return Void.TYPE;
        });
    }

    @Override
    public long size() {
        return this.read(this::sizeUnlocked);
    }

    @Override
    public V compute(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        return (V)this.write(() -> {
            V oldValue = this.getUnlocked(key);
            Object newValue = computeFunc.apply((K)key, (V)oldValue);
            if (newValue != null) {
                this.putUnlocked(key, newValue);
                return newValue;
            }
            if (oldValue != null) {
                this.removeUnlocked(key);
            }
            return null;
        });
    }

    @Override
    public V computeIfAbsent(@NotNull K key, @NotNull Function<K, V> computeFunc) {
        V oldOptimistic = this.get(key);
        if (oldOptimistic != null) {
            return oldOptimistic;
        }
        return (V)this.write(() -> {
            V old = this.getUnlocked(key);
            if (old != null) {
                return old;
            }
            Object computed = computeFunc.apply(key);
            this.putUnlocked(key, computed);
            return computed;
        });
    }

    @Override
    public V computeIfPresent(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        if (this.get(key) == null) {
            return null;
        }
        return (V)this.write(() -> {
            V oldValue = this.getUnlocked(key);
            if (oldValue != null) {
                Object newValue = computeFunc.apply((K)key, (V)oldValue);
                if (newValue != null) {
                    this.putUnlocked(key, newValue);
                    return newValue;
                }
                this.removeUnlocked(key);
            }
            return null;
        });
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldOptimistic = this.get(key);
        if (oldOptimistic != null) {
            return oldOptimistic;
        }
        return (V)this.write(() -> {
            V old = this.getUnlocked(key);
            if (old == null) {
                this.putUnlocked(key, value);
            }
            return old;
        });
    }

    @Override
    public V merge(@NotNull K key, @NotNull V value, @NotNull BiFunction<V, V, V> mergeFunc) {
        return (V)this.write(() -> {
            Object old = this.putIfAbsent(key, value);
            if (old == null) {
                return value;
            }
            Object merged = mergeFunc.apply(old, value);
            this.putUnlocked(key, merged);
            return merged;
        });
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V value) {
        if (this.get(key) == null) {
            return false;
        }
        return this.write(() -> {
            V old = this.getUnlocked(key);
            if (old == null) {
                return false;
            }
            this.putUnlocked(key, value);
            return true;
        });
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            return false;
        }
        V oldOptimistic = this.get(key);
        if (oldOptimistic == null) {
            return false;
        }
        if (!Objects.equals(oldValue, oldOptimistic)) {
            return false;
        }
        return this.write(() -> {
            if (Objects.equals(oldValue, this.getUnlocked(key))) {
                this.putUnlocked(key, newValue);
                return true;
            }
            return false;
        });
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.read(() -> {
            map.forEach(this::putUnlocked);
            return Void.TYPE;
        });
    }

    @Nullable
    protected abstract V getUnlocked(@NotNull K var1);

    protected abstract void putUnlocked(@NotNull K var1, @NotNull V var2);

    protected abstract void removeUnlocked(@NotNull K var1);

    protected abstract void clearUnlocked();

    protected abstract long sizeUnlocked();

    protected <T> T read(Supplier<T> reader) {
        this.lock.readLock().lock();
        try {
            T t2 = reader.get();
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected <T> T write(Supplier<T> writer) {
        this.lock.writeLock().lock();
        try {
            T t2 = writer.get();
            return t2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

