/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core.delegate;

import io.github.xanthic.cache.api.Cache;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyCache<K, V>
implements Cache<K, V> {
    private static final Cache INSTANCE = new EmptyCache();

    @ApiStatus.Internal
    public static <K, V> Cache<K, V> get() {
        return INSTANCE;
    }

    private EmptyCache() {
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        return null;
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @NotNull V value) {
        return null;
    }

    @Override
    @Nullable
    public V remove(@NotNull K key) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    @Nullable
    public V compute(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        return computeFunc.apply(key, null);
    }

    @Override
    public V computeIfAbsent(@NotNull K key, @NotNull Function<K, V> computeFunc) {
        return computeFunc.apply(key);
    }

    @Override
    @Nullable
    public V computeIfPresent(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        return null;
    }

    @Override
    @Nullable
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        return null;
    }

    @Override
    public V merge(@NotNull K key, @NotNull V value, @NotNull BiFunction<V, V, V> mergeFunc) {
        return value;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V value) {
        return false;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        return false;
    }

    @Override
    @NotNull
    public V getOrDefault(@NotNull K key, @NotNull V defaultValue) {
        return defaultValue;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> action) {
    }
}

