/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.provider.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import io.github.xanthic.cache.core.delegate.GenericMapCacheDelegate;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

final class CaffeineDelegate<K, V>
extends GenericMapCacheDelegate<K, V> {
    private final Cache<K, V> cache;

    public CaffeineDelegate(Cache<K, V> cache) {
        super(cache.asMap());
        this.cache = cache;
    }

    @Override
    public V get(@NotNull K key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public V computeIfAbsent(@NotNull K key, @NotNull Function<K, V> computeFunc) {
        return this.cache.get(key, computeFunc);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        this.cache.cleanUp();
        return this.cache.estimatedSize();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    @Generated
    public Cache<K, V> getCache() {
        return this.cache;
    }

    @Override
    @Generated
    public String toString() {
        return "CaffeineDelegate(cache=" + this.getCache() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineDelegate)) {
            return false;
        }
        CaffeineDelegate other = (CaffeineDelegate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cache<K, V> this$cache = this.getCache();
        Cache<K, V> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CaffeineDelegate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cache<K, V> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        return result;
    }
}

