/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.provider.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.ICacheSpec;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.api.domain.RemovalCause;
import io.github.xanthic.cache.core.AbstractCacheProvider;
import io.github.xanthic.cache.provider.caffeine.CaffeineDelegate;
import java.time.Duration;

public final class CaffeineProvider
extends AbstractCacheProvider {
    @Override
    public <K, V> Cache<K, V> build(ICacheSpec<K, V> spec) {
        Caffeine<Object, Object> builder = Caffeine.newBuilder();
        if (spec.maxSize() != null) {
            builder.maximumSize(spec.maxSize());
        }
        if (spec.executor() != null) {
            builder.scheduler(Scheduler.forScheduledExecutorService(spec.executor()));
        }
        if (spec.removalListener() != null) {
            builder.removalListener((key, value, cause) -> spec.removalListener().onRemoval(key, value, CaffeineProvider.getCause(cause)));
        }
        this.handleExpiration(spec.expiryTime(), spec.expiryType(), (time, type) -> {
            if (type == ExpiryType.POST_WRITE) {
                builder.expireAfterWrite((Duration)time);
            } else {
                builder.expireAfterAccess((Duration)time);
            }
        });
        return new CaffeineDelegate(builder.build());
    }

    private static RemovalCause getCause(com.github.benmanes.caffeine.cache.RemovalCause cause) {
        switch (cause) {
            case EXPLICIT: {
                return RemovalCause.MANUAL;
            }
            case REPLACED: {
                return RemovalCause.REPLACED;
            }
            case EXPIRED: {
                return RemovalCause.TIME;
            }
            case SIZE: {
                return RemovalCause.SIZE;
            }
        }
        return RemovalCause.OTHER;
    }

    @Override
    public int getDiscoveryOrder() {
        return 3;
    }
}

