/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.util.HashSet;
import java.util.List;
import rx.Observer;
import rx.SingleSubscriber;
import rx.annotations.Beta;
import rx.exceptions.CompositeException;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.exceptions.OnErrorThrowable;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException propagate(Throwable t2) {
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        throw new RuntimeException(t2);
    }

    public static void throwIfFatal(Throwable t2) {
        if (t2 instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)t2;
        }
        if (t2 instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)t2;
        }
        if (t2 instanceof OnCompletedFailedException) {
            throw (OnCompletedFailedException)t2;
        }
        if (t2 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t2;
        }
        if (t2 instanceof ThreadDeath) {
            throw (ThreadDeath)t2;
        }
        if (t2 instanceof LinkageError) {
            throw (LinkageError)t2;
        }
    }

    public static void addCause(Throwable e, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e = e.getCause()).getCause())) break;
            seenCauses.add(e.getCause());
        }
        try {
            e.initCause(cause);
        }
        catch (Throwable t2) {
            // empty catch block
        }
    }

    public static Throwable getFinalCause(Throwable e) {
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e = e.getCause();
        }
        return e;
    }

    public static void throwIfAny(List<? extends Throwable> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                Throwable t2 = exceptions.get(0);
                if (t2 instanceof RuntimeException) {
                    throw (RuntimeException)t2;
                }
                if (t2 instanceof Error) {
                    throw (Error)t2;
                }
                throw new RuntimeException(t2);
            }
            throw new CompositeException(exceptions);
        }
    }

    @Beta
    public static void throwOrReport(Throwable t2, Observer<?> o, Object value) {
        Exceptions.throwIfFatal(t2);
        o.onError(OnErrorThrowable.addValueAsLastCause(t2, value));
    }

    @Beta
    public static void throwOrReport(Throwable t2, SingleSubscriber<?> o, Object value) {
        Exceptions.throwIfFatal(t2);
        o.onError(OnErrorThrowable.addValueAsLastCause(t2, value));
    }

    @Beta
    public static void throwOrReport(Throwable t2, Observer<?> o) {
        Exceptions.throwIfFatal(t2);
        o.onError(t2);
    }

    @Beta
    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> subscriber) {
        Exceptions.throwIfFatal(throwable);
        subscriber.onError(throwable);
    }
}

