/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.internal.operators.NotificationLite;

public final class BlockingOperatorMostRecent {
    private BlockingOperatorMostRecent() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Iterable<T> mostRecent(final Observable<? extends T> source2, final T initialValue) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                MostRecentObserver<Object> mostRecentObserver = new MostRecentObserver<Object>(initialValue);
                source2.subscribe(mostRecentObserver);
                return mostRecentObserver.getIterable();
            }
        };
    }

    static final class MostRecentObserver<T>
    extends Subscriber<T> {
        final NotificationLite<T> nl = NotificationLite.instance();
        volatile Object value;

        MostRecentObserver(T value) {
            this.value = this.nl.next(value);
        }

        @Override
        public void onCompleted() {
            this.value = this.nl.completed();
        }

        @Override
        public void onError(Throwable e) {
            this.value = this.nl.error(e);
        }

        @Override
        public void onNext(T args2) {
            this.value = this.nl.next(args2);
        }

        public Iterator<T> getIterable() {
            return new Iterator<T>(){
                private Object buf;

                @Override
                public boolean hasNext() {
                    this.buf = MostRecentObserver.this.value;
                    return !MostRecentObserver.this.nl.isCompleted(this.buf);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T next() {
                    try {
                        if (this.buf == null) {
                            this.buf = MostRecentObserver.this.value;
                        }
                        if (MostRecentObserver.this.nl.isCompleted(this.buf)) {
                            throw new NoSuchElementException();
                        }
                        if (MostRecentObserver.this.nl.isError(this.buf)) {
                            throw Exceptions.propagate(MostRecentObserver.this.nl.getError(this.buf));
                        }
                        Object t2 = MostRecentObserver.this.nl.getValue(this.buf);
                        return t2;
                    }
                    finally {
                        this.buf = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Read only iterator");
                }
            };
        }
    }
}

