/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Completable;
import rx.CompletableSubscriber;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class CompletableFlatMapSingleToCompletable<T>
implements Completable.OnSubscribe {
    final Single<T> source;
    final Func1<? super T, ? extends Completable> mapper;

    public CompletableFlatMapSingleToCompletable(Single<T> source2, Func1<? super T, ? extends Completable> mapper) {
        this.source = source2;
        this.mapper = mapper;
    }

    @Override
    public void call(CompletableSubscriber t2) {
        SourceSubscriber<? super T> parent = new SourceSubscriber<T>(t2, this.mapper);
        t2.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class SourceSubscriber<T>
    extends SingleSubscriber<T>
    implements CompletableSubscriber {
        final CompletableSubscriber actual;
        final Func1<? super T, ? extends Completable> mapper;

        public SourceSubscriber(CompletableSubscriber actual, Func1<? super T, ? extends Completable> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSuccess(T value) {
            Completable c;
            try {
                c = this.mapper.call(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onError(ex);
                return;
            }
            if (c == null) {
                this.onError(new NullPointerException("The mapper returned a null Completable"));
                return;
            }
            c.subscribe(this);
        }

        @Override
        public void onError(Throwable error) {
            this.actual.onError(error);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.add(d);
        }
    }
}

