/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.operators.BackpressureUtils;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeDetach<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;

    public OnSubscribeDetach(Observable<T> source2) {
        this.source = source2;
    }

    @Override
    public void call(Subscriber<? super T> t2) {
        DetachSubscriber<? super T> parent = new DetachSubscriber<T>(t2);
        DetachProducer<? super T> producer = new DetachProducer<T>(parent);
        t2.add(producer);
        t2.setProducer(producer);
        this.source.unsafeSubscribe(parent);
    }

    static enum TerminatedProducer implements Producer
    {
        INSTANCE;


        @Override
        public void request(long n) {
        }
    }

    static final class DetachProducer<T>
    implements Producer,
    Subscription {
        final DetachSubscriber<T> parent;

        public DetachProducer(DetachSubscriber<T> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            this.parent.innerRequest(n);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.parent.isUnsubscribed();
        }

        @Override
        public void unsubscribe() {
            this.parent.innerUnsubscribe();
        }
    }

    static final class DetachSubscriber<T>
    extends Subscriber<T> {
        final AtomicReference<Subscriber<? super T>> actual;
        final AtomicReference<Producer> producer;
        final AtomicLong requested;

        public DetachSubscriber(Subscriber<? super T> actual) {
            this.actual = new AtomicReference<Subscriber<T>>(actual);
            this.producer = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onNext(T t2) {
            Subscriber<T> a = this.actual.get();
            if (a != null) {
                a.onNext(t2);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.producer.lazySet(TerminatedProducer.INSTANCE);
            Subscriber a = this.actual.getAndSet(null);
            if (a != null) {
                a.onError(e);
            } else {
                RxJavaHooks.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            this.producer.lazySet(TerminatedProducer.INSTANCE);
            Subscriber a = this.actual.getAndSet(null);
            if (a != null) {
                a.onCompleted();
            }
        }

        void innerRequest(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            Producer p = this.producer.get();
            if (p != null) {
                p.request(n);
            } else {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                p = this.producer.get();
                if (p != null && p != TerminatedProducer.INSTANCE) {
                    long r = this.requested.getAndSet(0L);
                    p.request(r);
                }
            }
        }

        @Override
        public void setProducer(Producer p) {
            if (this.producer.compareAndSet(null, p)) {
                long r = this.requested.getAndSet(0L);
                p.request(r);
            } else if (this.producer.get() != TerminatedProducer.INSTANCE) {
                throw new IllegalStateException("Producer already set!");
            }
        }

        void innerUnsubscribe() {
            this.producer.lazySet(TerminatedProducer.INSTANCE);
            this.actual.lazySet(null);
            this.unsubscribe();
        }
    }
}

