/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.operators.OnSubscribeFromIterable;
import rx.internal.util.ExceptionsUtils;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.ScalarSynchronousObservable;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.atomic.SpscLinkedArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeFlattenIterable<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<? extends T> source;
    final Func1<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    protected OnSubscribeFlattenIterable(Observable<? extends T> source2, Func1<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        this.source = source2;
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void call(Subscriber<? super R> t2) {
        final FlattenIterableSubscriber<? super T, ? super R> parent = new FlattenIterableSubscriber<T, R>(t2, this.mapper, this.prefetch);
        t2.add(parent);
        t2.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        this.source.unsafeSubscribe(parent);
    }

    public static <T, R> Observable<R> createFrom(Observable<? extends T> source2, Func1<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        if (source2 instanceof ScalarSynchronousObservable) {
            Object scalar = ((ScalarSynchronousObservable)source2).get();
            return Observable.create(new OnSubscribeScalarFlattenIterable(scalar, mapper));
        }
        return Observable.create(new OnSubscribeFlattenIterable<T, R>(source2, mapper, prefetch));
    }

    static final class OnSubscribeScalarFlattenIterable<T, R>
    implements Observable.OnSubscribe<R> {
        final T value;
        final Func1<? super T, ? extends Iterable<? extends R>> mapper;

        public OnSubscribeScalarFlattenIterable(T value, Func1<? super T, ? extends Iterable<? extends R>> mapper) {
            this.value = value;
            this.mapper = mapper;
        }

        @Override
        public void call(Subscriber<? super R> t2) {
            boolean b;
            Iterator<R> iterator2;
            try {
                Iterable<R> it = this.mapper.call(this.value);
                iterator2 = it.iterator();
                b = iterator2.hasNext();
            }
            catch (Throwable ex) {
                Exceptions.throwOrReport(ex, t2, this.value);
                return;
            }
            if (!b) {
                t2.onCompleted();
                return;
            }
            t2.setProducer(new OnSubscribeFromIterable.IterableProducer<R>(t2, iterator2));
        }
    }

    static final class FlattenIterableSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends Iterable<? extends R>> mapper;
        final long limit;
        final Queue<Object> queue;
        final AtomicReference<Throwable> error;
        final AtomicLong requested;
        final AtomicInteger wip;
        final NotificationLite<T> nl;
        volatile boolean done;
        long produced;
        Iterator<? extends R> active;

        public FlattenIterableSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.actual = actual;
            this.mapper = mapper;
            this.error = new AtomicReference();
            this.wip = new AtomicInteger();
            this.requested = new AtomicLong();
            this.nl = NotificationLite.instance();
            if (prefetch == Integer.MAX_VALUE) {
                this.limit = Long.MAX_VALUE;
                this.queue = new SpscLinkedArrayQueue<Object>(RxRingBuffer.SIZE);
            } else {
                this.limit = prefetch - (prefetch >> 2);
                this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(prefetch) : new SpscAtomicArrayQueue<Object>(prefetch);
            }
            this.request(prefetch);
        }

        @Override
        public void onNext(T t2) {
            if (!this.queue.offer(this.nl.next(t2))) {
                this.unsubscribe();
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (ExceptionsUtils.addThrowable(this.error, e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaHooks.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        void requestMore(long n) {
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                this.drain();
            } else if (n < 0L) {
                throw new IllegalStateException("n >= 0 required but it was " + n);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> actual = this.actual;
            Queue<Object> queue = this.queue;
            int missed = 1;
            while (true) {
                boolean b;
                Iterator<R> it;
                if ((it = this.active) == null) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = queue.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, actual, queue)) {
                        return;
                    }
                    if (!empty) {
                        long p = this.produced + 1L;
                        if (p == this.limit) {
                            this.produced = 0L;
                            this.request(p);
                        } else {
                            this.produced = p;
                        }
                        try {
                            Iterable<R> iterable = this.mapper.call(this.nl.getValue(v));
                            it = iterable.iterator();
                            b = it.hasNext();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.onError(ex);
                            continue;
                        }
                        if (!b) continue;
                        this.active = it;
                    }
                }
                if (it != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        R v;
                        if (this.checkTerminated(this.done, false, actual, queue)) {
                            return;
                        }
                        try {
                            v = it.next();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            it = null;
                            this.active = null;
                            this.onError(ex);
                            break;
                        }
                        actual.onNext(v);
                        if (this.checkTerminated(this.done, false, actual, queue)) {
                            return;
                        }
                        try {
                            b = it.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            it = null;
                            this.active = null;
                            this.onError(ex);
                            break;
                        }
                    }
                    if (e == r && this.checkTerminated(this.done, queue.isEmpty() && it == null, actual, queue)) {
                        return;
                    }
                    if (e != 0L) {
                        BackpressureUtils.produced(this.requested, e);
                    }
                    if (it == null) continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (a.isUnsubscribed()) {
                q.clear();
                this.active = null;
                return true;
            }
            if (d) {
                Throwable ex = this.error.get();
                if (ex != null) {
                    ex = ExceptionsUtils.terminate(this.error);
                    this.unsubscribe();
                    q.clear();
                    this.active = null;
                    a.onError(ex);
                    return true;
                }
                if (empty) {
                    a.onCompleted();
                    return true;
                }
            }
            return false;
        }
    }
}

