/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.observers.SerializedSubscriber;
import rx.observers.Subscribers;
import rx.subjects.PublishSubject;

public final class OperatorDelayWithSelector<T, V>
implements Observable.Operator<T, T> {
    final Observable<? extends T> source;
    final Func1<? super T, ? extends Observable<V>> itemDelay;

    public OperatorDelayWithSelector(Observable<? extends T> source2, Func1<? super T, ? extends Observable<V>> itemDelay) {
        this.source = source2;
        this.itemDelay = itemDelay;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> _child) {
        final SerializedSubscriber<? super T> child = new SerializedSubscriber<T>(_child);
        final PublishSubject delayedEmissions = PublishSubject.create();
        _child.add(Observable.merge(delayedEmissions).unsafeSubscribe(Subscribers.from(child)));
        return new Subscriber<T>(_child){

            @Override
            public void onCompleted() {
                delayedEmissions.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(final T t2) {
                try {
                    delayedEmissions.onNext(OperatorDelayWithSelector.this.itemDelay.call(t2).take(1).defaultIfEmpty(null).map(new Func1<V, T>(){

                        @Override
                        public T call(V v) {
                            return t2;
                        }
                    }));
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this);
                }
            }
        };
    }
}

