/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Notification;
import rx.Observable;
import rx.Subscriber;

public final class OperatorDematerialize<T>
implements Observable.Operator<T, Notification<T>> {
    public static OperatorDematerialize instance() {
        return Holder.INSTANCE;
    }

    OperatorDematerialize() {
    }

    @Override
    public Subscriber<? super Notification<T>> call(final Subscriber<? super T> child) {
        return new Subscriber<Notification<T>>(child){
            boolean terminated;

            @Override
            public void onNext(Notification<T> t2) {
                switch (t2.getKind()) {
                    case OnNext: {
                        if (this.terminated) break;
                        child.onNext(t2.getValue());
                        break;
                    }
                    case OnError: {
                        this.onError(t2.getThrowable());
                        break;
                    }
                    case OnCompleted: {
                        this.onCompleted();
                        break;
                    }
                    default: {
                        this.onError(new IllegalArgumentException("Unsupported notification type: " + t2));
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.terminated) {
                    this.terminated = true;
                    child.onError(e);
                }
            }

            @Override
            public void onCompleted() {
                if (!this.terminated) {
                    this.terminated = true;
                    child.onCompleted();
                }
            }
        };
    }

    static final class Holder {
        static final OperatorDematerialize<Object> INSTANCE = new OperatorDematerialize();

        Holder() {
        }
    }
}

