/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.producers.ProducerArbiter;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitchIfEmpty<T>
implements Observable.Operator<T, T> {
    private final Observable<? extends T> alternate;

    public OperatorSwitchIfEmpty(Observable<? extends T> alternate) {
        this.alternate = alternate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        SerialSubscription serial = new SerialSubscription();
        ProducerArbiter arbiter = new ProducerArbiter();
        ParentSubscriber<? extends T> parent = new ParentSubscriber<T>(child, serial, arbiter, this.alternate);
        serial.set(parent);
        child.add(serial);
        child.setProducer(arbiter);
        return parent;
    }

    static final class AlternateSubscriber<T>
    extends Subscriber<T> {
        private final ProducerArbiter arbiter;
        private final Subscriber<? super T> child;

        AlternateSubscriber(Subscriber<? super T> child, ProducerArbiter arbiter) {
            this.child = child;
            this.arbiter = arbiter;
        }

        @Override
        public void setProducer(Producer producer) {
            this.arbiter.setProducer(producer);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t2) {
            this.child.onNext(t2);
            this.arbiter.produced(1L);
        }
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private boolean empty = true;
        private final Subscriber<? super T> child;
        private final SerialSubscription serial;
        private final ProducerArbiter arbiter;
        private final Observable<? extends T> alternate;

        ParentSubscriber(Subscriber<? super T> child, SerialSubscription serial, ProducerArbiter arbiter, Observable<? extends T> alternate) {
            this.child = child;
            this.serial = serial;
            this.arbiter = arbiter;
            this.alternate = alternate;
        }

        @Override
        public void setProducer(Producer producer) {
            this.arbiter.setProducer(producer);
        }

        @Override
        public void onCompleted() {
            if (!this.empty) {
                this.child.onCompleted();
            } else if (!this.child.isUnsubscribed()) {
                this.subscribeToAlternate();
            }
        }

        private void subscribeToAlternate() {
            AlternateSubscriber<? super T> as = new AlternateSubscriber<T>(this.child, this.arbiter);
            this.serial.set(as);
            this.alternate.unsafeSubscribe(as);
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t2) {
            this.empty = false;
            this.child.onNext(t2);
            this.arbiter.produced(1L);
        }
    }
}

