/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;

public final class OperatorTakeLastTimed<T>
implements Observable.Operator<T, T> {
    final long ageMillis;
    final Scheduler scheduler;
    final int count;

    public OperatorTakeLastTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = -1;
    }

    public OperatorTakeLastTimed(int count, long time, TimeUnit unit, Scheduler scheduler) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.ageMillis = unit.toMillis(time);
        this.scheduler = scheduler;
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        final TakeLastTimedSubscriber<? super T> parent = new TakeLastTimedSubscriber<T>(subscriber, this.count, this.ageMillis, this.scheduler);
        subscriber.add(parent);
        subscriber.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        return parent;
    }

    static final class TakeLastTimedSubscriber<T>
    extends Subscriber<T>
    implements Func1<Object, T> {
        final Subscriber<? super T> actual;
        final long ageMillis;
        final Scheduler scheduler;
        final int count;
        final AtomicLong requested;
        final ArrayDeque<Object> queue;
        final ArrayDeque<Long> queueTimes;
        final NotificationLite<T> nl;

        public TakeLastTimedSubscriber(Subscriber<? super T> actual, int count, long ageMillis, Scheduler scheduler) {
            this.actual = actual;
            this.count = count;
            this.ageMillis = ageMillis;
            this.scheduler = scheduler;
            this.requested = new AtomicLong();
            this.queue = new ArrayDeque();
            this.queueTimes = new ArrayDeque();
            this.nl = NotificationLite.instance();
        }

        @Override
        public void onNext(T t2) {
            if (this.count != 0) {
                long now = this.scheduler.now();
                if (this.queue.size() == this.count) {
                    this.queue.poll();
                    this.queueTimes.poll();
                }
                this.evictOld(now);
                this.queue.offer(this.nl.next(t2));
                this.queueTimes.offer(now);
            }
        }

        protected void evictOld(long now) {
            Long time;
            long minTime = now - this.ageMillis;
            while ((time = this.queueTimes.peek()) != null && time < minTime) {
                this.queue.poll();
                this.queueTimes.poll();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.queue.clear();
            this.queueTimes.clear();
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            this.evictOld(this.scheduler.now());
            this.queueTimes.clear();
            BackpressureUtils.postCompleteDone(this.requested, this.queue, this.actual, this);
        }

        @Override
        public T call(Object t2) {
            return this.nl.getValue(t2);
        }

        void requestMore(long n) {
            BackpressureUtils.postCompleteRequest(this.requested, n, this.queue, this.actual, this);
        }
    }
}

