/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedSubscriber;
import rx.subjects.UnicastSubject;

public final class OperatorWindowWithObservable<T, U>
implements Observable.Operator<Observable<T>, T> {
    final Observable<U> other;
    static final Object NEXT_SUBJECT = new Object();
    static final NotificationLite<Object> NL = NotificationLite.instance();

    public OperatorWindowWithObservable(Observable<U> other) {
        this.other = other;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        SourceSubscriber sub = new SourceSubscriber(child);
        BoundarySubscriber bs = new BoundarySubscriber(sub);
        child.add(sub);
        child.add(bs);
        sub.replaceWindow();
        this.other.unsafeSubscribe(bs);
        return sub;
    }

    static final class BoundarySubscriber<T, U>
    extends Subscriber<U> {
        final SourceSubscriber<T> sub;

        public BoundarySubscriber(SourceSubscriber<T> sub) {
            this.sub = sub;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(U t2) {
            this.sub.replaceWindow();
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }

        @Override
        public void onCompleted() {
            this.sub.onCompleted();
        }
    }

    static final class SourceSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final Object guard;
        Observer<T> consumer;
        Observable<T> producer;
        boolean emitting;
        List<Object> queue;

        public SourceSubscriber(Subscriber<? super Observable<T>> child) {
            this.child = new SerializedSubscriber<Observable<? super Observable<T>>>(child);
            this.guard = new Object();
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNext(T t2) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(t2);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.emitValue(t2);
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void drain(List<Object> queue) {
            if (queue == null) {
                return;
            }
            for (Object o : queue) {
                if (o == NEXT_SUBJECT) {
                    this.replaceSubject();
                    continue;
                }
                if (NL.isError(o)) {
                    this.error(NL.getError(o));
                    break;
                }
                if (NL.isCompleted(o)) {
                    this.complete();
                    break;
                }
                Object t2 = o;
                this.emitValue(t2);
            }
        }

        void replaceSubject() {
            Observer<T> s2 = this.consumer;
            if (s2 != null) {
                s2.onCompleted();
            }
            this.createNewWindow();
            this.child.onNext(this.producer);
        }

        void createNewWindow() {
            UnicastSubject bus = UnicastSubject.create();
            this.consumer = bus;
            this.producer = bus;
        }

        void emitValue(T t2) {
            Observer<T> s2 = this.consumer;
            if (s2 != null) {
                s2.onNext(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    this.queue = Collections.singletonList(NL.error(e));
                    return;
                }
                this.queue = null;
                this.emitting = true;
            }
            this.error(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NL.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            try {
                this.drain(localQueue);
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void replaceWindow() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NEXT_SUBJECT);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.replaceSubject();
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void complete() {
            Observer<T> s2 = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s2 != null) {
                s2.onCompleted();
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        void error(Throwable e) {
            Observer<T> s2 = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s2 != null) {
                s2.onError(e);
            }
            this.child.onError(e);
            this.unsubscribe();
        }
    }
}

