/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.plugins.RxJavaHooks;

public final class SingleDoAfterTerminate<T>
implements Single.OnSubscribe<T> {
    final Single<T> source;
    final Action0 action;

    public SingleDoAfterTerminate(Single<T> source2, Action0 action) {
        this.source = source2;
        this.action = action;
    }

    @Override
    public void call(SingleSubscriber<? super T> t2) {
        SingleDoAfterTerminateSubscriber<? super T> parent = new SingleDoAfterTerminateSubscriber<T>(t2, this.action);
        t2.add(parent);
        this.source.subscribe(parent);
    }

    static final class SingleDoAfterTerminateSubscriber<T>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final Action0 action;

        public SingleDoAfterTerminateSubscriber(SingleSubscriber<? super T> actual, Action0 action) {
            this.actual = actual;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(T value) {
            try {
                this.actual.onSuccess(value);
            }
            finally {
                this.doAction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable error) {
            try {
                this.actual.onError(error);
            }
            finally {
                this.doAction();
            }
        }

        void doAction() {
            try {
                this.action.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaHooks.onError(ex);
            }
        }
    }
}

