/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.producers;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.internal.operators.BackpressureUtils;
import rx.internal.util.atomic.SpscLinkedAtomicQueue;
import rx.internal.util.unsafe.SpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class QueuedValueProducer<T>
extends AtomicLong
implements Producer {
    private static final long serialVersionUID = 7277121710709137047L;
    final Subscriber<? super T> child;
    final Queue<Object> queue;
    final AtomicInteger wip;
    static final Object NULL_SENTINEL = new Object();

    public QueuedValueProducer(Subscriber<? super T> child) {
        this(child, UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
    }

    public QueuedValueProducer(Subscriber<? super T> child, Queue<Object> queue) {
        this.child = child;
        this.queue = queue;
        this.wip = new AtomicInteger();
    }

    @Override
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n > 0L) {
            BackpressureUtils.getAndAddRequest(this, n);
            this.drain();
        }
    }

    public boolean offer(T value) {
        if (value == null ? !this.queue.offer(NULL_SENTINEL) : !this.queue.offer(value)) {
            return false;
        }
        this.drain();
        return true;
    }

    private void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Subscriber<Object> c = this.child;
            Queue<Object> q = this.queue;
            do {
                Object v;
                if (c.isUnsubscribed()) {
                    return;
                }
                this.wip.lazySet(1);
                long r = this.get();
                long e = 0L;
                while (r != 0L && (v = q.poll()) != null) {
                    try {
                        if (v == NULL_SENTINEL) {
                            c.onNext(null);
                        } else {
                            Object t2 = v;
                            c.onNext(t2);
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, c, v != NULL_SENTINEL ? v : null);
                        return;
                    }
                    if (c.isUnsubscribed()) {
                        return;
                    }
                    --r;
                    ++e;
                }
                if (e == 0L || this.get() == Long.MAX_VALUE) continue;
                this.addAndGet(-e);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

