/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.atomic.SpscLinkedAtomicQueue;
import rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import rx.internal.util.unsafe.SpscLinkedQueue;
import rx.internal.util.unsafe.SpscUnboundedArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.subjects.Subject;

@Experimental
public final class UnicastSubject<T>
extends Subject<T, T> {
    final State<T> state;

    public static <T> UnicastSubject<T> create() {
        return UnicastSubject.create(16);
    }

    public static <T> UnicastSubject<T> create(int capacityHint) {
        State state = new State(capacityHint, null);
        return new UnicastSubject(state);
    }

    public static <T> UnicastSubject<T> create(int capacityHint, Action0 onTerminated) {
        State state = new State(capacityHint, onTerminated);
        return new UnicastSubject(state);
    }

    private UnicastSubject(State<T> state) {
        super(state);
        this.state = state;
    }

    @Override
    public void onNext(T t2) {
        this.state.onNext(t2);
    }

    @Override
    public void onError(Throwable e) {
        this.state.onError(e);
    }

    @Override
    public void onCompleted() {
        this.state.onCompleted();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscriber.get() != null;
    }

    static final class State<T>
    extends AtomicLong
    implements Producer,
    Observer<T>,
    Observable.OnSubscribe<T>,
    Subscription {
        private static final long serialVersionUID = -9044104859202255786L;
        final AtomicReference<Subscriber<? super T>> subscriber;
        final Queue<Object> queue;
        final NotificationLite<T> nl = NotificationLite.instance();
        final AtomicReference<Action0> terminateOnce;
        Throwable error;
        volatile boolean done;
        boolean emitting;
        boolean missed;
        volatile boolean caughtUp;

        public State(int capacityHint, Action0 onTerminated) {
            this.subscriber = new AtomicReference();
            AtomicReference<Action0> atomicReference = this.terminateOnce = onTerminated != null ? new AtomicReference<Action0>(onTerminated) : null;
            Queue<Object> q = capacityHint > 1 ? (UnsafeAccess.isUnsafeAvailable() ? new SpscUnboundedArrayQueue(capacityHint) : new SpscUnboundedAtomicArrayQueue(capacityHint)) : (UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
            this.queue = q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            if (!this.done) {
                if (!this.caughtUp) {
                    boolean stillReplay = false;
                    State state = this;
                    synchronized (state) {
                        if (!this.caughtUp) {
                            this.queue.offer(this.nl.next(t2));
                            stillReplay = true;
                        }
                    }
                    if (stillReplay) {
                        this.replay();
                        return;
                    }
                }
                Subscriber<T> s2 = this.subscriber.get();
                try {
                    s2.onNext(t2);
                }
                catch (Throwable ex) {
                    Exceptions.throwOrReport(ex, s2, t2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.doTerminate();
                this.error = e;
                this.done = true;
                if (!this.caughtUp) {
                    boolean stillReplay;
                    State state = this;
                    synchronized (state) {
                        stillReplay = !this.caughtUp;
                    }
                    if (stillReplay) {
                        this.replay();
                        return;
                    }
                }
                this.subscriber.get().onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            if (!this.done) {
                this.doTerminate();
                this.done = true;
                if (!this.caughtUp) {
                    boolean stillReplay;
                    State state = this;
                    synchronized (state) {
                        stillReplay = !this.caughtUp;
                    }
                    if (stillReplay) {
                        this.replay();
                        return;
                    }
                }
                this.subscriber.get().onCompleted();
            }
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required");
            }
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest(this, n);
                this.replay();
            } else if (this.done) {
                this.replay();
            }
        }

        @Override
        public void call(Subscriber<? super T> subscriber) {
            if (this.subscriber.compareAndSet(null, subscriber)) {
                subscriber.add(this);
                subscriber.setProducer(this);
            } else {
                subscriber.onError(new IllegalStateException("Only a single subscriber is allowed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replay() {
            State state = this;
            synchronized (state) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            Queue<Object> q = this.queue;
            while (true) {
                Subscriber<T> s2 = this.subscriber.get();
                boolean unlimited = false;
                if (s2 != null) {
                    boolean d = this.done;
                    boolean empty = q.isEmpty();
                    if (this.checkTerminated(d, empty, s2)) {
                        return;
                    }
                    long r = this.get();
                    unlimited = r == Long.MAX_VALUE;
                    long e = 0L;
                    while (r != 0L) {
                        d = this.done;
                        Object v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, s2)) {
                            return;
                        }
                        if (empty) break;
                        T value = this.nl.getValue(v);
                        try {
                            s2.onNext(value);
                        }
                        catch (Throwable ex) {
                            q.clear();
                            Exceptions.throwIfFatal(ex);
                            s2.onError(OnErrorThrowable.addValueAsLastCause(ex, value));
                            return;
                        }
                        --r;
                        ++e;
                    }
                    if (!unlimited && e != 0L) {
                        this.addAndGet(-e);
                    }
                }
                State state2 = this;
                synchronized (state2) {
                    if (!this.missed) {
                        if (unlimited && q.isEmpty()) {
                            this.caughtUp = true;
                        }
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe() {
            this.doTerminate();
            this.done = true;
            State state = this;
            synchronized (state) {
                if (this.emitting) {
                    return;
                }
                this.emitting = true;
            }
            this.queue.clear();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.done;
        }

        boolean checkTerminated(boolean done, boolean empty, Subscriber<? super T> s2) {
            if (s2.isUnsubscribed()) {
                this.queue.clear();
                return true;
            }
            if (done) {
                Throwable e = this.error;
                if (e != null) {
                    this.queue.clear();
                    s2.onError(e);
                    return true;
                }
                if (empty) {
                    s2.onCompleted();
                    return true;
                }
            }
            return false;
        }

        void doTerminate() {
            Action0 a;
            AtomicReference<Action0> ref = this.terminateOnce;
            if (ref != null && (a = ref.get()) != null && ref.compareAndSet(a, null)) {
                a.call();
            }
        }
    }
}

