/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe;

import builderb0y.bigglobe.blockEntities.BigGlobeBlockEntityTypes;
import builderb0y.bigglobe.blocks.BigGlobeBlocks;
import builderb0y.bigglobe.blocks.SoulCauldronBlock;
import builderb0y.bigglobe.brewing.BigGlobeBrewing;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.EmptyChunkGenerator;
import builderb0y.bigglobe.commands.BigGlobeArgumentTypes;
import builderb0y.bigglobe.commands.BigGlobeCommands;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.dispensers.BigGlobeDispenserBehaviors;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.entities.BigGlobeEntityTypes;
import builderb0y.bigglobe.features.BigGlobeFeatures;
import builderb0y.bigglobe.fluids.BigGlobeFluids;
import builderb0y.bigglobe.gamerules.BigGlobeGameRules;
import builderb0y.bigglobe.items.BigGlobeItems;
import builderb0y.bigglobe.loot.BigGlobeLoot;
import builderb0y.bigglobe.mixins.MinecraftServer_SessionAccess;
import builderb0y.bigglobe.mixins.SpawnRestriction_BackingMapAccess;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.particles.BigGlobeParticles;
import builderb0y.bigglobe.recipes.BigGlobeRecipeSerializers;
import builderb0y.bigglobe.sounds.BigGlobeSoundEvents;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.placement.BigGlobeStructurePlacementTypes;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import builderb0y.scripting.parsing.ExpressionParser;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7145;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigGlobeMod
implements ModInitializer {
    public static final String MODID = "bigglobe";
    public static final String MODNAME = "Big Globe";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Big Globe");
    public static final boolean REGEN_WORLDS = Boolean.getBoolean("bigglobe.regenWorlds");
    public static final boolean MIXIN_AUDIT = Boolean.getBoolean("bigglobe.mixinAudit");
    public static final class_5321<class_7145> BIG_GLOBE_WORLD_PRESET_KEY = class_5321.method_29179((class_5321)class_7924.field_41250, (class_2960)BigGlobeMod.modID("bigglobe"));
    public static MinecraftServer currentServer;
    public static BetterRegistry.Lookup currentRegistries;
    public static class_3300 currentResourceManager;

    public void onInitialize() {
        LOGGER.info("Initializing...");
        BigGlobeConfig.init();
        BigGlobeLoot.init();
        BigGlobeFluids.init();
        BigGlobeBlocks.init();
        BigGlobeItems.init();
        BigGlobeBlockEntityTypes.init();
        BigGlobeEntityTypes.init();
        BigGlobeSoundEvents.init();
        SoulCauldronBlock.init();
        BigGlobeDispenserBehaviors.init();
        BigGlobeBrewing.init();
        BigGlobeFeatures.init();
        BigGlobeStructures.init();
        BigGlobeStructurePlacementTypes.init();
        BigGlobeScriptedChunkGenerator.init();
        EmptyChunkGenerator.init();
        BigGlobeArgumentTypes.init();
        BigGlobeCommands.init();
        BigGlobeGameRules.init();
        BigGlobeNetwork.init();
        BigGlobeRecipeSerializers.init();
        ExpressionParser.clinit();
        BigGlobeParticles.init();
        DistantHorizonsCompat.init();
        Map<class_1299<?>, Object> restrictions = SpawnRestriction_BackingMapAccess.bigglobe_getRestrictions();
        restrictions.putIfAbsent(class_1299.field_23696, restrictions.get(class_1299.field_21973));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            currentServer = server;
            currentRegistries = new BetterRegistry.Lookup(){
                final /* synthetic */ BigGlobeMod this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public <T> BetterRegistry<T> getRegistry(class_5321<class_2378<T>> key) {
                    return new BetterRegistry.BetterHardCodedRegistry<T>(RegistryVersions.getRegistry((class_5455)server.method_30611(), key));
                }
            };
            currentResourceManager = new DelegatingResourceManager(() -> ((MinecraftServer)server).method_34864());
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            currentServer = null;
            currentRegistries = null;
            currentResourceManager = null;
        });
        if (REGEN_WORLDS) {
            LOGGER.error("################################################################");
            LOGGER.error("Warning! -Dbigglobe.regenWorlds is set to true in your java arguments!");
            LOGGER.error("THIS WILL DELETE EVERYTHING IN YOUR WORLDS!");
            LOGGER.error("If you care about your worlds, CLOSE THE GAME NOW AND REMOVE THIS FROM YOUR JAVA ARGUMENTS!");
            LOGGER.error("################################################################");
            ServerLifecycleEvents.SERVER_STARTING.register(BigGlobeMod::regenWorlds);
        }
        LOGGER.info("Done initializing.");
    }

    public static MinecraftServer getCurrentServer() {
        if (currentServer != null) {
            return currentServer;
        }
        throw new IllegalStateException("No server is running.");
    }

    public static BetterRegistry.Lookup getCurrentRegistries() {
        BetterRegistry.Lookup registries = currentRegistries;
        if (registries != null) {
            return registries;
        }
        throw new IllegalStateException("Registries not available at this time.");
    }

    public static <T> BetterRegistry<T> getRegistry(class_5321<? extends class_2378<? extends T>> key) {
        return BigGlobeMod.getCurrentRegistries().getRegistry(key);
    }

    public static <T> BetterRegistry<T> getSidedRegistry(class_5321<? extends class_2378<? extends T>> key, boolean client) {
        return client ? BigGlobeMod.getClientRegistry(key) : BigGlobeMod.getRegistry(key);
    }

    public static <T> BetterRegistry<T> getClientRegistry(class_5321<? extends class_2378<? extends T>> key) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return BigGlobeMod.getClientRegistry0(key);
        }
        throw new IllegalStateException("Calling getClientRegistry() on dedicated server!");
    }

    @Environment(value=EnvType.CLIENT)
    public static <T> BetterRegistry<T> getClientRegistry0(class_5321<? extends class_2378<? extends T>> key) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_2378 registry = world.method_30349().method_33310(key).orElse(null);
            if (registry != null) {
                return new BetterRegistry.BetterHardCodedRegistry(registry);
            }
            throw new IllegalStateException("Client registry " + String.valueOf(key.method_29177()) + " not available");
        }
        throw new IllegalStateException("Client registries not available");
    }

    public static class_3300 getResourceManager() {
        if (currentResourceManager != null) {
            return currentResourceManager;
        }
        throw new IllegalStateException("Resources not available at this time.");
    }

    @NotNull
    public static class_2960 modID(@NotNull String path) {
        return IdentifierVersions.create(MODID, path);
    }

    @NotNull
    public static class_2960 mcID(@NotNull String path) {
        return IdentifierVersions.vanilla(path);
    }

    public static <T> class_2370<T> newRegistry(class_5321<class_2378<T>> key) {
        return (class_2370)FabricRegistryBuilder.from((class_2385)new class_2370(key, Lifecycle.experimental())).buildAndRegister();
    }

    public static void regenWorlds(MinecraftServer server) {
        if (!server.method_3790().method_8388()) {
            Path voxy;
            class_32.class_5143 session = ((MinecraftServer_SessionAccess)server).bigglobe_getSession();
            MutableBoolean deletedAnything = new MutableBoolean(false);
            RegistryVersions.getRegistry((class_5455)server.method_30611(), class_7924.field_41224).method_40270().filter(options -> ((class_5363)options.comp_349()).comp_1013() instanceof BigGlobeScriptedChunkGenerator).peek(options -> LOGGER.info("Found Big Globe dimension " + String.valueOf(UnregisteredObjectException.getKey(options)))).map(options -> session.method_27424(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)UnregisteredObjectException.getID(options)))).flatMap(dimensionFolder -> Stream.of("advancements", "data", "entities", "playerdata", "poi", "region", "stats").map(dimensionFolder::resolve)).forEach(toDelete -> {
                if (Files.exists(toDelete, new LinkOption[0])) {
                    try {
                        deletedAnything.setTrue();
                        PathUtils.deleteDirectory((Path)toDelete);
                        LOGGER.info("Deleted " + String.valueOf(toDelete));
                    }
                    catch (Exception exception) {
                        LOGGER.error("Could not delete " + String.valueOf(toDelete), (Throwable)exception);
                    }
                }
            });
            if (deletedAnything.isTrue() && Files.exists(voxy = session.method_27424(class_1937.field_25179).resolve("voxy"), new LinkOption[0])) {
                try {
                    PathUtils.deleteDirectory((Path)voxy);
                    LOGGER.info("Deleted " + String.valueOf(voxy));
                }
                catch (Exception exception) {
                    LOGGER.error("Could not delete " + String.valueOf(voxy), (Throwable)exception);
                }
            }
        }
    }

    public static class DelegatingResourceManager
    implements class_3300 {
        public final Supplier<class_3300> delegate;

        public DelegatingResourceManager(Supplier<class_3300> delegate) {
            this.delegate = delegate;
        }

        public Set<String> method_14487() {
            return this.delegate.get().method_14487();
        }

        public List<class_3298> method_14489(class_2960 id) {
            return this.delegate.get().method_14489(id);
        }

        public Map<class_2960, class_3298> method_14488(String startingPath, Predicate<class_2960> allowedPathPredicate) {
            return this.delegate.get().method_14488(startingPath, allowedPathPredicate);
        }

        public Map<class_2960, List<class_3298>> method_41265(String startingPath, Predicate<class_2960> allowedPathPredicate) {
            return this.delegate.get().method_41265(startingPath, allowedPathPredicate);
        }

        public Stream<class_3262> method_29213() {
            return this.delegate.get().method_29213();
        }

        public Optional<class_3298> method_14486(class_2960 id) {
            return this.delegate.get().method_14486(id);
        }
    }
}

