/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.blocks;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CloudColor {
    RED("red_aura_infused_cloud", "red_aura_infused_void_cloud", "red_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.0)),
    ORANGE("orange_aura_infused_cloud", "orange_aura_infused_void_cloud", "orange_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.08333333333333333)),
    YELLOW("yellow_aura_infused_cloud", "yellow_aura_infused_void_cloud", "yellow_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.16666666666666666)),
    YELLOW_GREEN("yellow_green_aura_infused_cloud", "yellow_green_aura_infused_void_cloud", "yellow_green_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.25)),
    GREEN("green_aura_infused_cloud", "green_aura_infused_void_cloud", "green_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.3333333333333333)),
    CYAN_GREEN("cyan_green_aura_infused_cloud", "cyan_green_aura_infused_void_cloud", "cyan_green_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.4166666666666667)),
    CYAN("cyan_aura_infused_cloud", "cyan_aura_infused_void_cloud", "cyan_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.5)),
    CYAN_BLUE("cyan_blue_aura_infused_cloud", "cyan_blue_aura_infused_void_cloud", "cyan_blue_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.5833333333333334)),
    BLUE("blue_aura_infused_cloud", "blue_aura_infused_void_cloud", "blue_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.6666666666666666)),
    PURPLE("purple_aura_infused_cloud", "purple_aura_infused_void_cloud", "purple_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.75)),
    MAGENTA("magenta_aura_infused_cloud", "magenta_aura_infused_void_cloud", "magenta_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.8333333333333334)),
    MAGENTA_RED("magenta_red_aura_infused_cloud", "magenta_red_aura_infused_void_cloud", "magenta_red_bottled_aura", (Vector3dc)CloudColor.smoothHue(0.9166666666666666)),
    RAINBOW("omni_aura_infused_cloud", "omni_aura_infused_void_cloud", "omni_bottled_aura", null){

        @Override
        public Vector3dc getColor(double timeFraction) {
            return 1.smoothHue(timeFraction);
        }
    }
    ,
    BLANK("cloud", "void_cloud", null, null);

    public static final CloudColor[] VALUES;
    public final String normalName;
    public final String voidName;
    public final String bottleName;
    @Nullable
    public final Vector3dc color;

    private CloudColor(String normalName, @Nullable String voidName, String bottleName, Vector3dc color) {
        this.normalName = normalName;
        this.voidName = voidName;
        this.bottleName = bottleName;
        this.color = color;
    }

    @Nullable
    public Vector3dc getColor(double timeFraction) {
        return this.color;
    }

    public static Vector3d smoothHue(double hue) {
        double red = hue *= Math.PI * 2;
        double green = hue - 2.0943951023931953;
        double blue = hue - 4.1887902047863905;
        red = Math.cos(red) * 0.5 + 0.5;
        green = Math.cos(green) * 0.5 + 0.5;
        blue = Math.cos(blue) * 0.5 + 0.5;
        red *= red;
        green *= green;
        blue *= blue;
        double scalar = 1.0 / Math.sqrt(BigGlobeMath.squareD(red, green, blue));
        red *= scalar;
        green *= scalar;
        blue *= scalar;
        red = Math.sqrt(red);
        green = Math.sqrt(green);
        blue = Math.sqrt(blue);
        return new Vector3d(red, green, blue);
    }

    public static int packARGB(Vector3dc color) {
        int r = Interpolator.clamp(0, 255, (int)(color.x() * 256.0));
        int g = Interpolator.clamp(0, 255, (int)(color.y() * 256.0));
        int b = Interpolator.clamp(0, 255, (int)(color.z() * 256.0));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    static {
        VALUES = CloudColor.values();
    }
}

