/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen;

import builderb0y.autocodec.annotations.AddPseudoField;
import builderb0y.autocodec.annotations.Hidden;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.annotations.VerifySizeRange;
import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.RecordCoder;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.StringData;
import builderb0y.autocodec.data.UnknownData;
import builderb0y.autocodec.decoders.AutoDecoder;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.AutoEncoder;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.util.ObjectArrayFactory;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.ClientState;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.QuadHolder;
import builderb0y.bigglobe.chunkgen.ScriptedColumnBiomeSource;
import builderb0y.bigglobe.chunkgen.SectionGenerationContext;
import builderb0y.bigglobe.chunkgen.perSection.SectionUtil;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.VerifyDivisibleBy16;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ColumnValueHolder;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.columns.scripted.dependencies.CyclicDependencyAnalyzer;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyDepthSorter;
import builderb0y.bigglobe.columns.scripted.traits.TraitLoader;
import builderb0y.bigglobe.columns.scripted.traits.WorldTrait;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraitProvider;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraits;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.compat.ValkyrienSkiesCompat;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.features.RockReplacerFeature;
import builderb0y.bigglobe.features.dispatch.FeatureDispatchers;
import builderb0y.bigglobe.mixins.Heightmap_StorageAccess;
import builderb0y.bigglobe.mixins.StructureAccessor_WorldAccess;
import builderb0y.bigglobe.mixins.StructureStart_ChildrenGetter;
import builderb0y.bigglobe.noise.MojangPermuter;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.overriders.ColumnValueOverrider;
import builderb0y.bigglobe.overriders.Overrider;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.spawning.ExtraSpawn;
import builderb0y.bigglobe.structures.ActiveStructureManager;
import builderb0y.bigglobe.structures.InactiveStructureManager;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.structures.ScriptStructures;
import builderb0y.bigglobe.structures.StructureManager;
import builderb0y.bigglobe.structures.placement.StreamableStructurePlacement;
import builderb0y.bigglobe.util.Async;
import builderb0y.bigglobe.util.AsyncConsumer;
import builderb0y.bigglobe.util.AsyncRunner;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.SymmetricOffset;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.util.WorldOrChunk;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import builderb0y.bigglobe.versions.SpawnEntryVersions;
import builderb0y.bigglobe.versions.TracyWrapper;
import builderb0y.scripting.parsing.ScriptParsingException;
import com.google.common.base.Predicates;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_1317;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6012;
import net.minecraft.class_6490;
import net.minecraft.class_6624;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7061;
import net.minecraft.class_7138;
import net.minecraft.class_7225;
import net.minecraft.class_7869;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AddPseudoField.AddPseudoFields(value={@AddPseudoField(value="biome_source"), @AddPseudoField(value="decodeContext")})
@UseCoder(name="createCoder", usage=MemberUsage.METHOD_IS_FACTORY)
public class BigGlobeScriptedChunkGenerator
extends class_2794
implements ColumnEntryRegistry.DelayedCompileable {
    public static final boolean WORLD_SLICES = false;
    public static final AtomicBoolean TRACE_OPERATION = new AtomicBoolean(false);
    public static final Codec<BigGlobeScriptedChunkGenerator> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(BigGlobeScriptedChunkGenerator.class).codec();
    public final @VerifyNullable String reload_preset;
    public final @VerifyNullable String reload_dimension;
    public final Height height;
    public final class_6880<Layer> layer;
    public final FeatureDispatchers feature_dispatcher;
    public final DelayedEntryList<Overrider> overriders;
    public final  @VerifyNullable ColumnScript.ColumnRandomToBooleanScript.Holder spawn_point;
    public final @VerifyNullable ColorOverrides colors;
    public final @VerifyNullable class_6880<class_2975<?, ?>> grass_bonemeal_feature;
    public final @VerifyNullable NetherOverrides nether_overrides;
    public final @VerifyNullable EndOverrides end_overrides;
    public final @VerifyNullable CreakingOverrides creaking_overrides;
    public final @VerifyNullable class_2960 world_traits;
    public transient Map<class_6880<WorldTrait>, WorldTraitProvider> loadedWorldTraits;
    public transient WorldTraits compiledWorldTraits;
    public transient ColumnEntryRegistry columnEntryRegistry;
    public final BetterRegistry<ExtraSpawn> extraSpawnRegistry;
    public final transient Map<BiomeSpawnGroup, class_6012<class_5483.class_1964>> extraSpawns;
    public transient Overrider.SortedOverriders actualOverriders;
    public transient long columnSeed;
    public transient boolean seedSet;
    public transient Pattern displayPattern;
    public transient DisplayEntry rootDebugDisplay;
    public transient ThreadLocal<ScriptedColumn[]> chunkReuseColumns;
    public transient StructureManager structureManager;

    public BigGlobeScriptedChunkGenerator(DecodeContext<?> decodeContext, @VerifyNullable String reload_preset, @VerifyNullable String reload_dimension, Height height, class_6880<Layer> layer, FeatureDispatchers feature_dispatcher, class_1966 biome_source, DelayedEntryList<Overrider> overriders,  @VerifyNullable ColumnScript.ColumnRandomToBooleanScript.Holder spawn_point, @VerifyNullable ColorOverrides colors, @VerifyNullable class_6880<class_2975<?, ?>> grass_bonemeal_feature, @VerifyNullable NetherOverrides nether_overrides, @VerifyNullable EndOverrides end_overrides, @VerifyNullable CreakingOverrides creaking_overrides, @VerifyNullable class_2960 world_traits, BetterRegistry<ExtraSpawn> extraSpawnRegistry) throws VerifyException {
        super(biome_source);
        if (biome_source instanceof ScriptedColumnBiomeSource) {
            ScriptedColumnBiomeSource source = (ScriptedColumnBiomeSource)biome_source;
            source.generator = this;
        }
        this.reload_preset = reload_preset;
        this.reload_dimension = reload_dimension;
        this.height = height;
        this.layer = layer;
        this.feature_dispatcher = feature_dispatcher;
        this.overriders = overriders;
        this.spawn_point = spawn_point;
        this.colors = colors;
        this.grass_bonemeal_feature = grass_bonemeal_feature;
        this.nether_overrides = nether_overrides;
        this.end_overrides = end_overrides;
        this.creaking_overrides = creaking_overrides;
        this.world_traits = world_traits;
        this.extraSpawnRegistry = extraSpawnRegistry;
        this.loadedWorldTraits = TraitLoader.load(world_traits, decodeContext);
        this.rootDebugDisplay = new DisplayEntry(this);
        this.extraSpawns = Collections.synchronizedMap(new HashMap(64));
    }

    @Hidden
    public BigGlobeScriptedChunkGenerator(BigGlobeScriptedChunkGenerator from) {
        super(BigGlobeScriptedChunkGenerator.copyBiomeSource(from.field_12761));
        this.reload_preset = from.reload_preset;
        this.reload_dimension = from.reload_dimension;
        this.columnEntryRegistry = from.columnEntryRegistry;
        this.height = from.height;
        this.layer = from.layer;
        this.feature_dispatcher = from.feature_dispatcher;
        this.overriders = from.overriders;
        this.spawn_point = from.spawn_point;
        this.colors = from.colors;
        this.grass_bonemeal_feature = from.grass_bonemeal_feature;
        this.nether_overrides = from.nether_overrides;
        this.end_overrides = from.end_overrides;
        this.creaking_overrides = from.creaking_overrides;
        this.world_traits = from.world_traits;
        this.loadedWorldTraits = from.loadedWorldTraits;
        this.compiledWorldTraits = from.compiledWorldTraits;
        this.extraSpawnRegistry = from.extraSpawnRegistry;
        this.setCompiledWorldTraits(from.compiledWorldTraits);
        this.rootDebugDisplay = new DisplayEntry(this);
        this.structureManager = from.structureManager.copy();
        this.extraSpawns = from.extraSpawns;
    }

    @Override
    public void compile(ColumnEntryRegistry registry) throws ScriptParsingException {
        this.columnEntryRegistry = registry;
        this.setCompiledWorldTraits(registry.traitManager.createTraits(this.loadedWorldTraits));
        this.checkCyclicDependencies();
    }

    public void checkCyclicDependencies() {
        this.columnEntryRegistry.registries.getRegistry(BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY).streamEntries().forEach(new CyclicDependencyAnalyzer(this.compiledWorldTraits));
    }

    public static class_1966 copyBiomeSource(class_1966 source) {
        class_1966 class_19662;
        if (source instanceof ScriptedColumnBiomeSource) {
            ScriptedColumnBiomeSource scripted = (ScriptedColumnBiomeSource)source;
            class_19662 = new ScriptedColumnBiomeSource(scripted.script, scripted.all_possible_biomes, scripted.biomeRegistry);
        } else {
            class_19662 = source;
        }
        return class_19662;
    }

    public void setCompiledWorldTraits(WorldTraits traits) {
        this.compiledWorldTraits = traits;
        ScriptedColumn.Factory factory = this.columnEntryRegistry.columnFactory;
        this.chunkReuseColumns = ThreadLocal.withInitial(() -> {
            ScriptedColumn[] columns = new ScriptedColumn[256];
            for (int index = 0; index < 256; ++index) {
                columns[index] = factory.create(new ScriptedColumn.Params(0L, 0, 0, 0, 0, ScriptedColumn.ColumnUsage.GENERIC.normalHints(), traits));
            }
            return columns;
        });
    }

    public BigGlobeScriptedChunkGenerator copy() {
        return new BigGlobeScriptedChunkGenerator(this);
    }

    public BigGlobeScriptedChunkGenerator copyWithSeed(long seed) {
        BigGlobeScriptedChunkGenerator copy = this.copy();
        copy.columnSeed = seed;
        copy.seedSet = true;
        return copy;
    }

    public void setWorldTraits(JsonObject jsonTraits) {
        this.loadedWorldTraits = TraitLoader.loadFromCode(jsonTraits);
        this.setCompiledWorldTraits(this.columnEntryRegistry.traitManager.createTraits(this.loadedWorldTraits));
        this.checkCyclicDependencies();
    }

    public void setStructuresEnabled(boolean structuresEnabled) {
        this.structureManager = structuresEnabled ? new ActiveStructureManager() : new InactiveStructureManager();
    }

    public DecodeContext<?> decodeContext() {
        return null;
    }

    public class_1966 biome_source() {
        return this.field_12761;
    }

    public static void init() {
        class_2378.method_10230((class_2378)class_7923.field_41157, (class_2960)BigGlobeMod.modID("scripted"), CODEC);
        class_2378.method_10230((class_2378)class_7923.field_41156, (class_2960)BigGlobeMod.modID("scripted"), ScriptedColumnBiomeSource.CODEC);
    }

    public static AutoCoder<BigGlobeScriptedChunkGenerator> createCoder(FactoryContext<BigGlobeScriptedChunkGenerator> context) {
        final AutoCoder coder = context.forceCreateCoder((AutoCoder.CoderFactory)RecordCoder.Factory.INSTANCE);
        return new AutoCoder.NamedCoder<BigGlobeScriptedChunkGenerator>("jar-reloading AutoCoder for BigGlobeScriptedChunkGenerator"){

            @Nullable
            public <T_Encoded> BigGlobeScriptedChunkGenerator decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
                StringData dimension = ((DecodeContext)context.forceGetMember("reload_dimension")).tryAsString();
                if (dimension != null) {
                    StringData preset = ((DecodeContext)context.forceGetMember("reload_preset")).tryAsString();
                    String presetName = preset != null ? preset.value : "bigglobe";
                    JsonElement json = this.getDimension(presetName, dimension.value);
                    return (BigGlobeScriptedChunkGenerator)new DecodeContext(context.autoCodec, null, (DecodeContext.DecodePath)DecodeContext.RootDecodePath.INSTANCE, (Data)new UnknownData((DynamicOps)JsonOps.INSTANCE, (Object)json), context.ops).decodeWith((AutoDecoder)coder);
                }
                return (BigGlobeScriptedChunkGenerator)context.decodeWith((AutoDecoder)coder);
            }

            @NotNull
            public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, BigGlobeScriptedChunkGenerator> context) throws EncodeException {
                return context.encodeWith((AutoEncoder)coder);
            }

            public JsonElement getDimension(String preset, String dimension) throws DecodeException {
                BigGlobeMod.LOGGER.info("Reading " + dimension + " chunk generator from mod jar.");
                JsonElement element = this.getJson("/data/bigglobe/worldgen/world_preset/" + preset + ".json");
                for (String key : new String[]{"dimensions", dimension, "generator"}) {
                    if (!(element instanceof JsonObject)) {
                        throw new DecodeException(() -> "Could not find dimension " + dimension + " in mod jar!");
                    }
                    JsonObject object = (JsonObject)element;
                    element = object.get(key);
                }
                return element;
            }

            public JsonElement getJson(String path) throws DecodeException {
                JsonElement jsonElement;
                InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(BigGlobeMod.class.getResourceAsStream(path), path), StandardCharsets.UTF_8);
                try {
                    jsonElement = JsonParser.parseReader((Reader)reader);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw new DecodeException((Throwable)exception);
                    }
                }
                ((Reader)reader).close();
                return jsonElement;
            }

            @Nullable
            public Stream<String> getKeys() {
                return coder.getKeys();
            }
        };
    }

    public ScriptedColumn newColumn(class_5539 world, int x, int z, ScriptedColumn.Hints hints) {
        return this.columnEntryRegistry.columnFactory.create(new ScriptedColumn.Params(this.columnSeed, x, z, world, hints, this.compiledWorldTraits));
    }

    public ScriptedColumnLookup.Impl newColumnLookup(class_5539 world, ScriptedColumn.Hints hints) {
        return new ScriptedColumnLookup.Impl(this.columnEntryRegistry.columnFactory, new ScriptedColumn.Params(this.columnSeed, 0, 0, world, hints, this.compiledWorldTraits));
    }

    public class_7869 method_46696(class_7225<class_7059> structureSetRegistry, class_7138 noiseConfig, long seed) {
        if (!this.seedSet) {
            this.columnSeed = Hashing.sha256().hashLong(seed).asLong();
            this.seedSet = true;
        }
        return super.method_46696(structureSetRegistry, noiseConfig, seed);
    }

    public void initStructureManager(boolean structuresEnabled) {
        if (this.structureManager == null) {
            this.setStructuresEnabled(structuresEnabled);
        }
    }

    public Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public Overrider.SortedOverriders getOverriders() {
        if (this.actualOverriders == null) {
            this.actualOverriders = new Overrider.SortedOverriders(this);
        }
        return this.actualOverriders;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public class_6012<class_5483.class_1964> getSpawnEntries(class_6880<class_1959> biome, class_1311 group) {
        return this.extraSpawns.computeIfAbsent(new BiomeSpawnGroup(biome, group), data -> {
            class_6012 result;
            class_6012 base = ((class_1959)data.biome.comp_349()).method_30966().method_31004(data.spawnGroup);
            List<class_5483.class_1964> extra = this.extraSpawnRegistry.streamEntries().map(class_6880::comp_349).filter(spawn -> spawn.weight() > 0 && ((class_1299)spawn.type().comp_349()).method_5891() == data.spawnGroup && spawn.biomes().contains(data.biome)).map(ExtraSpawn::toEntry).toList();
            if (!extra.isEmpty()) {
                if (base.method_34993()) {
                    result = class_6012.method_34988(extra);
                } else {
                    ArrayList<class_5483.class_1964> combined = new ArrayList<class_5483.class_1964>(base.method_34994().size() + extra.size());
                    combined.addAll(base.method_34994());
                    combined.addAll(extra);
                    result = class_6012.method_34988(combined);
                }
            } else {
                result = base;
            }
            if (BigGlobeConfig.INSTANCE.get().dataPackDebugging.logExtraMobSpawns) {
                BigGlobeMod.LOGGER.info(String.valueOf(data.spawnGroup) + " spawns for " + String.valueOf(UnregisteredObjectException.getID(data.biome)) + ": " + String.valueOf(result.method_34994()));
            }
            return result;
        });
    }

    public class_6012<class_5483.class_1964> method_12113(class_6880<class_1959> biome, class_5138 accessor, class_1311 group, class_2338 pos) {
        return accessor.method_41035(new class_1923(pos), (Predicate)Predicates.alwaysTrue()).stream().map(start -> {
            if (!start.method_14969().method_14662((class_2382)pos)) {
                return null;
            }
            class_7061 spawns = (class_7061)start.method_16656().method_41615().get(group);
            if (spawns == null) {
                return null;
            }
            if (spawns.comp_514() == class_7061.class_7062.field_37199) {
                return start.method_14963().stream().map(class_3443::method_14935).anyMatch(box -> box.method_14662((class_2382)pos)) ? spawns.comp_515() : null;
            }
            return spawns.comp_515();
        }).filter(Objects::nonNull).findAny().orElseGet(() -> this.getSpawnEntries(biome, group));
    }

    public void method_12107(class_3233 region) {
        class_1923 chunkPos = region.method_33561();
        class_6880 registryEntry = region.method_23753(new class_2338(chunkPos.method_8326(), this.getHeight(this.newColumn((class_5539)region, chunkPos.method_8326(), chunkPos.method_8328(), ScriptedColumn.ColumnUsage.HEIGHTMAP.maybeDhHints()), class_2902.class_2903.field_13195, (class_5539)region), chunkPos.method_8328()));
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
        chunkRandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
        class_5483 spawnSettings = ((class_1959)registryEntry.comp_349()).method_30966();
        class_6012<class_5483.class_1964> pool = this.getSpawnEntries((class_6880<class_1959>)registryEntry, class_1311.field_6294);
        if (!pool.method_34993()) {
            int i = chunkPos.method_8326();
            int j = chunkPos.method_8328();
            while (chunkRandom.method_43057() < spawnSettings.method_31002()) {
                Optional optional = pool.method_34992((class_5819)chunkRandom);
                if (optional.isEmpty()) continue;
                class_5483.class_1964 spawnEntry = (class_5483.class_1964)optional.get();
                int k = SpawnEntryVersions.minCount(spawnEntry) + chunkRandom.method_43048(1 + SpawnEntryVersions.maxCount(spawnEntry) - SpawnEntryVersions.minCount(spawnEntry));
                class_1315 entityData = null;
                int l = i + chunkRandom.method_43048(16);
                int m = j + chunkRandom.method_43048(16);
                int n = l;
                int o = m;
                for (int p = 0; p < k; ++p) {
                    boolean bl = false;
                    for (int q = 0; !bl && q < 4; ++q) {
                        class_2338 blockPos = class_1948.method_8658((class_4538)region, SpawnEntryVersions.type(spawnEntry), (int)l, (int)m);
                        if (SpawnEntryVersions.type(spawnEntry).method_5896() && class_1948.method_8660((class_1317.class_1319)class_1317.method_6159(SpawnEntryVersions.type(spawnEntry)), (class_4538)region, (class_2338)blockPos, SpawnEntryVersions.type(spawnEntry))) {
                            class_1308 mobEntity;
                            class_1297 entity;
                            float f = SpawnEntryVersions.type(spawnEntry).method_17685();
                            double d = class_3532.method_15350((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                            double e = class_3532.method_15350((double)m, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                            if (!region.method_18026(SpawnEntryVersions.type(spawnEntry).method_17683(d, (double)blockPos.method_10264(), e)) || !class_1317.method_20638(SpawnEntryVersions.type(spawnEntry), (class_5425)region, (class_3730)class_3730.field_16472, (class_2338)class_2338.method_49637((double)d, (double)blockPos.method_10264(), (double)e), (class_5819)region.method_8409())) continue;
                            try {
                                entity = SpawnEntryVersions.type(spawnEntry).method_5883((class_1937)region.method_8410());
                            }
                            catch (Exception var27) {
                                BigGlobeMod.LOGGER.warn("Failed to create mob", (Throwable)var27);
                                continue;
                            }
                            if (entity == null) continue;
                            entity.method_5808(d, (double)blockPos.method_10264(), e, chunkRandom.method_43057() * 360.0f, 0.0f);
                            if (entity instanceof class_1308 && (mobEntity = (class_1308)entity).method_5979((class_1936)region, class_3730.field_16472) && mobEntity.method_5957((class_4538)region)) {
                                entityData = mobEntity.method_5943((class_5425)region, region.method_8404(mobEntity.method_24515()), class_3730.field_16472, entityData, null);
                                region.method_30771((class_1297)mobEntity);
                                bl = true;
                            }
                        }
                        l += chunkRandom.method_43048(5) - chunkRandom.method_43048(5);
                        m += chunkRandom.method_43048(5) - chunkRandom.method_43048(5);
                        while (l < i || l >= i + 16 || m < j || m >= j + 16) {
                            l = n + chunkRandom.method_43048(5) - chunkRandom.method_43048(5);
                            m = o + chunkRandom.method_43048(5) - chunkRandom.method_43048(5);
                        }
                    }
                }
            }
        }
    }

    public int method_12104() {
        return this.height.max_y - this.height.min_y;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        if (ValkyrienSkiesCompat.isInShipyard(chunk.method_12004())) {
            return CompletableFuture.completedFuture(chunk);
        }
        boolean distantHorizons = DistantHorizonsCompat.isOnDistantHorizonThread();
        ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.RAW_GENERATION.maybeDhHints(distantHorizons);
        ScriptStructures structures = ScriptStructures.getStructures(this, this.newColumnLookup((class_5539)chunk, hints), structureAccessor, chunk.method_12004());
        ScriptedColumn.Params params = new ScriptedColumn.Params(this.columnSeed, 0, 0, HeightLimitViewVersions.getMinY((class_5539)chunk), HeightLimitViewVersions.getMaxY((class_5539)chunk), hints, this.compiledWorldTraits);
        return CompletableFuture.runAsync(() -> {
            int startX = chunk.method_12004().method_8326();
            int startZ = chunk.method_12004().method_8328();
            int chunkMinY = HeightLimitViewVersions.getMinY((class_5539)chunk);
            int chunkMaxY = HeightLimitViewVersions.getMaxY((class_5539)chunk);
            ScriptedColumn[] columns = this.chunkReuseColumns.get();
            BlockSegmentList[] lists = new BlockSegmentList[256];
            try (AsyncRunner async = BigGlobeThreadPool.runner(distantHorizons);){
                for (int offsetZ = 0; offsetZ < 16; offsetZ += 2) {
                    int offsetZ_ = offsetZ;
                    for (int offsetX = 0; offsetX < 16; offsetX += 2) {
                        int offsetX_ = offsetX;
                        async.submit(() -> {
                            boolean trace = TracyWrapper.ENABLED && TRACE_OPERATION.compareAndSet(true, false);
                            try (TracyWrapper.ZoneWrapper generateQuad = trace ? TracyWrapper.beginZone("generateQuad") : null;){
                                int baseIndex = offsetZ_ << 4 | offsetX_;
                                int quadX = startX | offsetX_;
                                int quadZ = startZ | offsetZ_;
                                QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                                quadColumn.loadFromArray(columns, baseIndex, 16);
                                quadColumn.at(params, quadX, quadZ, 1);
                                try (TracyWrapper.ZoneWrapper precomputeGeneral = trace ? TracyWrapper.beginZone("precompute") : null;){
                                    for (String string : this.getOverriders().rawColumnValueDependencies) {
                                        try (TracyWrapper.ZoneWrapper precomputeSpecific = trace ? TracyWrapper.beginZone(string) : null;){
                                            quadColumn.preComputeColumnValue(string);
                                        }
                                        catch (Throwable throwable) {
                                            BigGlobeMod.LOGGER.error("Exception pre-computing overrider column value: ", throwable);
                                        }
                                    }
                                }
                                try (TracyWrapper.ZoneWrapper overrideGeneral = trace ? TracyWrapper.beginZone("override") : null;){
                                    for (String string : this.getOverriders().rawColumnValues) {
                                        try (TracyWrapper.ZoneWrapper overrideSpecific = trace ? TracyWrapper.beginZone(() -> ((class_2960)UnregisteredObjectException.getID(string)).toString()) : null;){
                                            quadColumn.override(((ColumnValueOverrider.Entry)string.comp_349()).script(), structures);
                                        }
                                    }
                                }
                                QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                                quadList.createNew(chunkMinY, chunkMaxY);
                                Layer layer = (Layer)this.layer.comp_349();
                                try (TracyWrapper.ZoneWrapper emitSegments = trace ? TracyWrapper.beginZone("emitSegments") : null;){
                                    QuadHolder.generate(quadColumn, quadList, layer);
                                }
                                quadList.storeInArray(lists, baseIndex, 16);
                            }
                        });
                    }
                }
            }
            int minFilledSectionY = Integer.MAX_VALUE;
            int maxFilledSectionY = Integer.MIN_VALUE;
            block7: for (BlockSegmentList list : lists) {
                BlockSegmentList.LitSegment segment;
                int index;
                int size = list.size();
                for (index = 0; index < size; ++index) {
                    segment = (BlockSegmentList.LitSegment)list.get(index);
                    if (((class_2680)segment.value).method_26215()) continue;
                    minFilledSectionY = Math.min(minFilledSectionY, segment.minY);
                    break;
                }
                index = size;
                while (--index >= 0) {
                    segment = (BlockSegmentList.LitSegment)list.get(index);
                    if (((class_2680)segment.value).method_26215()) continue;
                    maxFilledSectionY = Math.max(maxFilledSectionY, segment.maxY);
                    continue block7;
                }
            }
            maxFilledSectionY = (maxFilledSectionY >> 4) + 1;
            Async.loop(BigGlobeThreadPool.executor(distantHorizons), minFilledSectionY >>= 4, maxFilledSectionY, 1, coord -> {
                class_2826 section = chunk.method_38259(chunk.method_31603(coord));
                int baseY = coord << 4;
                SectionGenerationContext context = SectionGenerationContext.forBlockCoord(chunk, section, baseY);
                class_2680 centerState = (class_2680)lists[136].getOverlappingObject(baseY | 8);
                if (centerState != null) {
                    context.setAllStates(centerState, distantHorizons);
                }
                for (int horizontalIndex = 0; horizontalIndex < 256; ++horizontalIndex) {
                    BlockSegmentList list = lists[horizontalIndex];
                    int size = list.size();
                    for (int yIndex = list.getSegmentIndex(baseY, false); yIndex < size; ++yIndex) {
                        BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)list.get(yIndex);
                        int segmentMinY = Math.max(segment.minY - baseY, 0);
                        int segmentMaxY = Math.min(segment.maxY - baseY, 15);
                        if (segmentMaxY < segmentMinY) continue;
                        int id = context.id((class_2680)segment.value);
                        class_6490 storage = context.storage();
                        for (int blockY = segmentMinY; blockY <= segmentMaxY; ++blockY) {
                            storage.method_15210(blockY << 8 | horizontalIndex, id);
                        }
                    }
                }
            });
            for (class_2902.class_2903 type : chunk.method_12009().method_12160()) {
                class_2902 heightmap = chunk.method_12032(type);
                class_6490 heightmapStorage = ((Heightmap_StorageAccess)heightmap).bigglobe_getStorage();
                for (int horizontalIndex = 0; horizontalIndex < 256; ++horizontalIndex) {
                    BlockSegmentList list = lists[horizontalIndex];
                    if (list.isEmpty()) continue;
                    int height = BigGlobeScriptedChunkGenerator.getHeight(list, type);
                    height = class_3532.method_15340((int)(height - HeightLimitViewVersions.getMinY((class_5539)chunk)), (int)0, (int)HeightLimitViewVersions.getHeight((class_5539)chunk));
                    heightmapStorage.method_15210(horizontalIndex, height);
                }
            }
            WorldWrapper worldWrapper = new WorldWrapper(new WorldOrChunk.ChunkDelegator(chunk, this.columnSeed), this, new Permuter(Permuter.permute(this.columnSeed, chunk.method_12004())), new WorldWrapper.Coordination(SymmetricOffset.IDENTITY, WorldUtil.chunkBox(chunk), WorldUtil.chunkBox(chunk)), hints);
            worldWrapper.overriders = new WorldWrapper.AutoOverride(structures, this.getOverriders().rawColumnValues, this.getOverriders().rawColumnValueDependencies);
            for (ScriptedColumn column : columns) {
                worldWrapper.columns.put(class_2265.method_34874((int)column.x(), (int)column.z()), (Object)column);
            }
            int minFilledSectionY_ = minFilledSectionY;
            int maxFilledSectionY_ = maxFilledSectionY;
            ScriptedColumnLookup.GLOBAL.run(worldWrapper, () -> {
                if (!distantHorizons) {
                    for (RockReplacerFeature.ConfiguredRockReplacerFeature<?> replacer : this.feature_dispatcher.getFlattenedRockReplacers()) {
                        replacer.replaceRocks(this, worldWrapper, chunk, minFilledSectionY_, maxFilledSectionY_);
                    }
                }
                Async.loop(BigGlobeThreadPool.executor(distantHorizons), HeightLimitViewVersions.getSectionMinY((class_5539)chunk), HeightLimitViewVersions.getSectionMaxY((class_5539)chunk), 1, coord -> chunk.method_38259(chunk.method_31603(coord)).method_12253());
                this.generateRawStructures(chunk, structureAccessor, worldWrapper);
                this.feature_dispatcher.generateRaw(worldWrapper);
            });
        }, executor).handle((result, throwable) -> {
            if (throwable != null) {
                BigGlobeMod.LOGGER.error("Exception populating noise", throwable);
            }
            return chunk;
        });
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        if (ValkyrienSkiesCompat.isInShipyard(chunk.method_12004())) {
            return;
        }
        this.generateStructures(world, chunk, structureAccessor);
        WorldWrapper worldWrapper = new WorldWrapper(new WorldOrChunk.WorldDelegator(world), this, new Permuter(Permuter.permute(this.columnSeed, chunk.method_12004())), new WorldWrapper.Coordination(SymmetricOffset.IDENTITY, WorldUtil.chunkBox(chunk), WorldUtil.surroundingChunkBox(chunk)), ScriptedColumn.ColumnUsage.FEATURES.maybeDhHints());
        ScriptStructures structures = ScriptStructures.getStructures(this, worldWrapper, structureAccessor, chunk.method_12004());
        ScriptedColumn[] columns = this.chunkReuseColumns.get();
        worldWrapper.overriders = new WorldWrapper.AutoOverride(structures, this.getOverriders().featureColumnValues, this.getOverriders().featureColumnValueDependencies);
        try (AsyncConsumer<ScriptedColumn> async = new AsyncConsumer<ScriptedColumn>(BigGlobeThreadPool.autoExecutor(), column -> worldWrapper.columns.put(class_2265.method_34874((int)column.x(), (int)column.z()), column));){
            int index = 0;
            while (index < 256) {
                int index_ = index++;
                async.submit(() -> {
                    int x = chunk.method_12004().method_8326() | index_ & 0xF;
                    int z = chunk.method_12004().method_8328() | index_ >>> 4;
                    columns[index_].setParamsUnchecked(worldWrapper.params.at(x, z));
                    worldWrapper.overriders.override(columns[index_]);
                    return columns[index_];
                });
            }
        }
        ScriptedColumnLookup.GLOBAL.accept(worldWrapper, this.feature_dispatcher::generateNormal);
    }

    public void generateRawStructures(class_2791 chunk, class_5138 structureAccessor, ScriptedColumnLookup columns) {
        class_1936 class_19362 = ((StructureAccessor_WorldAccess)structureAccessor).bigglobe_getWorld();
        if (class_19362 instanceof class_5425) {
            class_5425 serverWorldAccess = (class_5425)class_19362;
            ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints();
            StructureManager.FinalStructures structures = this.structureManager.getIntersectingStructures(new StructureManager.StructureGenerationParams(this, this.newColumnLookup((class_5539)serverWorldAccess, hints), serverWorldAccess.method_8410(), chunk.method_12004()));
            RawGenerationStructure.RawGenerationStructurePiece.Context context = null;
            class_3341 chunkBox = WorldUtil.chunkBox(chunk);
            class_2378 structureRegistry = RegistryVersions.getRegistry(serverWorldAccess.method_30349(), class_7924.field_41246);
            ObjectListIterator objectListIterator = structures.iterator();
            while (objectListIterator.hasNext()) {
                class_3449 start = (class_3449)objectListIterator.next();
                if (!(start.method_16656() instanceof RawGenerationStructure)) continue;
                long structureSeed = BigGlobeScriptedChunkGenerator.getStructureSeed(this.columnSeed, structureRegistry.method_10221((Object)start.method_16656()), start);
                List children = start.method_14963();
                int pieceCount = children.size();
                for (int pieceIndex = 0; pieceIndex < pieceCount; ++pieceIndex) {
                    class_3443 piece = (class_3443)children.get(pieceIndex);
                    if (!(piece instanceof RawGenerationStructure.RawGenerationStructurePiece)) continue;
                    RawGenerationStructure.RawGenerationStructurePiece rawPiece = (RawGenerationStructure.RawGenerationStructurePiece)piece;
                    if (!piece.method_14935().method_14657(chunkBox)) continue;
                    long pieceSeed = Permuter.permute(structureSeed, pieceIndex);
                    if (context == null) {
                        context = new RawGenerationStructure.RawGenerationStructurePiece.Context(chunk, this, columns, DistantHorizonsCompat.isOnDistantHorizonThread());
                    }
                    context.pieceSeed = pieceSeed;
                    rawPiece.generateRaw(context);
                }
            }
        }
    }

    public void generateStructures(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_3341 chunkBox = WorldUtil.chunkBox(chunk);
        ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints();
        StructureManager.FinalStructures structures = this.structureManager.getIntersectingStructures(new StructureManager.StructureGenerationParams(this, this.newColumnLookup((class_5539)world, hints), world.method_8410(), chunk.method_12004()));
        class_2378 structureRegistry = RegistryVersions.getRegistry(world.method_30349(), class_7924.field_41246);
        ObjectListIterator objectListIterator = structures.iterator();
        while (objectListIterator.hasNext()) {
            class_3449 start = (class_3449)objectListIterator.next();
            long structureSeed = BigGlobeScriptedChunkGenerator.getStructureSeed(this.columnSeed, structureRegistry.method_10221((Object)start.method_16656()), start);
            List children = start.method_14963();
            class_3341 firstPieceBB = ((class_3443)children.get(0)).method_14935();
            class_2338 pivot = new class_2338(firstPieceBB.method_35415() + firstPieceBB.method_35418() + 1 >> 1, firstPieceBB.method_35416(), firstPieceBB.method_35417() + firstPieceBB.method_35420() + 1 >> 1);
            int pieceCount = children.size();
            for (int pieceIndex = 0; pieceIndex < pieceCount; ++pieceIndex) {
                class_3443 piece = (class_3443)children.get(pieceIndex);
                if (!piece.method_14935().method_14657(chunkBox)) continue;
                long pieceSeed = Permuter.permute(structureSeed, pieceIndex);
                try {
                    piece.method_14931(world, structureAccessor, (class_2794)this, (class_5819)new MojangPermuter(pieceSeed), chunkBox, chunk.method_12004(), pivot);
                    continue;
                }
                catch (Exception exception) {
                    BigGlobeMod.LOGGER.error("Exception placing structure piece " + String.valueOf(piece) + ":", (Throwable)exception);
                }
            }
            try {
                start.method_16656().method_38694(world, structureAccessor, (class_2794)this, (class_5819)new MojangPermuter(structureSeed), chunkBox, chunk.method_12004(), ((StructureStart_ChildrenGetter)start).bigglobe_getChildren());
            }
            catch (Exception exception) {
                BigGlobeMod.LOGGER.error("Exception post-placing structure start " + String.valueOf(start) + ":", (Throwable)exception);
            }
        }
    }

    public static long getStructureSeed(long worldSeed, class_2960 structureID, class_3449 start) {
        return Permuter.permute(worldSeed ^ 0x74ED298CF4DD2677L, structureID.hashCode(), start.method_34000().field_9181, start.method_34000().field_9180);
    }

    public void method_16129(class_5455 registryManager, class_7869 placementCalculator, class_5138 structureAccessor, class_2791 chunk, class_3485 structureTemplateManager) {
        boolean distantHorizons = DistantHorizonsCompat.isOnDistantHorizonThread();
        StructureManager.FinalStructures starts = this.structureManager.getFinalStructures(new StructureManager.StructureGenerationParams(this, this.newColumnLookup((class_5539)chunk, ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints(distantHorizons)), placementCalculator, registryManager, placementCalculator.method_46713(), structureTemplateManager, (class_5539)chunk, chunk.method_12004(), distantHorizons));
        boolean log = BigGlobeConfig.INSTANCE.get().dataPackDebugging.structureSpawning;
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(starts.size());
        ObjectListIterator objectListIterator = starts.iterator();
        while (objectListIterator.hasNext()) {
            class_3449 start = (class_3449)objectListIterator.next();
            map.merge(start.method_16656(), start, (start1, start2) -> {
                if (log) {
                    BigGlobeMod.LOGGER.info("More than one copy of structure " + StructureManager.structureName(start1.method_16656()) + " started in the same chunk. It may be present in more than one structure set.");
                }
                return new class_3449(start1.method_16656(), start1.method_34000(), 0, new class_6624(Stream.concat(start1.method_14963().stream(), start2.method_14963().stream()).toList()));
            });
        }
        chunk.method_12034((Map)map);
    }

    public void method_16130(class_5281 world, class_5138 structureAccessor, class_2791 chunk) {
        ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints();
        StructureManager.FinalStructures intersecting = this.structureManager.getIntersectingStructures(new StructureManager.StructureGenerationParams(this, this.newColumnLookup((class_5539)chunk, hints), world.method_8410(), chunk.method_12004()));
        ObjectListIterator objectListIterator = intersecting.iterator();
        while (objectListIterator.hasNext()) {
            class_3449 start = (class_3449)objectListIterator.next();
            if (StreamableStructurePlacement.distance(start.method_34000(), chunk.method_12004().field_9181, chunk.method_12004().field_9180) > 8) continue;
            chunk.method_12182(start.method_16656(), start.method_34000().method_8324());
        }
    }

    @Nullable
    public Pair<class_2338, class_6880<class_3195>> method_12103(class_3218 world, class_6885<class_3195> structures, class_2338 center, int radius, boolean skipReferencedStructures) {
        int centerX = center.method_10263() >> 4;
        int centerZ = center.method_10260() >> 4;
        class_7869 calculator = world.method_14178().method_46642();
        return structures.method_40239().flatMap(structureEntry -> calculator.method_46708(structureEntry).stream().flatMap(placement -> ((StreamableStructurePlacement)placement).bigglobe_getNearbyStartChunks(this, calculator, centerX, centerZ, radius))).sorted(StreamableStructurePlacement.distanceComparator(centerX, centerZ)).map(chunkPos -> this.getStructure(world, structures, chunkPos.field_9181, chunkPos.field_9180)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public Pair<class_2338, class_6880<class_3195>> getStructure(class_3218 world, class_6885<class_3195> structures, int chunkX, int chunkZ) {
        ScriptedColumn.Hints hints = ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints();
        StructureManager.FinalStructures starts = this.structureManager.getFinalStructures(new StructureManager.StructureGenerationParams(this, this.newColumnLookup((class_5539)world, hints), world, new class_1923(chunkX, chunkZ)));
        for (class_6880 structure : structures) {
            ObjectListIterator objectListIterator = starts.iterator();
            while (objectListIterator.hasNext()) {
                class_3449 start = (class_3449)objectListIterator.next();
                if (start.method_16656() != structure.comp_349()) continue;
                return Pair.of((Object)start.method_14969().method_22874(), (Object)structure);
            }
        }
        return null;
    }

    public CompletableFuture<class_2791> method_38275(Executor executor, class_7138 noiseConfig, class_6748 blender, class_5138 structureAccessor, class_2791 chunk) {
        class_1966 class_19662 = this.field_12761;
        if (!(class_19662 instanceof ScriptedColumnBiomeSource)) {
            return super.method_38275(executor, noiseConfig, blender, structureAccessor, chunk);
        }
        ScriptedColumnBiomeSource source = (ScriptedColumnBiomeSource)class_19662;
        boolean distantHorizons = DistantHorizonsCompat.isOnDistantHorizonThread();
        return CompletableFuture.runAsync(() -> {
            int bottomY = HeightLimitViewVersions.getMinY((class_5539)chunk);
            int topY = HeightLimitViewVersions.getMaxY((class_5539)chunk);
            ScriptedColumn column = this.newColumn((class_5539)chunk, 0, 0, ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints(distantHorizons));
            for (int z = 0; z < 16; z += 4) {
                for (int x = 0; x < 16; x += 4) {
                    column.setParamsUnchecked(column.params.at(chunk.method_12004().method_8326() | x, chunk.method_12004().method_8328() | z));
                    for (int y = bottomY; y < topY; y += 4) {
                        class_2826 section = chunk.method_38259(chunk.method_31602(y));
                        class_2841 container = (class_2841)section.method_38294();
                        int newID = SectionUtil.id(container, source.script.get((ScriptedColumn)column, (int)y).entry);
                        SectionUtil.storage(container).method_15210((y & 0xC) << 2 | z | x >>> 2, newID);
                    }
                }
            }
        }, class_156.method_18349()).handle((result, throwable) -> {
            if (throwable != null) {
                BigGlobeMod.LOGGER.error("Exception populating chunk biomes", throwable);
            }
            return chunk;
        });
    }

    public int method_16398() {
        Integer seaLevel = this.height.sea_level;
        return seaLevel != null ? seaLevel : this.height.min_y;
    }

    public int method_33730() {
        return this.height.min_y;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return this.getHeight(this.newColumn(world, x, z, ScriptedColumn.ColumnUsage.HEIGHTMAP.maybeDhHints()), heightmap, world);
    }

    public int getHeight(ScriptedColumn column, class_2902.class_2903 heightmap, class_5539 world) {
        BlockSegmentList list = new BlockSegmentList(HeightLimitViewVersions.getMinY(world), HeightLimitViewVersions.getMaxY(world));
        ((Layer)this.layer.comp_349()).emitSegments(column, list);
        return BigGlobeScriptedChunkGenerator.getHeight(list, heightmap);
    }

    public static int getHeight(BlockSegmentList list, class_2902.class_2903 type) {
        int index = list.size();
        while (--index >= 0) {
            BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)list.get(index);
            if (!type.method_16402().test((class_2680)segment.value)) continue;
            return segment.maxY + 1;
        }
        return list.minY();
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        ScriptedColumn column = this.newColumn(world, x, z, ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints());
        BlockSegmentList list = new BlockSegmentList(HeightLimitViewVersions.getMinY(world), HeightLimitViewVersions.getMaxY(world));
        ((Layer)this.layer.comp_349()).emitSegments(column, list);
        class_2680[] states = (class_2680[])list.flatten(class_2680[]::new);
        int length = states.length;
        for (int index = 0; index < length; ++index) {
            if (states[index] != null) continue;
            states[index] = BlockStates.AIR;
        }
        return new class_4966(HeightLimitViewVersions.getMinY(world), states);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        ScriptedColumn column = this.columnEntryRegistry.columnFactory.create(new ScriptedColumn.Params(this, pos.method_10263(), pos.method_10260(), ScriptedColumn.ColumnUsage.GENERIC.normalHints()));
        this.rootDebugDisplay.forEach(column, pos.method_10264(), (id, value) -> text.add(id + ": " + String.valueOf(value)));
    }

    public void setDisplay(String regex) {
        this.displayPattern = regex != null ? Pattern.compile(regex) : null;
        this.rootDebugDisplay.recomputeChildren(this.columnEntryRegistry.columnFactory.create(new ScriptedColumn.Params(this, 0, 0, ScriptedColumn.ColumnUsage.GENERIC.normalHints())));
    }

    static {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (BigGlobeConfig.INSTANCE.get().dataPackDebugging.dependencyGraphs) {
                for (class_3218 world : server.method_3738()) {
                    class_2794 patt0$temp = world.method_14178().method_12129();
                    if (!(patt0$temp instanceof BigGlobeScriptedChunkGenerator)) continue;
                    BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)patt0$temp;
                    class_2960 worldID = world.method_27983().method_29177();
                    DependencyDepthSorter.start(generator.compiledWorldTraits, generator.columnEntryRegistry.registries.getRegistry(BigGlobeDynamicRegistries.COLUMN_ENTRY_REGISTRY_KEY), "server " + worldID.method_12836() + " " + worldID.method_12832());
                }
            }
        });
    }

    public record Height(@VerifyDivisibleBy16 int min_y, @VerifyDivisibleBy16 @VerifySorted(greaterThan={"min_y"}) int max_y, @VerifyNullable Integer sea_level) {
    }

    public record ColorOverrides(@VerifyNullable ClientState.ColorScript.Holder grass, @VerifyNullable ClientState.ColorScript.Holder foliage, @VerifyNullable ClientState.ColorScript.Holder water) {
    }

    public record NetherOverrides(boolean place_portal_at_high_y_level, boolean prevent_roof_exploration) {
    }

    public record EndOverrides(Spawning spawning, InnerGateways inner_gateways, OuterGateways outer_gateways) {

        public record Spawning(int @VerifySizeRange(min=3, max=3) [] location, boolean obsidian_platform) {
        }

        public record InnerGateways(double radius, int height) {
        }

        public record OuterGateways(double min_radius, double max_radius, double step, ColumnScript.ColumnToBooleanScript.Holder condition) {
        }
    }

    public record CreakingOverrides(class_5321<class_1937> time_reference) {
    }

    public static class DisplayEntry {
        public static final ObjectArrayFactory<DisplayEntry> ARRAY_FACTORY = new ObjectArrayFactory(DisplayEntry.class);
        public BigGlobeScriptedChunkGenerator generator;
        public String name;
        public String id;
        public Class<?> expectedValueType;
        public DisplayEntry[] children;

        public DisplayEntry(BigGlobeScriptedChunkGenerator generator, String name, String id) {
            this.generator = generator;
            this.name = name;
            this.id = id;
            this.children = (DisplayEntry[])ARRAY_FACTORY.empty();
        }

        public DisplayEntry(BigGlobeScriptedChunkGenerator generator) {
            this(generator, "", "");
        }

        public String toString() {
            return "DisplayEntry: { name: " + this.name + ", id: " + this.id + ", expectedValueType: " + String.valueOf(this.expectedValueType) + " }";
        }

        public void forEach(ColumnValueHolder holder, int y, BiConsumer<String, Object> results) {
            try {
                Object value;
                if (this.id.isEmpty()) {
                    value = holder;
                } else {
                    value = holder.getColumnValue(this.id, y);
                    if (value instanceof ScriptedColumn) {
                        return;
                    }
                    results.accept(this.name, value);
                }
                if (value != null) {
                    if (this.expectedValueType != value.getClass()) {
                        this.expectedValueType = value.getClass();
                        this.recomputeChildren(value);
                    }
                    if (value instanceof ColumnValueHolder) {
                        ColumnValueHolder nextHolder = (ColumnValueHolder)value;
                        for (DisplayEntry child : this.children) {
                            child.forEach(nextHolder, y, results);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                results.accept(this.id, throwable.toString());
            }
        }

        public void recomputeChildren(Object value) {
            if (this.generator.displayPattern != null && value instanceof ColumnValueHolder) {
                record NameId(String name, String id) {
                }
                ColumnValueHolder holder = (ColumnValueHolder)value;
                this.children = (DisplayEntry[])holder.getColumnValues().stream().map(ColumnValueHolder.ColumnValueInfo::name).map(id -> new NameId((String)(this.name.isEmpty() ? id : this.name + "." + id), (String)id)).filter(nameId -> this.generator.displayPattern.matcher(nameId.name).find()).map(nameId -> new DisplayEntry(this.generator, nameId.name, nameId.id)).toArray((IntFunction<A[]>)ARRAY_FACTORY);
            } else {
                this.children = (DisplayEntry[])ARRAY_FACTORY.empty();
            }
        }
    }

    public record BiomeSpawnGroup(class_6880<class_1959> biome, class_1311 spawnGroup) {
    }
}

