/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.chunkgen.scripted;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class SegmentList<T_Segment extends Segment>
extends ObjectArrayList<T_Segment> {
    public static final boolean ASSERTS = false;
    public int minY;
    public int maxY;

    public SegmentList(int minY, int maxY) {
        if (maxY < minY) {
            throw new IllegalArgumentException("maxY (" + maxY + ") must be greater than or equal to minY (" + minY + ")");
        }
        this.minY = minY;
        this.maxY = maxY;
    }

    public void retainFrom(SegmentList<?> that) {
        if (!this.isEmpty()) {
            if (that.isEmpty()) {
                this.clear();
            } else {
                Segment segment = (Segment)that.get(0);
                if (segment.minY > this.minY) {
                    this.removeSegment(this.minY, segment.minY - 1);
                }
                int size = that.size();
                for (int index = 1; index < size; ++index) {
                    Segment next = (Segment)that.get(index);
                    if (next.minY != segment.maxY + 1) {
                        this.removeSegment(segment.maxY + 1, next.minY - 1);
                    }
                    segment = next;
                }
                if (segment.maxY < this.maxY) {
                    this.removeSegment(segment.maxY + 1, this.maxY);
                }
            }
        }
    }

    public void removeFrom(SegmentList<?> that) {
        if (!this.isEmpty() && !that.isEmpty()) {
            Segment segment = (Segment)that.get(0);
            int start = segment.minY;
            int end = segment.maxY;
            int size = that.size();
            for (int index = 0; index < size; ++index) {
                segment = (Segment)that.get(index);
                if (segment.minY == end + 1) {
                    end = segment.maxY;
                    continue;
                }
                this.removeSegment(start, end);
                start = segment.minY;
                end = segment.maxY;
            }
            this.removeSegment(start, end);
        }
    }

    public void addAllSegments(SegmentList<T_Segment> that) {
        block4: {
            if (that.isEmpty()) break block4;
            if (this.isEmpty()) {
                int size = that.size();
                for (int index = 0; index < size; ++index) {
                    Segment segment = (Segment)that.get(index);
                    int minY = Math.max(segment.minY, this.minY);
                    int maxY = Math.min(segment.maxY, this.maxY);
                    if (maxY < minY) continue;
                    this.add(segment.clone());
                }
            } else {
                int size = that.size();
                for (int index = 0; index < size; ++index) {
                    this.addSegment((Segment)that.get(index));
                }
            }
        }
    }

    public T_Segment addSegment(T_Segment segment) {
        return this.addSegment(((Segment)segment).minY, ((Segment)segment).maxY);
    }

    @Nullable
    public T_Segment addSegment(int minY, int maxY) {
        T_Segment result;
        minY = Math.max(minY, this.minY);
        if ((maxY = Math.min(maxY, this.maxY)) >= minY) {
            if (this.isEmpty()) {
                T_Segment T_Segment = this.newSegment(minY, maxY);
                result = T_Segment;
                this.add(T_Segment);
            } else {
                Segment highest = (Segment)this.get(this.size() - 1);
                Segment lowest = (Segment)this.get(0);
                if (minY > highest.maxY) {
                    T_Segment T_Segment = this.newSegment(minY, maxY);
                    result = T_Segment;
                    this.add(T_Segment);
                    this.mergeAt(this.size() - 1);
                } else if (minY > lowest.minY) {
                    if (maxY >= highest.maxY) {
                        int index = this.getSegmentIndex(minY, false);
                        Segment segment = (Segment)this.get(index);
                        if (segment.minY < minY) {
                            segment.maxY = minY - 1;
                            ++index;
                        }
                        if (index < this.size()) {
                            this.size(index);
                        }
                        T_Segment T_Segment = this.newSegment(minY, maxY);
                        result = T_Segment;
                        this.add(T_Segment);
                        this.mergeAt(this.size() - 1);
                    } else {
                        int minIndex = this.getSegmentIndex(minY, false);
                        int maxIndex = this.getSegmentIndex(maxY, true);
                        if (maxIndex < minIndex) {
                            assert (maxIndex == minIndex - 1);
                            T_Segment T_Segment = this.newSegment(minY, maxY);
                            result = T_Segment;
                            this.add(minIndex, T_Segment);
                            this.mergeAt(minIndex);
                        } else if (maxIndex == minIndex) {
                            Segment segment = (Segment)this.get(minIndex);
                            if (minY <= segment.minY) {
                                if (maxY >= segment.maxY) {
                                    T_Segment T_Segment = this.newSegment(minY, maxY);
                                    result = T_Segment;
                                    this.set(minIndex, T_Segment);
                                    this.mergeAt(minIndex);
                                } else {
                                    segment.minY = maxY + 1;
                                    T_Segment T_Segment = this.newSegment(minY, maxY);
                                    result = T_Segment;
                                    this.add(minIndex, T_Segment);
                                    this.mergeAt(minIndex);
                                }
                            } else if (maxY >= segment.maxY) {
                                segment.maxY = minY - 1;
                                T_Segment T_Segment = this.newSegment(minY, maxY);
                                result = T_Segment;
                                this.add(minIndex + 1, T_Segment);
                                this.mergeAt(minIndex + 1);
                            } else {
                                Segment clone = segment.clone();
                                segment.maxY = minY - 1;
                                clone.minY = maxY + 1;
                                T_Segment T_Segment = this.newSegment(minY, maxY);
                                result = T_Segment;
                                this.addAll(minIndex + 1, List.of(T_Segment, clone));
                                this.mergeAt(minIndex + 1);
                            }
                        } else {
                            Segment lowSegment = (Segment)this.get(minIndex);
                            Segment highSegment = (Segment)this.get(maxIndex);
                            if (lowSegment.minY < minY) {
                                lowSegment.maxY = minY - 1;
                                ++minIndex;
                            }
                            if (highSegment.maxY > maxY) {
                                highSegment.minY = maxY + 1;
                                --maxIndex;
                            }
                            if (maxIndex >= minIndex) {
                                this.removeElements(minIndex, maxIndex + 1);
                            }
                            T_Segment T_Segment = this.newSegment(minY, maxY);
                            result = T_Segment;
                            this.add(minIndex, T_Segment);
                            this.mergeAt(minIndex);
                        }
                    }
                } else if (maxY >= highest.maxY) {
                    this.clear();
                    T_Segment T_Segment = this.newSegment(minY, maxY);
                    result = T_Segment;
                    this.add(T_Segment);
                } else if (maxY >= lowest.minY) {
                    int index = this.getSegmentIndex(maxY, true);
                    Segment segment = (Segment)this.get(index);
                    if (segment.maxY > maxY) {
                        segment.minY = maxY + 1;
                        --index;
                    }
                    if (index >= 0) {
                        this.removeElements(0, index + 1);
                    }
                    T_Segment T_Segment = this.newSegment(minY, maxY);
                    result = T_Segment;
                    this.add(0, T_Segment);
                    this.mergeAt(0);
                } else {
                    T_Segment T_Segment = this.newSegment(minY, maxY);
                    result = T_Segment;
                    this.add(0, T_Segment);
                    this.mergeAt(0);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public void removeSegment(int minY, int maxY) {
        minY = Math.max(minY, this.minY);
        if ((maxY = Math.min(maxY, this.maxY)) >= minY && !this.isEmpty()) {
            Segment highest = (Segment)this.get(this.size() - 1);
            Segment lowest = (Segment)this.get(0);
            if (minY <= highest.maxY) {
                if (minY > lowest.minY) {
                    if (maxY >= highest.maxY) {
                        int index = this.getSegmentIndex(minY, false);
                        Segment segment = (Segment)this.get(index);
                        if (segment.minY < minY) {
                            segment.maxY = minY - 1;
                            ++index;
                        }
                        if (index < this.size()) {
                            this.size(index);
                        }
                    } else {
                        int minIndex = this.getSegmentIndex(minY, false);
                        int maxIndex = this.getSegmentIndex(maxY, true);
                        if (maxIndex < minIndex) {
                            assert (maxIndex == minIndex - 1);
                        } else if (maxIndex == minIndex) {
                            Segment segment = (Segment)this.get(minIndex);
                            if (minY <= segment.minY) {
                                if (maxY >= segment.maxY) {
                                    this.remove(minIndex);
                                } else {
                                    segment.minY = maxY + 1;
                                }
                            } else if (maxY >= segment.maxY) {
                                segment.maxY = minY - 1;
                            } else {
                                Segment clone = segment.clone();
                                segment.maxY = minY - 1;
                                clone.minY = maxY + 1;
                                this.add(minIndex + 1, clone);
                            }
                        } else {
                            Segment lowSegment = (Segment)this.get(minIndex);
                            Segment highSegment = (Segment)this.get(maxIndex);
                            if (lowSegment.minY < minY) {
                                lowSegment.maxY = minY - 1;
                                ++minIndex;
                            }
                            if (highSegment.maxY > maxY) {
                                highSegment.minY = maxY + 1;
                                --maxIndex;
                            }
                            if (maxIndex >= minIndex) {
                                this.removeElements(minIndex, maxIndex + 1);
                            }
                        }
                    }
                } else if (maxY >= highest.maxY) {
                    this.clear();
                } else if (maxY >= lowest.minY) {
                    int index = this.getSegmentIndex(maxY, true);
                    Segment segment = (Segment)this.get(index);
                    if (segment.maxY > maxY) {
                        segment.minY = maxY + 1;
                        --index;
                    }
                    if (index >= 0) {
                        this.removeElements(0, index + 1);
                    }
                }
            }
        }
    }

    public void mergeAt(int index) {
        Segment other;
        Segment current = (Segment)this.get(index);
        if (index + 1 < this.size()) {
            other = (Segment)this.get(index + 1);
            if (other.minY == current.maxY + 1 && other.canMergeWith(current)) {
                current.maxY = other.maxY;
                this.remove(index + 1);
            }
        }
        if (index - 1 >= 0) {
            other = (Segment)this.get(index - 1);
            if (other.maxY == current.minY - 1 && other.canMergeWith(current)) {
                current.minY = other.minY;
                this.remove(index - 1);
            }
        }
    }

    public static void checkAssertsEnabled() {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!asserts) {
            throw new AssertionError((Object)"asserts not enabled. run with -ea");
        }
    }

    public void checkIntegrity() {
        SegmentList.checkAssertsEnabled();
        if (!this.isEmpty()) {
            assert (((Segment)this.get((int)0)).minY >= this.minY);
            assert (((Segment)this.get((int)(this.size() - 1))).maxY <= this.maxY);
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                Segment lowSegment = (Segment)this.get(index);
                assert (lowSegment.maxY >= lowSegment.minY);
                if (index + 1 >= size) continue;
                Segment highSegment = (Segment)this.get(index + 1);
                assert (highSegment.minY > lowSegment.maxY);
                assert (highSegment.minY != lowSegment.maxY + 1 || !highSegment.canMergeWith(lowSegment));
            }
        }
    }

    public int getSegmentIndex(int y, boolean low) {
        int minIndex = 0;
        int maxIndex = this.size() - 1;
        while (maxIndex >= minIndex) {
            int midIndex = minIndex + maxIndex >>> 1;
            Segment segment = (Segment)this.get(midIndex);
            if (y < segment.minY) {
                maxIndex = midIndex - 1;
                continue;
            }
            if (y > segment.maxY) {
                minIndex = midIndex + 1;
                continue;
            }
            return midIndex;
        }
        return low ? maxIndex : minIndex;
    }

    @Nullable
    public T_Segment getOverlappingSegment(int y) {
        int minIndex = 0;
        int maxIndex = this.size() - 1;
        while (maxIndex >= minIndex) {
            int midIndex = minIndex + maxIndex >>> 1;
            Segment segment = (Segment)this.get(midIndex);
            if (y < segment.minY) {
                maxIndex = midIndex - 1;
                continue;
            }
            if (y > segment.maxY) {
                minIndex = midIndex + 1;
                continue;
            }
            return (T_Segment)segment;
        }
        return null;
    }

    public int getTopOrBottomOfSegment(int y, boolean top, int default_) {
        if (this.isEmpty()) {
            return default_;
        }
        Segment end = (Segment)this.get(0);
        if (y < end.minY) {
            return top ? end.minY - 1 : default_;
        }
        end = (Segment)this.get(this.size() - 1);
        if (y > end.maxY) {
            return top ? default_ : end.maxY + 1;
        }
        int minIndex = 0;
        int maxIndex = this.size() - 1;
        while (maxIndex >= minIndex) {
            int midIndex = minIndex + maxIndex >>> 1;
            Segment segment = (Segment)this.get(midIndex);
            if (y < segment.minY) {
                maxIndex = midIndex - 1;
                continue;
            }
            if (y > segment.maxY) {
                minIndex = midIndex + 1;
                continue;
            }
            return top ? segment.maxY : segment.minY;
        }
        return top ? ((Segment)this.get((int)minIndex)).minY - 1 : ((Segment)this.get((int)maxIndex)).maxY + 1;
    }

    public abstract T_Segment newSegment(int var1, int var2);

    public static abstract class Segment
    implements Cloneable {
        public int minY;
        public int maxY;

        public Segment(int minY, int maxY) {
            this.minY = minY;
            this.maxY = maxY;
        }

        public abstract boolean canMergeWith(Segment var1);

        public Segment clone() {
            try {
                return (Segment)super.clone();
            }
            catch (CloneNotSupportedException exception) {
                throw new AssertionError((Object)exception);
            }
        }

        public String toString() {
            return "[" + this.minY + ", " + this.maxY + "]";
        }
    }
}

