/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.autocodec.data.AbstractNumberData;
import builderb0y.autocodec.data.BooleanData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.StringData;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.OverrideTracker;
import builderb0y.bigglobe.columns.scripted.classes.TypeSpec;
import builderb0y.bigglobe.dynamicRegistries.BigGlobeDynamicRegistries;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.scripting.wrappers.ArrayWrapper;
import builderb0y.bigglobe.scripting.wrappers.BlockStateWrapper;
import builderb0y.bigglobe.scripting.wrappers.BlockWrapper;
import builderb0y.bigglobe.scripting.wrappers.ConstantMap;
import builderb0y.bigglobe.scripting.wrappers.ConstantSet;
import builderb0y.bigglobe.scripting.wrappers.entries.BiomeEntry;
import builderb0y.bigglobe.scripting.wrappers.entries.ConfiguredFeatureEntry;
import builderb0y.bigglobe.scripting.wrappers.entries.WoodPaletteEntry;
import builderb0y.bigglobe.scripting.wrappers.tags.BiomeTag;
import builderb0y.bigglobe.scripting.wrappers.tags.BlockTag;
import builderb0y.bigglobe.scripting.wrappers.tags.ConfiguredFeatureTag;
import builderb0y.bigglobe.scripting.wrappers.tags.TagWrapper;
import builderb0y.bigglobe.scripting.wrappers.tags.WoodPaletteTag;
import builderb0y.bigglobe.util.DelayedEntry;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.util.TypeInfos;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BuiltinTypeSpec
extends TypeSpec {
    public final BuiltinJavaType java_type;

    public BuiltinTypeSpec(BuiltinJavaType java_type) {
        this.java_type = java_type;
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.java_type.typeInfo;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    @Nullable
    public OverrideTracker getOverrideTracker() {
        return null;
    }

    @Override
    public void setupEnvironment(MutableScriptEnvironment environment, @Nullable InsnTree loadCustomClass) {
    }

    @Override
    public String name() {
        return this.java_type.lowerCaseName;
    }

    @Override
    public InsnTree parseConstant(ClassHierarchy hierarchy, Data data, InsnTree loadColumn) {
        if (data.isEmpty()) {
            return InsnTrees.ldc(null, this.getTypeInfo());
        }
        return switch (this.java_type.ordinal()) {
            case 0 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).byteValue());
            case 1 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).shortValue());
            case 2 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).intValue());
            case 3 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).longValue());
            case 4 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).floatValue());
            case 5 -> InsnTrees.ldc(BuiltinTypeSpec.asNumber(data).doubleValue());
            case 6 -> InsnTrees.ldc(BuiltinTypeSpec.asBoolean((Data)data).value);
            case 37 -> InsnTrees.ldc(BuiltinTypeSpec.registry(hierarchy, data, class_7924.field_41254).comp_349(), BlockWrapper.TYPE);
            case 38 -> InsnTrees.ldc(new BlockTag(BuiltinTypeSpec.tag(hierarchy, data, class_7924.field_41254)), BlockTag.TYPE);
            case 39 -> InsnTrees.ldc(BuiltinTypeSpec.blockState(hierarchy, data), BlockStateWrapper.TYPE);
            case 40 -> InsnTrees.ldc(new BiomeEntry((class_6880<class_1959>)BuiltinTypeSpec.registry(hierarchy, data, class_7924.field_41236)), BiomeEntry.TYPE);
            case 41 -> InsnTrees.ldc(new BiomeTag(BuiltinTypeSpec.tag(hierarchy, data, class_7924.field_41236)), BiomeTag.TYPE);
            case 42 -> InsnTrees.ldc(new ConfiguredFeatureEntry((class_6880<class_2975<?, ?>>)BuiltinTypeSpec.registry(hierarchy, data, class_7924.field_41239)), ConfiguredFeatureEntry.TYPE);
            case 43 -> InsnTrees.ldc(new ConfiguredFeatureTag(BuiltinTypeSpec.tag(hierarchy, data, class_7924.field_41239)), ConfiguredFeatureTag.TYPE);
            case 44 -> InsnTrees.ldc(new WoodPaletteEntry(BuiltinTypeSpec.registry(hierarchy, data, BigGlobeDynamicRegistries.WOOD_PALETTE_REGISTRY_KEY)), WoodPaletteEntry.INFO.type);
            case 45 -> InsnTrees.ldc(new WoodPaletteTag(BuiltinTypeSpec.tag(hierarchy, data, BigGlobeDynamicRegistries.WOOD_PALETTE_REGISTRY_KEY)), WoodPaletteTag.TYPE);
            default -> throw new IllegalArgumentException("Can't create a constant of type " + this.java_type.lowerCaseName);
        };
    }

    public static AbstractNumberData asNumber(Data data) {
        AbstractNumberData number = data.tryAsNumber();
        if (number != null) {
            return number;
        }
        throw new ClassCastException("Not a number: " + String.valueOf(data));
    }

    public static BooleanData asBoolean(Data data) {
        BooleanData result = data.tryAsBoolean();
        if (result != null) {
            return result;
        }
        throw new ClassCastException("Not a boolean: " + String.valueOf(data));
    }

    public static StringData asString(Data data) {
        StringData result = data.tryAsString();
        if (result != null) {
            return result;
        }
        throw new ClassCastException("Not a string: " + String.valueOf(data));
    }

    public static <T> class_6880<T> registry(ClassHierarchy hierarchy, Data data, class_5321<class_2378<T>> registryKey) {
        return hierarchy.registry.registries.getRegistry(registryKey).getEntry(class_5321.method_29179(registryKey, (class_2960)IdentifierVersions.create(BuiltinTypeSpec.asString((Data)data).value)));
    }

    public static <T> DelayedEntryList<T> tag(ClassHierarchy hierarchy, Data data, class_5321<class_2378<T>> registryKey) {
        ListData list = data.tryAsList();
        DelayedEntryList<T> result = list != null ? new DelayedEntryList<T>(hierarchy.registry.registries.getRegistry(registryKey), list.value.stream().map(BuiltinTypeSpec::asString).map(string -> string.value).map(DelayedEntry::new).toList()) : DelayedEntryList.create(hierarchy.registry.registries.getRegistry(registryKey), BuiltinTypeSpec.asString((Data)data).value);
        result.delay();
        return result;
    }

    public static class_2680 blockState(ClassHierarchy hierarchy, Data data) {
        return BlockStateCoder.decodeStateWithMissingErrors(hierarchy.registry.registries.getRegistry(class_7924.field_41254), BuiltinTypeSpec.asString((Data)data).value).unwrapEager(arg_0 -> ((Logger)BigGlobeMod.LOGGER).warn(arg_0), IllegalArgumentException::new).state();
    }

    public static enum BuiltinJavaType implements class_3542
    {
        BYTE(TypeInfos.BYTE),
        SHORT(TypeInfos.SHORT),
        INT(TypeInfos.INT),
        LONG(TypeInfos.LONG),
        FLOAT(TypeInfos.FLOAT),
        DOUBLE(TypeInfos.DOUBLE),
        BOOLEAN(TypeInfos.BOOLEAN),
        VOID(TypeInfos.VOID),
        ITERATOR(Iterator.class),
        LIST_ITERATOR(ListIterator.class),
        MAP(Map.class),
        MAP_ENTRY(Map.Entry.class),
        SORTED_MAP(SortedMap.class),
        NAVIGABLE_MAP(NavigableMap.class),
        TREE_MAP(TreeMap.class),
        HASH_MAP(HashMap.class),
        LINKED_HASH_MAP(LinkedHashMap.class),
        CONSTANT_MAP(ConstantMap.class),
        ITERABLE(Iterable.class),
        COLLECTION(Collection.class),
        SET(Set.class),
        SORTED_SET(SortedSet.class),
        NAVIGABLE_SET(NavigableSet.class),
        TREE_SET(TreeSet.class),
        HASH_SET(HashSet.class),
        LINKED_HASH_SET(LinkedHashSet.class),
        CONSTANT_SET(ConstantSet.class),
        LIST(List.class),
        LINKED_LIST(LinkedList.class),
        ARRAY_LIST(ArrayList.class),
        CONSTANT_LIST(ArrayWrapper.class),
        QUEUE(Queue.class),
        DEQUE(Deque.class),
        ARRAY_DEQUE(ArrayDeque.class),
        PRIORITY_QUEUE(PriorityQueue.class),
        RANDOM_LIST(IRandomList.class),
        RANDOM_ARRAY_LIST(RandomList.class),
        BLOCK(BlockWrapper.TYPE),
        BLOCK_TAG(BlockTag.TYPE),
        BLOCK_STATE(BlockStateWrapper.TYPE),
        BIOME(BiomeEntry.TYPE),
        BIOME_TAG(BiomeTag.TYPE),
        CONFIGURED_FEATURE(ConfiguredFeatureEntry.TYPE),
        CONFIGURED_FEATURE_TAG(ConfiguredFeatureTag.TYPE),
        WOOD_PALETTE(WoodPaletteEntry.INFO.type),
        WOOD_PALETTE_TAG(WoodPaletteTag.TYPE),
        TAG(TagWrapper.TYPE);

        public static final BuiltinJavaType[] VALUES;
        public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);
        public final TypeInfo typeInfo;

        private BuiltinJavaType(TypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        private BuiltinJavaType(Class<?> clazz) {
            this.typeInfo = TypeInfo.of(clazz);
        }

        public String method_15434() {
            return this.lowerCaseName;
        }

        static {
            VALUES = BuiltinJavaType.values();
        }
    }
}

