/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.entries;

import builderb0y.autocodec.annotations.AddPseudoField;
import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.bigglobe.columns.scripted.AccessSchema;
import builderb0y.bigglobe.columns.scripted.MappedRangeArray;
import builderb0y.bigglobe.columns.scripted.MappedRangeNumberArray;
import builderb0y.bigglobe.columns.scripted.MappedRangeObjectArray;
import builderb0y.bigglobe.columns.scripted.Valid;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.BooleanToConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;
import builderb0y.scripting.bytecode.tree.flow.IfElseInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.NewArrayWithLengthInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.BitwiseOrInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_6880;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

@AddPseudoField(value="decodeContext")
public abstract class AbstractColumnEntry
implements ColumnEntry,
DependencyView.SetBasedMutableDependencyView {
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> COMPUTE_ONE = new ColumnEntry.ColumnEntryMemory.Key("computeOne");
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> COMPUTE_ALL_TEST = new ColumnEntry.ColumnEntryMemory.Key("computeAllTest");
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> COMPUTE_ALL_NO_TEST = new ColumnEntry.ColumnEntryMemory.Key("computeAllNoTest");
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> EXTRACT = new ColumnEntry.ColumnEntryMemory.Key("extract");
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> VALID_MIN_Y = new ColumnEntry.ColumnEntryMemory.Key("validMinY");
    public static final ColumnEntry.ColumnEntryMemory.Key<MethodCompileContext> VALID_MAX_Y = new ColumnEntry.ColumnEntryMemory.Key("validMaxY");
    public final AccessSchema params;
    public final @VerifyNullable Valid valid;
    public final @DefaultBoolean(value=true) boolean cache;
    public final transient Set<class_6880<? extends DependencyView>> dependencies;

    public AbstractColumnEntry(AccessSchema params, @VerifyNullable Valid valid, @DefaultBoolean(value=true) boolean cache, DecodeContext<?> decodeContext) {
        this.params = params;
        this.valid = valid;
        this.cache = cache;
        this.dependencies = new HashSet<class_6880<? extends DependencyView>>();
        if (params.is_3d() && cache && (valid == null || valid.min_y() == null || valid.max_y() == null)) {
            decodeContext.logger().logError((Object)"Upper or lower bound not specified, and caching is enabled. This may result in poor worldgen performance, as it may compute more Y levels than intended.");
        }
    }

    @Override
    public Set<class_6880<? extends DependencyView>> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public DecodeContext<?> decodeContext() {
        return null;
    }

    @Override
    public AccessSchema getAccessSchema() {
        return this.params;
    }

    @Override
    public boolean hasField() {
        return this.cache;
    }

    public boolean hasValid() {
        return this.valid != null && this.valid.isUseful(this.getAccessSchema().is_3d());
    }

    public boolean is3D() {
        return this.getAccessSchema().is_3d();
    }

    @Override
    public void setupMemory(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context) {
        ColumnEntry.super.setupMemory(memory, context);
        String internalName = memory.getTyped(ColumnEntry.ColumnEntryMemory.INTERNAL_NAME);
        AccessSchema.AccessContext accessContext = memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT);
        if (this.is3D()) {
            if (this.hasField()) {
                MethodCompileContext computeAllTest = context.mainClass.newMethod(1, "computeAllTest_" + internalName, TypeInfos.VOID, new LazyVarInfo[0]);
                memory.putTyped(COMPUTE_ALL_TEST, computeAllTest);
                MethodCompileContext computeAllNoTest = context.mainClass.newMethod(1, "computeAllNoTest_" + internalName, TypeInfos.VOID, new LazyVarInfo[0]);
                memory.putTyped(COMPUTE_ALL_NO_TEST, computeAllNoTest);
                MethodCompileContext extractMethod = context.mainClass.newMethod(1, "extract_" + internalName, accessContext.exposedType(), new LazyVarInfo("y", TypeInfos.INT));
                memory.putTyped(EXTRACT, extractMethod);
            }
            if (this.hasValid()) {
                if (this.valid.where() != null) {
                    MethodCompileContext test = context.mainClass.newMethod(1, "test_" + internalName, TypeInfos.BOOLEAN, new LazyVarInfo[0]);
                    memory.putTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE, test);
                }
                if (this.valid.min_y() != null) {
                    MethodCompileContext minY = context.mainClass.newMethod(1, "minY_" + internalName, TypeInfos.INT, new LazyVarInfo[0]);
                    memory.putTyped(VALID_MIN_Y, minY);
                }
                if (this.valid.max_y() != null) {
                    MethodCompileContext maxY = context.mainClass.newMethod(1, "maxY_" + internalName, TypeInfos.INT, new LazyVarInfo[0]);
                    memory.putTyped(VALID_MAX_Y, maxY);
                }
            }
            if (this.hasField() || this.hasValid()) {
                MethodCompileContext computeOneMethod = context.mainClass.newMethod(1, "computeOne_" + internalName, accessContext.exposedType(), new LazyVarInfo("y", TypeInfos.INT));
                memory.putTyped(COMPUTE_ONE, computeOneMethod);
            }
        } else {
            if (this.hasValid()) {
                if (this.hasField()) {
                    MethodCompileContext computeTest = context.mainClass.newMethod(1, "computeTest_" + internalName, accessContext.exposedType(), new LazyVarInfo[0]);
                    memory.putTyped(ColumnEntry.ColumnEntryMemory.COMPUTE_TEST, computeTest);
                }
                MethodCompileContext test = context.mainClass.newMethod(1, "test_" + internalName, TypeInfos.BOOLEAN, new LazyVarInfo[0]);
                memory.putTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE, test);
            }
            if (this.hasField() || this.hasValid()) {
                MethodCompileContext computeNoTest = context.mainClass.newMethod(1, "computeNoTest_" + internalName, accessContext.commonType(), new LazyVarInfo[0]);
                memory.putTyped(ColumnEntry.ColumnEntryMemory.COMPUTE_NO_TEST, computeNoTest);
            }
        }
    }

    @Override
    public void populateField(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, FieldCompileContext getterMethod) {
        ColumnEntry.super.populateField(memory, context, getterMethod);
        if (this.is3D()) {
            AccessSchema.AccessContext accessContext = memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT);
            boolean primitive = accessContext.exposedType().isPrimitive();
            Class arrayClass = primitive ? MappedRangeNumberArray.class : MappedRangeObjectArray.class;
            context.constructor.appendCode(context.root().registry.parserFlags(), "valueField = Array.new(empty)", environment -> environment.addVariableRenamedGetField(context.loadSelf(), "valueField", memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD).info).addType("Array", arrayClass).addQualifiedConstructor(arrayClass).addVariable("empty", primitive ? InsnTrees.getStatic(FieldInfo.getField(NumberArray.class, "EMPTY_" + accessContext.exposedType().getSort().name())) : new NewArrayWithLengthInsnTree(accessContext.exposedType(), InsnTrees.ldc(0))));
        }
    }

    @Override
    public void populateGetter(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext getterMethod) {
        ColumnEntry.super.populateGetter(memory, context, getterMethod);
        if (this.is3D()) {
            if (this.hasField()) {
                this.populateGetterWithField3D(memory, context, getterMethod);
            } else {
                this.populateGetterWithoutField3D(memory, context, getterMethod);
            }
        } else if (this.hasField()) {
            this.populateGetterWithField2D(memory, context, getterMethod);
        } else {
            this.populateGetterWithoutField2D(memory, context, getterMethod);
        }
    }

    public void populateGetterWithField3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext getterMethod) {
        MethodCompileContext preComputeMethod = memory.getTyped(ColumnEntry.ColumnEntryMemory.PRE_COMPUTER);
        MethodCompileContext extractMethod = memory.getTyped(EXTRACT);
        InsnTrees.invokeInstance(context.loadSelf(), preComputeMethod.info, new InsnTree[0]).emitBytecode(getterMethod);
        InsnTrees.return_(InsnTrees.invokeInstance(context.loadSelf(), extractMethod.info, InsnTrees.load("y", TypeInfos.INT))).emitBytecode(getterMethod);
        getterMethod.endCode();
        this.populateExtract(memory, context, extractMethod);
    }

    public void populateGetterWithoutField3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext getterMethod) {
        if (this.hasValid()) {
            ConditionTree condition = ConstantConditionTree.TRUE;
            LoadInsnTree y = InsnTrees.load("y", TypeInfos.INT);
            if (this.valid.where() != null) {
                MethodCompileContext test = memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE);
                condition = InsnTrees.and(condition, (ConditionTree)new BooleanToConditionTree(InsnTrees.invokeInstance(context.loadSelf(), test.info, new InsnTree[0])));
            }
            if (this.valid.min_y() != null) {
                MethodCompileContext minY = memory.getTyped(VALID_MIN_Y);
                condition = InsnTrees.and(condition, IntCompareConditionTree.greaterThanOrEqual(y, InsnTrees.invokeInstance(context.loadSelf(), minY.info, new InsnTree[0])));
            }
            if (this.valid.max_y() != null) {
                MethodCompileContext maxY = memory.getTyped(VALID_MAX_Y);
                condition = InsnTrees.and(condition, IntCompareConditionTree.lessThan(y, InsnTrees.invokeInstance(context.loadSelf(), maxY.info, new InsnTree[0])));
            }
            MethodCompileContext computeOneMethod = memory.getTyped(COMPUTE_ONE);
            LazyVarInfo self = new LazyVarInfo("this", getterMethod.clazz.info);
            new IfElseInsnTree(condition, InsnTrees.return_(InsnTrees.invokeInstance(InsnTrees.load(self), computeOneMethod.info, y)), InsnTrees.return_(this.valid.getFallback(this.params.type(), context.root())), TypeInfos.VOID).emitBytecode(getterMethod);
            getterMethod.endCode();
        }
    }

    public void populateGetterWithField2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext getterMethod) {
        MethodCompileContext preComputeMethod = memory.getTyped(ColumnEntry.ColumnEntryMemory.PRE_COMPUTER);
        FieldCompileContext valueField = memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD);
        InsnTrees.invokeInstance(context.loadSelf(), preComputeMethod.info, new InsnTree[0]).emitBytecode(getterMethod);
        InsnTrees.return_(InsnTrees.getField(context.loadSelf(), valueField.info)).emitBytecode(getterMethod);
        getterMethod.endCode();
        if (this.hasValid()) {
            MethodCompileContext computeTest = memory.getTyped(ColumnEntry.ColumnEntryMemory.COMPUTE_TEST);
            MethodCompileContext computeNoTest = memory.getTyped(ColumnEntry.ColumnEntryMemory.COMPUTE_NO_TEST);
            MethodCompileContext testMethod = memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE);
            computeTest.setCode(context.root().registry.parserFlags(), "return(test() ? compute() : fallback)", environment -> environment.addFunctionInvoke("test", context.loadSelf(), testMethod.info).addFunctionInvoke("compute", context.loadSelf(), computeNoTest.info).addVariable("fallback", this.valid.getFallback(this.params.type(), context.root())));
        }
    }

    public void populateGetterWithoutField2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext getterMethod) {
        if (this.hasValid()) {
            MethodCompileContext computeNoTest = memory.getTyped(ColumnEntry.ColumnEntryMemory.COMPUTE_NO_TEST);
            MethodCompileContext testMethod = memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE);
            getterMethod.setCode(context.root().registry.parserFlags(), "return(test() ? compute() : fallback)", environment -> environment.addFunctionInvoke("test", context.loadSelf(), testMethod.info).addFunctionInvoke("compute", context.loadSelf(), computeNoTest.info).addVariable("fallback", this.valid.getFallback(this.params.type(), context.root())));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void populatePreComputer(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext preComputeMethod) {
        ColumnEntry.super.populatePreComputer(memory, context, preComputeMethod);
        if (this.is3D()) {
            this.populatePreCompute3D(memory, context, preComputeMethod);
        } else {
            this.populatePreCompute2D(memory, context, preComputeMethod);
        }
    }

    public void populatePreCompute2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext preComputeMethod) {
        int flagsIndex = memory.getTyped(ColumnEntry.ColumnEntryMemory.FLAGS_INDEX);
        FieldCompileContext valueField = memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD);
        MethodCompileContext compute = memory.getTyped(this.hasValid() ? ColumnEntry.ColumnEntryMemory.COMPUTE_TEST : ColumnEntry.ColumnEntryMemory.COMPUTE_NO_TEST);
        preComputeMethod.setCode(context.root().registry.parserFlags(), "int oldFlags = flagsField\nint newFlags = oldFlags | flagsBitmask\nif (oldFlags != newFlags:\n\tflagsField = newFlags\n\tvalue = compute()\n)\n", environment -> environment.addVariableRenamedGetField(context.loadSelf(), "flagsField", context.flagsField(flagsIndex)).addVariableConstant("flagsBitmask", DataCompileContext.flagsFieldBitmask(flagsIndex)).addFunctionInvoke("compute", context.loadSelf(), compute.info).addVariableRenamedGetField(context.loadSelf(), "value", valueField.info));
    }

    public void populatePreCompute3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext preComputeMethod) {
        int flagsIndex = memory.getTyped(ColumnEntry.ColumnEntryMemory.FLAGS_INDEX);
        FieldCompileContext valueField = memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD);
        MethodCompileContext compute = memory.getTyped(this.hasValid() ? COMPUTE_ALL_TEST : COMPUTE_ALL_NO_TEST);
        preComputeMethod.setCode(context.root().registry.parserFlags(), "int oldFlags = flagsField\nint newFlags = oldFlags | flagsBitmask\nif (oldFlags != newFlags:\n\tflagsField = newFlags\n\tcompute()\n)\n", environment -> environment.addVariableRenamedGetField(context.loadSelf(), "flagsField", context.flagsField(flagsIndex)).addVariableConstant("flagsBitmask", DataCompileContext.flagsFieldBitmask(flagsIndex)).addFunctionInvoke("compute", context.loadSelf(), compute.info).addVariableRenamedGetField(context.loadSelf(), "value", valueField.info));
        MethodCompileContext computeAllTestMethod = memory.getTyped(COMPUTE_ALL_TEST);
        MethodCompileContext computeAllNoTestMethod = memory.getTyped(COMPUTE_ALL_NO_TEST);
        String computeSource = this.getComputeSource();
        computeAllTestMethod.setCode(context.root().registry.parserFlags(), computeSource, environment -> {
            environment.addVariableRenamedGetField(context.loadSelf(), "valueField", valueField.info).addMethodInvokes(MappedRangeArray.class, "reallocateNone", "reallocateMin", "reallocateMax", "reallocateBoth", "invalidate").addVariable("this", context.loadSelf()).addVariable("column", context.loadColumn()).addFunctionInvoke("actuallyCompute", context.loadSelf(), computeAllNoTestMethod.info);
            if (this.valid != null) {
                if (this.valid.where() != null) {
                    MethodCompileContext test = memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE);
                    environment.addFunctionInvoke("test", context.loadSelf(), test.info);
                }
                if (this.valid.min_y() != null) {
                    MethodCompileContext minY = memory.getTyped(VALID_MIN_Y);
                    environment.addFunctionInvoke("minY", context.loadSelf(), minY.info);
                }
                if (this.valid.max_y() != null) {
                    MethodCompileContext maxY = memory.getTyped(VALID_MAX_Y);
                    environment.addFunctionInvoke("maxY", context.loadSelf(), maxY.info);
                }
            }
        });
        this.populateComputeAll(memory, context, computeAllNoTestMethod);
    }

    public void populateExtract(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext extractMethod) {
        AccessSchema.AccessContext accessContext = memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT);
        extractMethod.setCode(context.root().registry.parserFlags(), this.extractSource(), environment -> {
            MutableScriptEnvironment mutableScriptEnvironment = environment.addVariableLoad("y", TypeInfos.INT).addVariable("arrayField", InsnTrees.getField(context.loadSelf(), memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD).info)).addFieldGet("valid", MappedRangeArray.INFO.valid).addFieldGet("minCached", MappedRangeArray.INFO.minCached).addFieldGet("maxCached", MappedRangeArray.INFO.maxCached).addFieldGet("minAccessible", MappedRangeArray.INFO.minAccessible).addFieldGet("maxAccessible", MappedRangeArray.INFO.maxAccessible).addFieldGet("array", MappedRangeNumberArray.ARRAY);
            mutableScriptEnvironment.addMethodInvoke("get", switch (accessContext.exposedType().getSort()) {
                case TypeInfo.Sort.BYTE -> NumberArray.INFO.implGetB;
                case TypeInfo.Sort.SHORT -> NumberArray.INFO.implGetS;
                case TypeInfo.Sort.INT -> NumberArray.INFO.implGetI;
                case TypeInfo.Sort.LONG -> NumberArray.INFO.implGetL;
                case TypeInfo.Sort.FLOAT -> NumberArray.INFO.implGetF;
                case TypeInfo.Sort.DOUBLE -> NumberArray.INFO.implGetD;
                case TypeInfo.Sort.BOOLEAN -> NumberArray.INFO.implGetZ;
                default -> throw new IllegalStateException("Unsupported type: " + String.valueOf(accessContext));
            }).addVariable("fallback", this.valid != null ? this.valid.getFallback(this.params.type(), context.root()) : InsnTrees.ldc(0)).addFunctionInvoke("compute", context.loadSelf(), memory.getTyped(AbstractColumnEntry.COMPUTE_ONE).info);
        });
    }

    public String extractSource() {
        if (this.hasValid()) {
            if (this.valid.where() != null) {
                if (this.valid.min_y() != null) {
                    if (this.valid.max_y() != null) {
                        return "\tvar array = arrayField\n\tunless (array.valid: return(fallback))\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y >= array.minAccessible && y < array.maxAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
                    }
                    return "\tvar array = arrayField\n\tunless (array.valid: return(fallback))\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y >= array.minAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
                }
                if (this.valid.max_y() != null) {
                    return "\tvar array = arrayField\n\tunless (array.valid: return(fallback))\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y < array.maxAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
                }
                return "\tvar array = arrayField\n\tunless (array.valid: return(fallback))\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\treturn(compute(y))\n";
            }
            if (this.valid.min_y() != null) {
                if (this.valid.max_y() != null) {
                    return "\tvar array = arrayField\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y >= array.minAccessible && y < array.maxAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
                }
                return "\tvar array = arrayField\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y >= array.minAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
            }
            if (this.valid.max_y() != null) {
                return "\tvar array = arrayField\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\tif (y < array.maxAccessible:\n\t\treturn(compute(y))\n\t)\n\treturn(fallback)\n";
            }
            return "\tvar array = arrayField\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\treturn(compute(y))\n";
        }
        return "\tvar array = arrayField\n\tif (y >= array.minCached && y < array.maxCached:\n\t\treturn(array.array.get(y - array.minCached))\n\t)\n\treturn(compute(y))\n";
    }

    public String getComputeSource() {
        if (this.hasValid()) {
            if (this.valid.where() != null) {
                if (this.valid.min_y() != null) {
                    if (this.valid.max_y() != null) {
                        return "\tif (test():\n\t\tif (valueField.reallocateBoth(column, minY(), maxY()):\n\t\t\tactuallyCompute()\n\t\t)\n\t)\n\telse (\n\t\tvalueField.invalidate()\n\t)\n";
                    }
                    return "\tif (test():\n\t\tif (valueField.reallocateMin(column, minY()):\n\t\t\tactuallyCompute()\n\t\t)\n\t)\n\telse (\n\t\tvalueField.invalidate()\n\t)\n";
                }
                if (this.valid.max_y() != null) {
                    return "\tif (test():\n\t\tif (valueField.reallocateMax(column, maxY()):\n\t\t\tactuallyCompute()\n\t\t)\n\t)\n\telse (\n\t\tvalueField.invalidate()\n\t)\n";
                }
                return "\tif (test():\n\t\tif (valueField.reallocateNone(column):\n\t\t\tactuallyCompute()\n\t\t)\n\t)\n\telse (\n\t\tvalueField.invalidate()\n\t)\n";
            }
            if (this.valid.min_y() != null) {
                if (this.valid.max_y() != null) {
                    return "\tif (valueField.reallocateBoth(column, minY(), maxY()):\n\t\tactuallyCompute()\n\t)\n";
                }
                return "\tif (valueField.reallocateMin(column, minY()):\n\t\tactuallyCompute()\n\t)\n";
            }
            if (this.valid.max_y() != null) {
                return "\tif (valueField.reallocateMax(column, maxY()):\n\t\tactuallyCompute()\n\t)\n";
            }
            return "\tif (valueField.reallocateNone(column):\n\t\tactuallyCompute()\n\t)\n";
        }
        return "\tif (valueField.reallocateNone(column):\n\t\tactuallyCompute()\n\t)\n";
    }

    public void populateComputeAll(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext computeAllMethod) {
        AccessSchema.AccessContext accessContext = memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT);
        computeAllMethod.setCode(context.root().registry.parserFlags(), "var array = valueField\nint minY = array.minCached\nint maxY = array.maxCached\nvar actualArray = array.array\nfor (int y = minY, y < maxY, ++y:\n\tactualArray.set(y - minY, compute(y))\n)\n", environment -> {
            MutableScriptEnvironment mutableScriptEnvironment = environment.addVariableRenamedGetField(context.loadSelf(), "valueField", memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD).info).addFieldGet("minCached", MappedRangeArray.INFO.minCached).addFieldGet("maxCached", MappedRangeArray.INFO.maxCached).addFieldGet("array", MappedRangeNumberArray.ARRAY);
            mutableScriptEnvironment.addMethodInvoke("set", switch (accessContext.exposedType().getSort()) {
                case TypeInfo.Sort.BYTE -> NumberArray.INFO.implSetB;
                case TypeInfo.Sort.SHORT -> NumberArray.INFO.implSetS;
                case TypeInfo.Sort.INT -> NumberArray.INFO.implSetI;
                case TypeInfo.Sort.LONG -> NumberArray.INFO.implSetL;
                case TypeInfo.Sort.FLOAT -> NumberArray.INFO.implSetF;
                case TypeInfo.Sort.DOUBLE -> NumberArray.INFO.implSetD;
                case TypeInfo.Sort.BOOLEAN -> NumberArray.INFO.implSetZ;
                default -> throw new IllegalStateException("Unsupported type: " + String.valueOf(accessContext));
            }).addFunctionInvoke("compute", context.loadSelf(), memory.getTyped(AbstractColumnEntry.COMPUTE_ONE).info);
        });
    }

    @Override
    public void populateSetter(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext setterMethod) {
        ColumnEntry.super.populateSetter(memory, context, setterMethod);
        if (this.getAccessSchema().is_3d()) {
            this.populateSetter3D(memory, context, setterMethod);
        } else {
            this.populateSetter2D(memory, context, setterMethod);
        }
    }

    public void populateSetter2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext setterMethod) {
        LazyVarInfo value = new LazyVarInfo("value", memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT).exposedType());
        FieldCompileContext valueField = memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD);
        int flagsIndex = memory.getTyped(ColumnEntry.ColumnEntryMemory.FLAGS_INDEX);
        FieldInfo flagsField = context.flagsField(flagsIndex);
        int bitMask = DataCompileContext.flagsFieldBitmask(flagsIndex);
        InsnTrees.putField(context.loadSelf(), flagsField, new BitwiseOrInsnTree(InsnTrees.getField(context.loadSelf(), flagsField), InsnTrees.ldc(bitMask), 128)).emitBytecode(setterMethod);
        InsnTrees.putField(context.loadSelf(), valueField.info, InsnTrees.load(value)).emitBytecode(setterMethod);
        InsnTrees.return_(InsnTrees.noop).emitBytecode(setterMethod);
        setterMethod.endCode();
    }

    public void populateSetter3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext setterMethod) {
        AccessSchema.AccessContext accessContext = memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT);
        Integer flagsIndex = memory.getTyped(ColumnEntry.ColumnEntryMemory.FLAGS_INDEX);
        setterMethod.setCode(context.root().registry.parserFlags(), "if (var*(mappedArray := valueField).valid:\n\tvar array = mappedArray.array\n\ty -= mappedArray.minCached\n\tif (y >= 0 && y < array.length:\n\t\tarray.set(y, value)\n\t)\n)\n", environment -> {
            MutableScriptEnvironment mutableScriptEnvironment = environment.addVariableRenamedGetField(context.loadSelf(), "valueField", memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD).info).addVariableRenamedGetField(context.loadSelf(), "flags", context.flagsField(flagsIndex)).addVariableConstant("flagBitmask", DataCompileContext.flagsFieldBitmask(flagsIndex)).addVariableLoad("y", TypeInfos.INT).addVariableLoad("value", accessContext.exposedType()).addFieldGet("valid", MappedRangeArray.INFO.valid).addFieldGet("minCached", MappedRangeArray.INFO.minCached).addFieldGet("maxCached", MappedRangeArray.INFO.maxCached).addFieldGet("array", MappedRangeNumberArray.ARRAY).addFieldInvoke(NumberArray.INFO.length);
            mutableScriptEnvironment.addMethodInvoke("set", switch (accessContext.exposedType().getSort()) {
                case TypeInfo.Sort.BYTE -> NumberArray.INFO.implSetB;
                case TypeInfo.Sort.SHORT -> NumberArray.INFO.implSetS;
                case TypeInfo.Sort.INT -> NumberArray.INFO.implSetI;
                case TypeInfo.Sort.LONG -> NumberArray.INFO.implSetL;
                case TypeInfo.Sort.FLOAT -> NumberArray.INFO.implSetF;
                case TypeInfo.Sort.DOUBLE -> NumberArray.INFO.implSetD;
                case TypeInfo.Sort.BOOLEAN -> NumberArray.INFO.implSetZ;
                default -> throw new IllegalStateException("Unsupported type: " + String.valueOf(accessContext));
            });
        });
    }

    @Override
    public void emitComputer(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context) throws ScriptParsingException {
        if (this.getAccessSchema().is_3d()) {
            this.emitCompute3D(memory, context);
        } else {
            this.emitCompute2D(memory, context);
        }
    }

    public void emitCompute2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context) throws ScriptParsingException {
        if (this.valid != null && this.valid.where() != null) {
            context.setMethodCode(memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE), this.valid.where(), false, this, memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESSOR_ID), context.root().registry.parserFlags());
        }
        this.populateCompute2D(memory, context, memory.getTyped(this.hasField() || this.hasValid() ? ColumnEntry.ColumnEntryMemory.COMPUTE_NO_TEST : ColumnEntry.ColumnEntryMemory.GETTER));
    }

    public abstract void populateCompute2D(ColumnEntry.ColumnEntryMemory var1, DataCompileContext var2, MethodCompileContext var3) throws ScriptParsingException;

    public void emitCompute3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context) throws ScriptParsingException {
        if (this.hasValid()) {
            if (this.valid.where() != null) {
                context.setMethodCode(memory.getTyped(ColumnEntry.ColumnEntryMemory.VALID_WHERE), this.valid.where(), false, this, memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESSOR_ID), context.root().registry.parserFlags());
            }
            if (this.valid.min_y() != null) {
                context.setMethodCode(memory.getTyped(VALID_MIN_Y), this.valid.min_y(), false, this, memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESSOR_ID), context.root().registry.parserFlags());
            }
            if (this.valid.max_y() != null) {
                context.setMethodCode(memory.getTyped(VALID_MAX_Y), this.valid.max_y(), false, this, memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESSOR_ID), context.root().registry.parserFlags());
            }
        }
        this.populateCompute3D(memory, context, memory.getTyped(this.hasField() || this.hasValid() ? COMPUTE_ONE : ColumnEntry.ColumnEntryMemory.GETTER));
    }

    public abstract void populateCompute3D(ColumnEntry.ColumnEntryMemory var1, DataCompileContext var2, MethodCompileContext var3) throws ScriptParsingException;
}

