/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat.voxy;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.compat.voxy.QueueingStorageBackend;
import builderb0y.bigglobe.compat.voxy.VoxyWorldGenerator;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.mixins.Voxy_WorldSection_DataGetter;
import builderb0y.bigglobe.util.AsyncRunner;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import java.util.Arrays;
import me.cortex.voxy.common.storage.StorageBackend;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldSection;
import me.cortex.voxy.common.world.other.Mapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_1922;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2794;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractVoxyWorldGenerator {
    public static final int WORLD_SIZE_IN_CHUNKS = class_3532.method_15339((int)1875000);
    public final WorldEngine engine;
    public final BigGlobeScriptedChunkGenerator generator;
    public final QueueingStorageBackend.GenerationQueue queue;
    public final Thread thread;
    public final ScriptedColumn[] columns;
    public final int plainsBiomeId;
    public volatile boolean running;
    public final byte topSkylight;

    public AbstractVoxyWorldGenerator(WorldEngine engine, class_3218 world, BigGlobeScriptedChunkGenerator generator) {
        this.engine = engine;
        this.generator = generator;
        this.queue = new QueueingStorageBackend.GenerationQueue();
        for (StorageBackend backend : engine.storage.collectAllBackends()) {
            if (!(backend instanceof QueueingStorageBackend)) continue;
            QueueingStorageBackend queueing = (QueueingStorageBackend)backend;
            queueing.setQueue(this.queue);
        }
        this.thread = new Thread(this::runLoop, "Big Globe Voxy worldgen thread");
        this.columns = new ScriptedColumn[1024];
        ScriptedColumn.Factory factory = generator.columnEntryRegistry.columnFactory;
        ScriptedColumn.Params params = new ScriptedColumn.Params(generator, 0, 0, ScriptedColumn.ColumnUsage.RAW_GENERATION.voxyHints(0));
        for (int index = 0; index < 1024; ++index) {
            this.columns[index] = factory.create(params);
        }
        this.plainsBiomeId = engine.getMapper().getIdForBiome(RegistryVersions.getEntry(world.method_30349(), class_1972.field_9451));
        this.topSkylight = (byte)(world.method_8597().comp_642() ? 15 : 0);
    }

    @Nullable
    public static AbstractVoxyWorldGenerator createGenerator(class_638 newWorld, WorldEngine engine) {
        class_2794 class_27942;
        class_3218 serverWorld;
        class_1132 server;
        if (BigGlobeConfig.INSTANCE.get().voxyIntegration.useWorldgenThread && (server = class_310.method_1551().method_1576()) != null && (serverWorld = server.method_3847(newWorld.method_27983())) != null && (class_27942 = serverWorld.method_14178().method_12129()) instanceof BigGlobeScriptedChunkGenerator) {
            BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
            return new VoxyWorldGenerator(engine, serverWorld, generator);
        }
        return null;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public void stop() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException exception) {
            BigGlobeMod.LOGGER.error("Unexpected interrupt while stopping " + this.thread.getName() + ": ", (Throwable)exception);
        }
    }

    public void runLoop() {
        BigGlobeMod.LOGGER.info("Big Globe voxy generation thread started.");
        int failures = 0;
        block8: while (true) {
            try {
                while (true) {
                    if (!this.running) {
                        BigGlobeMod.LOGGER.info("Big Globe Voxy worldgen thread shutting down due to voxy core shutting down.");
                        break block8;
                    }
                    if (BigGlobeThreadPool.isBusy()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!this.generateNextChunk()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    failures = 0;
                }
            }
            catch (Exception exception) {
                BigGlobeMod.LOGGER.error("Exception on Big Globe Voxy thread: ", (Throwable)exception);
                if (++failures >= 3) {
                    BigGlobeMod.LOGGER.error("Failed 3 times. Assuming state is corrupt or something and shutting down.");
                    break;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public boolean generateNextChunk() {
        long next = this.queue.nextChunk();
        if (next == -1L) {
            return false;
        }
        this.createChunk(WorldEngine.getX((long)next), WorldEngine.getZ((long)next), WorldEngine.getLevel((long)next));
        return true;
    }

    public abstract void createChunk(int var1, int var2, int var3);

    public void convertSection(int levelX, int levelZ, int level, BlockSegmentList[] lists) {
        int minY = this.generator.height.min_y();
        int maxY = this.generator.height.max_y();
        boolean lightAir = BigGlobeConfig.INSTANCE.get().voxyIntegration.lightAir;
        try (AsyncRunner async = new AsyncRunner(BigGlobeThreadPool.lodExecutor());){
            for (int sectionBottomY = minY & -(1 << level + 5); sectionBottomY < maxY; sectionBottomY += 1 << level + 5) {
                int sectionBottomY_ = sectionBottomY;
                async.submit(() -> {
                    long[] sectionPayload;
                    int levelY = sectionBottomY_ >> level + 5;
                    WorldSection section = lightAir ? this.engine.acquire(level, levelX, levelY, levelZ) : null;
                    long[] lArray = sectionPayload = lightAir ? ((Voxy_WorldSection_DataGetter)section).bigglobe_getData() : null;
                    if (lightAir) {
                        Arrays.fill(sectionPayload, 0L);
                    }
                    class_2680 previousColumnState = null;
                    int previousColumnStateID = -1;
                    try {
                        for (int relativeZ = 0; relativeZ < 32; ++relativeZ) {
                            block4: for (int relativeX = 0; relativeX < 32; ++relativeX) {
                                int packedXZ = relativeZ << 5 | relativeX;
                                BlockSegmentList list = lists[packedXZ];
                                int segmentIndex = list.getSegmentIndex(sectionBottomY_, false);
                                while (segmentIndex < list.size()) {
                                    BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)list.get(segmentIndex++);
                                    if (segment.minY > (sectionBottomY_ | (1 << level + 5) - 1)) continue block4;
                                    if (!lightAir && ((class_2680)segment.value).method_26215()) continue;
                                    if (section == null) {
                                        section = this.engine.acquire(level, levelX, levelY, levelZ);
                                        sectionPayload = ((Voxy_WorldSection_DataGetter)section).bigglobe_getData();
                                        Arrays.fill(sectionPayload, 0L);
                                    }
                                    int minRelativeY = Math.max(segment.minY - sectionBottomY_ >> level, 0);
                                    int maxRelativeY = Math.min(segment.maxY - sectionBottomY_ >> level, 31);
                                    if (segment.value != previousColumnState) {
                                        previousColumnState = (class_2680)segment.value;
                                        previousColumnStateID = previousColumnState.method_26215() ? 0 : this.engine.getMapper().getIdForBlockState(previousColumnState);
                                    }
                                    byte startLightLevel = segment.skylightLevel;
                                    int diminishment = BlockStateVersions.getOpacity(previousColumnState, (class_1922)class_2682.field_12294, class_2338.field_10980);
                                    int blockLightLevel = previousColumnState.method_26213() << 4;
                                    if (startLightLevel == 0 || diminishment == 0) {
                                        long id = Mapper.composeMappingId((byte)((byte)(15 - startLightLevel | blockLightLevel)), (int)previousColumnStateID, (int)this.plainsBiomeId);
                                        for (int relativeY = minRelativeY; relativeY <= maxRelativeY; ++relativeY) {
                                            int index = WorldSection.getIndex((int)relativeX, (int)relativeY, (int)relativeZ);
                                            if (previousColumnStateID == 0 && !Mapper.isAir((long)sectionPayload[index])) continue;
                                            sectionPayload[index] = id;
                                        }
                                        continue;
                                    }
                                    for (int relativeY = minRelativeY; relativeY <= maxRelativeY; ++relativeY) {
                                        int index = WorldSection.getIndex((int)relativeX, (int)relativeY, (int)relativeZ);
                                        if (previousColumnStateID == 0 && !Mapper.isAir((long)sectionPayload[index])) continue;
                                        int absoluteY = (relativeY + 1 << level) - 1 + sectionBottomY_;
                                        int lightLevel = Math.max(startLightLevel - diminishment * (segment.maxY - absoluteY), 0);
                                        sectionPayload[index] = Mapper.composeMappingId((byte)((byte)(15 - lightLevel | blockLightLevel)), (int)previousColumnStateID, (int)this.plainsBiomeId);
                                    }
                                }
                            }
                        }
                        if (section != null) {
                            this.engine.markDirty(section);
                        }
                    }
                    finally {
                        if (section != null) {
                            section.release();
                        }
                    }
                });
            }
        }
    }
}

