/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.datagen;

import builderb0y.bigglobe.blocks.CloudColor;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CloudDataGenerator {
    public static final double TAU = Math.PI * 2;
    public static final int wrap = 4;
    public static final int resolution = 16;
    public static final int frames = 100;
    public static final long SEED = -2186373181646707852L;
    public static final File BASE_PATH = new File("src/main/resources/wip/clouds");

    public static void main(String[] args) throws IOException {
        BASE_PATH.mkdirs();
        for (CloudColor color : CloudColor.VALUES) {
            CloudDataGenerator.generateImage(color, false);
            CloudDataGenerator.generateImage(color, true);
            CloudDataGenerator.writeBlockModel(color.normalName);
            CloudDataGenerator.writeBlockModel(color.voidName);
            CloudDataGenerator.writeItemModel(color.normalName);
            CloudDataGenerator.writeItemModel(color.voidName);
            CloudDataGenerator.writeBlockState(color.normalName);
            CloudDataGenerator.writeBlockState(color.voidName);
            CloudDataGenerator.writeLootTable(color.normalName);
            CloudDataGenerator.writeLootTable(color.voidName);
        }
    }

    public static void generateImage(CloudColor cloudColor, boolean isVoid) throws IOException {
        BufferedImage image = new BufferedImage(16, 1600, 2);
        int[] pixel = new int[1];
        for (int frame = 0; frame < 100; ++frame) {
            int startY = frame * 16;
            double time = (double)frame / 100.0;
            for (int offsetY = 0; offsetY < 16; ++offsetY) {
                for (int offsetX = 0; offsetX < 16; ++offsetX) {
                    pixel[0] = CloudColor.packARGB(CloudDataGenerator.getColor(((double)offsetX + 0.5) * 0.0625, ((double)offsetY + 0.5) * 0.0625, time, isVoid, cloudColor.getColor(time)));
                    image.getRaster().setDataElements(offsetX, startY + offsetY, pixel);
                }
            }
        }
        CloudDataGenerator.writeImage(image, isVoid ? cloudColor.voidName : cloudColor.normalName);
    }

    public static void writeImage(BufferedImage image, String fileName) throws IOException {
        File file = new File(BASE_PATH, "textures" + File.separatorChar + fileName + ".png");
        file.getParentFile().mkdirs();
        ImageIO.write((RenderedImage)image, "png", file);
        try (FileWriter writer = new FileWriter(file.getPath() + ".mcmeta", StandardCharsets.UTF_8);){
            writer.write("{ \"animation\": {} }");
        }
    }

    public static void writeBlockModel(String fileName) throws IOException {
        File file = new File(BASE_PATH, "blockModels" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"parent\": \"minecraft:block/cube_all\",\n\t\"textures\": {\n\t\t\"all\": \"bigglobe:block/%NAME\"\n\t}\n}".replace("%NAME", fileName));
        }
    }

    public static void writeItemModel(String fileName) throws IOException {
        File file = new File(BASE_PATH, "itemModels" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"parent\": \"bigglobe:block/%NAME\"\n}".replace("%NAME", fileName));
        }
    }

    public static void writeBlockState(String fileName) throws IOException {
        File file = new File(BASE_PATH, "blockstates" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"variants\": {\n\t\t\"\": { \"model\": \"bigglobe:block/%NAME\" }\n\t}\n}".replace("%NAME", fileName));
        }
    }

    public static void writeLootTable(String fileName) throws IOException {
        File file = new File(BASE_PATH, "lootTables" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"type\": \"minecraft:block\",\n\t\"pools\": [{\n\t\t\"rolls\": 1,\n\t\t\"entries\": [{\n\t\t\t\"type\": \"minecraft:item\",\n\t\t\t\"name\": \"bigglobe:%NAME\"\n\t\t}],\n\t\t\"conditions\": [{\n\t\t\t\"condition\": \"minecraft:survives_explosion\"\n\t\t}]\n\t}]\n}".replace("%NAME", fileName));
        }
    }

    public static Vector3dc getColor(double uvX, double uvY, double time, boolean isVoid, Vector3dc glowColor) {
        double worley = CloudDataGenerator.worley(uvX * 4.0, uvY * 4.0, time);
        double background = Permuter.toPositiveDouble(Permuter.permute(-2186373181646707852L, BigGlobeMath.floorI(uvX * 16.0), BigGlobeMath.floorI(uvY * 16.0))) * 0.25 + 0.25 / (worley + 0.25);
        double d = background = isVoid ? background * 0.125 : background * 0.5 + 0.375;
        if (glowColor != null) {
            double glow = worley;
            glow *= uvX - uvX * uvX;
            glow *= uvY - uvY * uvY;
            return new Vector3d(background + glowColor.x() * (glow *= 16.0), background + glowColor.y() * glow, background + glowColor.z() * glow);
        }
        return new Vector3d(background);
    }

    public static double worley(double coordX, double coordY, double time) {
        int startX = BigGlobeMath.floorI(coordX);
        int startY = BigGlobeMath.floorI(coordY);
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (int offsetY = -2; offsetY <= 2; ++offsetY) {
            for (int offsetX = -2; offsetX <= 2; ++offsetX) {
                int cellX = startX + offsetX;
                int cellY = startY + offsetY;
                int wrappedX = BigGlobeMath.modulus_BP(cellX, 4);
                int wrappedY = BigGlobeMath.modulus_BP(cellY, 4);
                double centerX = (double)cellX + (Math.sin((time + Permuter.toPositiveDouble(Permuter.permute(-2186373181646707852L, 0, wrappedX, wrappedY))) * (Math.PI * 2)) * 0.5 + 0.5);
                double centerY = (double)cellY + (Math.sin((time + Permuter.toPositiveDouble(Permuter.permute(-2186373181646707852L, 1, wrappedX, wrappedY))) * (Math.PI * 2)) * 0.5 + 0.5);
                nearestDistance = Math.min(nearestDistance, BigGlobeMath.squareD(coordX - centerX, coordY - centerY));
            }
        }
        return nearestDistance;
    }
}

