/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.datagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class MoltenRockDataGenerator {
    public static final File BASE_PATH = new File("src/main/resources/wip/molten_rock");

    public static void main(String[] args) throws IOException {
        for (int heat = 1; heat <= 8; ++heat) {
            String name = "molten_rock_" + (char)(heat + 48);
            MoltenRockDataGenerator.writeBlockState(name);
            MoltenRockDataGenerator.writeBlockModel(name);
            MoltenRockDataGenerator.writeItemModel(name);
            MoltenRockDataGenerator.writeLootTable(name);
        }
    }

    public static void writeBlockModel(String fileName) throws IOException {
        File file = new File(BASE_PATH, "blockModels" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"parent\": \"minecraft:block/cube_all\",\n\t\"textures\": {\n\t\t\"all\": \"bigglobe:block/%NAME\"\n\t}\n}".replace("%NAME", fileName));
        }
    }

    public static void writeItemModel(String fileName) throws IOException {
        File file = new File(BASE_PATH, "itemModels" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"parent\": \"bigglobe:block/%NAME\"\n}".replace("%NAME", fileName));
        }
    }

    public static void writeBlockState(String fileName) throws IOException {
        File file = new File(BASE_PATH, "blockstates" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"variants\": {\n\t\t\"\": { \"model\": \"bigglobe:block/%NAME\" }\n\t}\n}".replace("%NAME", fileName));
        }
    }

    public static void writeLootTable(String fileName) throws IOException {
        File file = new File(BASE_PATH, "lootTables" + File.separatorChar + fileName + ".json");
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write("{\n\t\"type\": \"minecraft:block\"\n}");
        }
    }
}

