/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.autocodec.annotations.VerifyIntRange;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.SectionGenerationContext;
import builderb0y.bigglobe.chunkgen.perSection.PaletteIdReplacer;
import builderb0y.bigglobe.chunkgen.perSection.SectionUtil;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.codecs.BlockStateCoder;
import builderb0y.bigglobe.features.DummyFeature;
import builderb0y.bigglobe.features.RockReplacerFeature;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.Async;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.util.BlockState2ObjectMap;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import com.mojang.serialization.Codec;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_5539;
import net.minecraft.class_6490;

public class ChunkSprinkleFeature
extends DummyFeature<Config>
implements RockReplacerFeature<Config> {
    public ChunkSprinkleFeature(Codec<Config> codec) {
        super(codec);
    }

    public ChunkSprinkleFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    @Override
    public void replaceRocks(BigGlobeScriptedChunkGenerator generator, WorldWrapper worldWrapper, class_2791 chunk, int minSection, int maxSection, Config config) {
        long chunkSeed = Permuter.permute(generator.columnSeed ^ 0x86F84DE15D2E462BL, chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        Async.loop(BigGlobeThreadPool.autoExecutor(), HeightLimitViewVersions.getSectionMinY((class_5539)chunk), HeightLimitViewVersions.getSectionMaxY((class_5539)chunk), 1, yCoord -> {
            class_2826 section = chunk.method_38259(chunk.method_31603(yCoord));
            SectionGenerationContext context = SectionGenerationContext.forSectionCoord(chunk, section, yCoord);
            PaletteIdReplacer replacer = PaletteIdReplacer.of(context, config.blocks);
            if (replacer != null) {
                class_2841 container = section.method_12265();
                class_6490 storage = SectionUtil.storage(container);
                long sectionSeed = Permuter.permute(chunkSeed, yCoord);
                int attempt = config.count;
                while (--attempt >= 0) {
                    int newID;
                    int index = (int)Permuter.permute(sectionSeed, attempt) & 0xFFF;
                    int oldID = storage.method_15211(index);
                    if (oldID == (newID = replacer.getReplacement(oldID))) continue;
                    storage.method_15210(index, newID);
                }
            }
        });
    }

    public static class Config
    extends DummyFeature.DummyConfig {
        public final BlockState2ObjectMap<@BlockStateCoder.VerifyNormal class_2680> blocks;
        public final @VerifyIntRange(min=0L, max=4096L) int count;

        public Config(BlockState2ObjectMap<@BlockStateCoder.VerifyNormal class_2680> blocks, int count) {
            this.blocks = blocks;
            this.count = count;
        }
    }
}

