/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features.dispatch;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.features.RockReplacerFeature;
import builderb0y.bigglobe.features.dispatch.FeatureDispatcher;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.scripting.wrappers.WorldWrapper;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.parsing.ScriptParsingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2975;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureDispatchers
implements ColumnEntryRegistry.DelayedCompileable {
    public final DelayedEntryList<class_2975<?, ?>>[] rock_replacers;
    public transient RockReplacerFeature.ConfiguredRockReplacerFeature<?> @Nullable [] flattenedRockReplacers;
    public final class_6880<FeatureDispatcher> raw;
    public final class_6880<FeatureDispatcher> normal;

    public FeatureDispatchers(DelayedEntryList<class_2975<?, ?>>[] rock_replacers, class_6880<FeatureDispatcher> raw, class_6880<FeatureDispatcher> normal) {
        this.rock_replacers = rock_replacers;
        this.raw = raw;
        this.normal = normal;
    }

    @Override
    public void compile(ColumnEntryRegistry registry) throws ScriptParsingException {
        this.checkCyclicDependencies(this.raw, this.raw, new HashSet<class_6880<FeatureDispatcher>>());
        this.checkCyclicDependencies(this.normal, this.normal, new HashSet<class_6880<FeatureDispatcher>>());
    }

    public void checkCyclicDependencies(class_6880<FeatureDispatcher> root, class_6880<FeatureDispatcher> entry, Set<class_6880<FeatureDispatcher>> seen) {
        if (!seen.add(entry)) {
            throw new IllegalStateException("Feature dispatcher " + String.valueOf(UnregisteredObjectException.getID(entry)) + " generates more than once in root " + String.valueOf(UnregisteredObjectException.getID(root)));
        }
        ((FeatureDispatcher)entry.comp_349()).streamDirectDependencies().filter(dependency -> dependency.comp_349() instanceof FeatureDispatcher).map(e -> e).forEach(e -> this.checkCyclicDependencies(root, (class_6880<FeatureDispatcher>)e, seen));
    }

    public void generateRaw(WorldWrapper world) {
        long chunkSeed = Permuter.permute(world.seed() ^ 0x8938ECF5EEA7B9B2L, FeatureDispatcher.minModifiableX(world) >> 4, FeatureDispatcher.minModifiableY(world) >> 4, FeatureDispatcher.minModifiableZ(world) >> 4);
        ((FeatureDispatcher)this.raw.comp_349()).generate(world, new Permuter(0L), chunkSeed, this.raw);
    }

    public void generateNormal(WorldWrapper world) {
        long chunkSeed = Permuter.permute(world.seed() ^ 0xDD59B178ABC90AC1L, FeatureDispatcher.minModifiableX(world) >> 4, FeatureDispatcher.minModifiableY(world) >> 4, FeatureDispatcher.minModifiableZ(world) >> 4);
        ((FeatureDispatcher)this.normal.comp_349()).generate(world, new Permuter(0L), chunkSeed, this.normal);
    }

    public RockReplacerFeature.ConfiguredRockReplacerFeature<?> @NotNull [] getFlattenedRockReplacers() {
        if (this.flattenedRockReplacers == null) {
            this.flattenedRockReplacers = (RockReplacerFeature.ConfiguredRockReplacerFeature[])Arrays.stream(this.rock_replacers).flatMap(DelayedEntryList::entryStream).filter(entry -> {
                if (((class_2975)entry.comp_349()).comp_332() instanceof RockReplacerFeature) {
                    return true;
                }
                BigGlobeMod.LOGGER.warn("Feature dispatcher specified " + String.valueOf(UnregisteredObjectException.getID(entry)) + " as a rock replacer, but that configured feature is not a rock replacer. It will be ignored.");
                return false;
            }).map(class_6880::comp_349).map(RockReplacerFeature.ConfiguredRockReplacerFeature::new).toArray(RockReplacerFeature.ConfiguredRockReplacerFeature[]::new);
        }
        return this.flattenedRockReplacers;
    }
}

