/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.math;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.scripting.bytecode.CastingSupport;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.ClassType;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.util.TypeInfos;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public class FastPow {
    public static final Int2ObjectMap<CacheEntry> CACHE = new Int2ObjectOpenHashMap(4);
    public static final MethodType INT_METHOD_TYPE = MethodType.methodType(Integer.TYPE, Integer.TYPE);
    public static final MethodType LONG_METHOD_TYPE = MethodType.methodType(Long.TYPE, Long.TYPE);
    public static final MethodType FLOAT_METHOD_TYPE = MethodType.methodType(Float.TYPE, Float.TYPE);
    public static final MethodType DOUBLE_METHOD_TYPE = MethodType.methodType(Double.TYPE, Double.TYPE);
    public static final MethodInfo MATH_POW = MethodInfo.getMethod(Math.class, "pow");
    public static int counter;

    public static FastPowOperator getOperator(int power) {
        return FastPow.getCacheEntry((int)power).operator;
    }

    public static CallSite getCallSite(MethodHandles.Lookup lookup, String name, MethodType methodType, int power) {
        if (methodType == INT_METHOD_TYPE) {
            return FastPow.getCacheEntry((int)power).intCallSite;
        }
        if (methodType == LONG_METHOD_TYPE) {
            return FastPow.getCacheEntry((int)power).longCallSite;
        }
        if (methodType == FLOAT_METHOD_TYPE) {
            return FastPow.getCacheEntry((int)power).floatCallSite;
        }
        if (methodType == DOUBLE_METHOD_TYPE) {
            return FastPow.getCacheEntry((int)power).doubleCallSite;
        }
        throw new WrongMethodTypeException(methodType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheEntry getCacheEntry(int power) {
        Int2ObjectMap<CacheEntry> int2ObjectMap = CACHE;
        synchronized (int2ObjectMap) {
            CacheEntry entry = (CacheEntry)CACHE.get(power);
            if (entry == null) {
                entry = FastPow.createCacheEntry(power);
                CACHE.put(power, (Object)entry);
            }
            return entry;
        }
    }

    public static int pow(int a, int b) {
        if (b > 0) {
            int result = a;
            int bit = Integer.highestOneBit(b);
            while ((bit >>>= 1) != 0) {
                result *= result;
                if ((b & bit) == 0) continue;
                result *= a;
            }
            return result;
        }
        if (b < 0) {
            return (b & 1) == 0 ? FastPow.negativeEven(a) : FastPow.negativeOdd(a);
        }
        return 1;
    }

    public static long pow(long a, int b) {
        if ((long)b > 0L) {
            long result = a;
            int bit = Integer.highestOneBit(b);
            while ((bit >>>= 1) != 0) {
                result *= result;
                if ((b & bit) == 0) continue;
                result *= a;
            }
            return result;
        }
        if ((long)b < 0L) {
            return (b & 1) == 0 ? FastPow.negativeEven(a) : FastPow.negativeOdd(a);
        }
        return 1L;
    }

    public static float pow(float a, int b) {
        boolean negative;
        if (b == 0) {
            return 1.0f;
        }
        boolean bl = negative = b < 0;
        if (negative) {
            b = -b;
        }
        float result = a;
        int bit = Integer.highestOneBit(b);
        while ((bit >>>= 1) != 0) {
            result *= result;
            if ((b & bit) == 0) continue;
            result *= a;
        }
        if (negative) {
            result = 1.0f / result;
        }
        return result;
    }

    public static double pow(double a, int b) {
        boolean negative;
        if (b == 0) {
            return 1.0;
        }
        boolean bl = negative = b < 0;
        if (negative) {
            b = -b;
        }
        double result = a;
        int bit = Integer.highestOneBit(b);
        while ((bit >>>= 1) != 0) {
            result *= result;
            if ((b & bit) == 0) continue;
            result *= a;
        }
        if (negative) {
            result = 1.0 / result;
        }
        return result;
    }

    public static float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static float exp(float x) {
        return (float)Math.exp(x);
    }

    public static int negativeEven(int operand) {
        if (operand == 1) {
            return 1;
        }
        if (operand == 0) {
            throw new ArithmeticException("divide by 0");
        }
        if (operand == -1) {
            return 1;
        }
        return 0;
    }

    public static long negativeEven(long operand) {
        if (operand == 1L) {
            return 1L;
        }
        if (operand == 0L) {
            throw new ArithmeticException("divide by 0");
        }
        if (operand == -1L) {
            return 1L;
        }
        return 0L;
    }

    public static int negativeOdd(int operand) {
        if (operand == 1) {
            return 1;
        }
        if (operand == 0) {
            throw new ArithmeticException("divide by 0");
        }
        if (operand == -1) {
            return -1;
        }
        return 0;
    }

    public static long negativeOdd(long operand) {
        if (operand == 1L) {
            return 1L;
        }
        if (operand == 0L) {
            throw new ArithmeticException("divide by 0");
        }
        if (operand == -1L) {
            return -1L;
        }
        return 0L;
    }

    public static CacheEntry createCacheEntry(int power) {
        assert (Thread.holdsLock(CACHE));
        ClassCompileContext clazz = new ClassCompileContext(4113, ClassType.CLASS, Type.getInternalName(FastPowOperator.class) + "$Generated_" + counter++, TypeInfo.of(FastPowOperator.class), (TypeInfo[])TypeInfo.ARRAY_FACTORY.empty());
        clazz.addNoArgConstructor(1);
        if (power > 0) {
            FastPow.emitPositive(clazz, power);
        } else if (power < 0) {
            FastPow.emitNegative(clazz, power);
        } else {
            FastPow.emitZero(clazz);
        }
        MethodCompileContext getPower = clazz.newMethod(1, "getPower", TypeInfos.INT, new LazyVarInfo[0]);
        InsnTrees.return_(InsnTrees.ldc(power)).emitBytecode(getPower);
        getPower.endCode();
        clazz.addToString("FastPowOperator(" + power + ")");
        return FastPow.defineClass(clazz);
    }

    public static void emitPositive(ClassCompileContext clazz, int power) {
        FastPow.emitMethods(clazz, (intMethod, operand) -> {
            FastPow.emitNormalInstructions(intMethod, operand, power, Integer.MAX_VALUE);
            intMethod.node.visitInsn(operand.type.getOpcode(172));
        }, (floatMethod, operand) -> {
            AbstractInsnNode first = floatMethod.node.instructions.getFirst();
            if (!FastPow.emitNormalInstructions(floatMethod, operand, power, 8)) {
                AbstractInsnNode remove;
                while ((remove = first.getNext()) != null) {
                    floatMethod.node.instructions.remove(remove);
                }
                FastPow.fallback(operand, power).emitBytecode(floatMethod);
            }
            floatMethod.node.visitInsn(operand.type.getOpcode(172));
        });
    }

    public static void emitNegative(ClassCompileContext clazz, int power) {
        FastPow.emitMethods(clazz, (intMethod, operand) -> {
            operand.emitLoad(intMethod);
            intMethod.node.visitMethodInsn(184, Type.getInternalName(FastPow.class), (power & 1) != 0 ? "negativeOdd" : "negativeEven", operand.type.isDoubleWidth() ? "(J)J" : "(I)I", false);
            intMethod.node.visitInsn(operand.type.getOpcode(172));
        }, (floatMethod, operand) -> {
            AbstractInsnNode first = floatMethod.node.instructions.getFirst();
            if (FastPow.emitNormalInstructions(floatMethod, operand, power, 8)) {
                floatMethod.node.instructions.insert(first, (AbstractInsnNode)new InsnNode(operand.type.isDoubleWidth() ? 15 : 12));
                floatMethod.node.instructions.add((AbstractInsnNode)new InsnNode(operand.type.getOpcode(108)));
            } else {
                AbstractInsnNode remove;
                while ((remove = first.getNext()) != null) {
                    floatMethod.node.instructions.remove(remove);
                }
                FastPow.fallback(operand, power).emitBytecode(floatMethod);
            }
            floatMethod.node.visitInsn(operand.type.getOpcode(172));
        });
    }

    public static void emitZero(ClassCompileContext clazz) {
        FastPow.emitMethods(clazz, (method, operand) -> InsnTrees.return_(InsnTrees.ldc(1, operand.type)).emitBytecode(method));
    }

    public static boolean emitNormalInstructions(MethodCompileContext method, LazyVarInfo operand, int power, int limit) {
        method.node.visitVarInsn(operand.type.getOpcode(21), method.scopes.getVariableIndex(operand));
        int bit = Integer.highestOneBit(power);
        while ((bit >>>= 1) != 0) {
            if (--limit < 0) {
                return false;
            }
            method.node.visitInsn(operand.type.isDoubleWidth() ? 92 : 89);
            method.node.visitInsn(operand.type.getOpcode(104));
            if ((power & bit) == 0) continue;
            if (--limit < 0) {
                return false;
            }
            method.node.visitVarInsn(operand.type.getOpcode(21), method.scopes.getVariableIndex(operand));
            method.node.visitInsn(operand.type.getOpcode(104));
        }
        return true;
    }

    public static InsnTree fallback(LazyVarInfo operand, int power) {
        return CastingSupport.primitiveCast(InsnTrees.invokeStatic(MATH_POW, CastingSupport.primitiveCast(InsnTrees.load(operand), TypeInfos.DOUBLE), InsnTrees.ldc(power, TypeInfos.DOUBLE)), operand.type);
    }

    public static void emitMethods(ClassCompileContext clazz, MethodPopulator populator) {
        FastPow.emitMethods(clazz, populator, populator);
    }

    public static void emitMethods(ClassCompileContext clazz, MethodPopulator intConsumer, MethodPopulator floatConsumer) {
        FastPow.emitMethod(clazz, 1, "applyAsInt", TypeInfos.INT, intConsumer);
        FastPow.emitMethod(clazz, 1, "applyAsLong", TypeInfos.LONG, intConsumer);
        FastPow.emitMethod(clazz, 1, "applyAsFloat", TypeInfos.FLOAT, floatConsumer);
        FastPow.emitMethod(clazz, 1, "applyAsDouble", TypeInfos.DOUBLE, floatConsumer);
        FastPow.emitMethod(clazz, 9, "pow", TypeInfos.INT, intConsumer);
        FastPow.emitMethod(clazz, 9, "pow", TypeInfos.LONG, intConsumer);
        FastPow.emitMethod(clazz, 9, "pow", TypeInfos.FLOAT, floatConsumer);
        FastPow.emitMethod(clazz, 9, "pow", TypeInfos.DOUBLE, floatConsumer);
    }

    public static void emitMethod(ClassCompileContext clazz, int flags, String name, TypeInfo type, MethodPopulator populator) {
        LazyVarInfo operand = new LazyVarInfo("operand", type);
        MethodCompileContext method = clazz.newMethod(flags, name, type, operand);
        populator.populate(method, operand);
        method.endCode();
    }

    public static CacheEntry defineClass(ClassCompileContext clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup().defineHiddenClass(clazz.toByteArray(), true, new MethodHandles.Lookup.ClassOption[0]);
            Class<?> operatorClass = lookup.lookupClass();
            return new CacheEntry(lookup, lookup.findConstructor(operatorClass, MethodType.methodType(Void.TYPE)).invoke(), new ConstantCallSite(lookup.findStatic(operatorClass, "pow", MethodType.methodType(Integer.TYPE, Integer.TYPE))), new ConstantCallSite(lookup.findStatic(operatorClass, "pow", MethodType.methodType(Long.TYPE, Long.TYPE))), new ConstantCallSite(lookup.findStatic(operatorClass, "pow", MethodType.methodType(Float.TYPE, Float.TYPE))), new ConstantCallSite(lookup.findStatic(operatorClass, "pow", MethodType.methodType(Double.TYPE, Double.TYPE))));
        }
        catch (Throwable throwable) {
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    public record CacheEntry(MethodHandles.Lookup lookup, FastPowOperator operator, CallSite intCallSite, CallSite longCallSite, CallSite floatCallSite, CallSite doubleCallSite) {
        public Class<? extends FastPowOperator> operatorClass() {
            return this.lookup.lookupClass().asSubclass(FastPowOperator.class);
        }

        public int power() {
            return this.operator.getPower();
        }

        public MethodHandle intHandle() {
            return this.intCallSite.getTarget();
        }

        public MethodHandle longHandle() {
            return this.longCallSite.getTarget();
        }

        public MethodHandle floatHandle() {
            return this.floatCallSite.getTarget();
        }

        public MethodHandle doubleHandle() {
            return this.doubleCallSite.getTarget();
        }
    }

    public static abstract class FastPowOperator
    implements IntUnaryOperator,
    LongUnaryOperator,
    DoubleUnaryOperator {
        @Override
        public abstract int applyAsInt(int var1);

        @Override
        public abstract long applyAsLong(long var1);

        public abstract float applyAsFloat(float var1);

        @Override
        public abstract double applyAsDouble(double var1);

        public abstract int getPower();
    }

    public static interface MethodPopulator {
        public void populate(MethodCompileContext var1, LazyVarInfo var2);
    }
}

