/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.networking.base;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.networking.base.C2SPlayPacketHandler;
import builderb0y.bigglobe.networking.base.PacketHandler;
import builderb0y.bigglobe.networking.base.S2CPlayPacketHandler;
import builderb0y.bigglobe.networking.packets.DangerousRapidsPacket;
import builderb0y.bigglobe.networking.packets.SettingsSyncS2CPacketHandler;
import builderb0y.bigglobe.networking.packets.TimeSpeedS2CPacketHandler;
import builderb0y.bigglobe.networking.packets.UseWaypointPacket;
import builderb0y.bigglobe.networking.packets.WaypointAddS2CPacket;
import builderb0y.bigglobe.networking.packets.WaypointListS2CPacket;
import builderb0y.bigglobe.networking.packets.WaypointRemoveC2SPacket;
import builderb0y.bigglobe.networking.packets.WaypointRemoveS2CPacket;
import builderb0y.bigglobe.networking.packets.WaypointRenameC2SPacket;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnvironmentInterface(value=EnvType.CLIENT, itf=ClientPlayNetworking.PlayChannelHandler.class)
public class BigGlobeNetwork
implements ClientPlayNetworking.PlayChannelHandler,
ServerPlayNetworking.PlayChannelHandler {
    public static final class_2960 NETWORK_ID = BigGlobeMod.modID("network");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Big Globe/Network");
    public static final BigGlobeNetwork INSTANCE = new BigGlobeNetwork();
    public final List<PacketHandler> idToHandler = new ArrayList<PacketHandler>(16);
    public final Object2ByteMap<PacketHandler> handlerToId = new Object2ByteOpenHashMap(2);

    public BigGlobeNetwork() {
        this.handlerToId.defaultReturnValue((byte)-1);
        this.register(SettingsSyncS2CPacketHandler.INSTANCE);
        this.register(TimeSpeedS2CPacketHandler.INSTANCE);
        this.register(DangerousRapidsPacket.INSTANCE);
        this.register(WaypointListS2CPacket.INSTANCE);
        this.register(WaypointAddS2CPacket.INSTANCE);
        this.register(WaypointRemoveS2CPacket.INSTANCE);
        this.register(UseWaypointPacket.INSTANCE);
        this.register(WaypointRenameC2SPacket.INSTANCE);
        this.register(WaypointRemoveC2SPacket.INSTANCE);
    }

    public byte nextId() {
        int id = this.idToHandler.size();
        if (id < 255) {
            return (byte)id;
        }
        throw new IllegalStateException("Too many packet handlers registered on " + String.valueOf(this));
    }

    public void register(PacketHandler handler) {
        byte id = this.nextId();
        this.idToHandler.add(handler);
        this.handlerToId.put((Object)handler, id);
    }

    public byte getId(PacketHandler handler) {
        byte id = this.handlerToId.getByte((Object)handler);
        if (id != -1) {
            return id;
        }
        throw new IllegalStateException(String.valueOf(handler) + " not registered on " + String.valueOf(this));
    }

    @Nullable
    public PacketHandler getHandler(byte id) {
        int unsignedId = Byte.toUnsignedInt(id);
        if (unsignedId < this.idToHandler.size()) {
            return this.idToHandler.get(unsignedId);
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void receive(class_310 client, class_634 networkHandler, class_2540 buffer, PacketSender responseSender) {
        byte id = buffer.readByte();
        PacketHandler packetHandler = this.getHandler(id);
        if (packetHandler instanceof S2CPlayPacketHandler) {
            S2CPlayPacketHandler packetHandler2 = (S2CPlayPacketHandler)packetHandler;
            this.doReceive(client, buffer, responseSender, packetHandler2);
        } else {
            LOGGER.warn("No server to client play packet handler registered for ID " + Byte.toUnsignedInt(id));
        }
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 networkHandler, class_2540 buffer, PacketSender responseSender) {
        byte id = buffer.readByte();
        PacketHandler packetHandler = this.getHandler(id);
        if (packetHandler instanceof C2SPlayPacketHandler) {
            C2SPlayPacketHandler packetHandler2 = (C2SPlayPacketHandler)packetHandler;
            this.doReceive(server, player, buffer, responseSender, packetHandler2);
        } else {
            LOGGER.warn("No client to server play packet handler registered for ID " + Byte.toUnsignedInt(id));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public <T> void doReceive(class_310 client, class_2540 buffer, PacketSender responseSender, S2CPlayPacketHandler<T> handler) {
        Object data = handler.decode(buffer);
        client.method_40000(() -> handler.process(data, responseSender));
    }

    public <T> void doReceive(MinecraftServer server, class_3222 player, class_2540 buffer, PacketSender responseSender, C2SPlayPacketHandler<T> handler) {
        Object data = handler.decode(player, buffer);
        server.method_40000(() -> handler.process(player, data, responseSender));
    }

    public void sendToPlayer(class_3222 player, class_2540 buffer) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)NETWORK_ID, (class_2540)buffer);
    }

    public void sendToServer(class_2540 buffer) {
        ClientPlayNetworking.send((class_2960)NETWORK_ID, (class_2540)buffer);
    }

    public static void init() {
        LOGGER.debug("Initializing common network...");
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NETWORK_ID, (ServerPlayNetworking.PlayChannelHandler)INSTANCE);
        LOGGER.debug("Done initializing common network.");
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        LOGGER.debug("Initializing client network...");
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NETWORK_ID, (ClientPlayNetworking.PlayChannelHandler)INSTANCE);
        LOGGER.debug("Done initializing client network.");
    }
}

