/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.networking.packets;

import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.PackedWorldPos;
import builderb0y.bigglobe.hyperspace.PlayerWaypointData;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.SyncedWaypointData;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.networking.base.S2CPlayPacketHandler;
import builderb0y.bigglobe.util.NbtIo2;
import builderb0y.bigglobe.util.TextCoding;
import builderb0y.bigglobe.versions.EntityVersions;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class WaypointListS2CPacket
implements S2CPlayPacketHandler<List<SyncedWaypointData>> {
    public static final WaypointListS2CPacket INSTANCE = new WaypointListS2CPacket();
    public static final int OWNED_BY_RECIPIENT = 1;
    public static final int HAS_NAME = 2;

    public void send(class_3222 player) {
        PlayerWaypointManager manager = PlayerWaypointManager.get((class_1657)player);
        if (manager == null) {
            return;
        }
        class_2540 buffer = this.buffer();
        boolean isHyperspace = EntityVersions.getWorld((class_1297)player).method_27983() == HyperspaceConstants.WORLD_KEY;
        buffer.method_52964(isHyperspace);
        Object2IntLinkedOpenHashMap worlds = new Object2IntLinkedOpenHashMap(4);
        worlds.defaultReturnValue(-1);
        worlds.put(HyperspaceConstants.WORLD_KEY, 0);
        ToIntFunction<class_5321> computer = arg_0 -> WaypointListS2CPacket.lambda$send$0((Object2IntMap)worlds, arg_0);
        int waypointCount = 0;
        for (PlayerWaypointData data : manager.getAllWaypoints()) {
            worlds.computeIfAbsent(data.destination().pos().world(), computer);
            ++waypointCount;
        }
        buffer.method_10804(worlds.size());
        for (Object2IntMap.Entry entry : worlds.object2IntEntrySet()) {
            buffer.method_44116((class_5321)entry.getKey());
        }
        buffer.method_10804(waypointCount);
        for (PlayerWaypointData waypoint : manager.getAllWaypoints()) {
            class_2561 name;
            class_2520 nbtName;
            int flags = 0;
            if (waypoint.owner() != null) {
                flags |= 1;
            }
            if ((nbtName = TextCoding.toNbt(name = waypoint.destination().name())) != null) {
                flags |= 2;
            }
            buffer.method_52997(flags);
            buffer.method_10804(waypoint.id());
            buffer.method_10804(waypoint.destination().entityId());
            waypoint.destinationPosition().writeBulk(buffer, (Object2IntMap<class_5321<class_1937>>)worlds);
            if (isHyperspace) {
                waypoint.displayPosition().writePositionOnly(buffer);
            }
            if (nbtName == null) continue;
            NbtIo2.write((ByteBuf)buffer, nbtName);
        }
        BigGlobeNetwork.INSTANCE.sendToPlayer(player, buffer);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<SyncedWaypointData> decode(class_2540 buffer) {
        boolean isHyperspace = buffer.readBoolean();
        int worldCount = buffer.method_10816();
        ArrayList<class_5321<class_1937>> worlds = new ArrayList<class_5321<class_1937>>(worldCount);
        for (int worldIndex = 0; worldIndex < worldCount; ++worldIndex) {
            worlds.add(buffer.method_44112(class_7924.field_41223));
        }
        int waypointCount = buffer.method_10816();
        ArrayList<SyncedWaypointData> waypoints = new ArrayList<SyncedWaypointData>(waypointCount);
        for (int waypointIndex = 0; waypointIndex < waypointCount; ++waypointIndex) {
            byte flags = buffer.readByte();
            boolean owned = (flags & 1) != 0;
            boolean hasName = (flags & 2) != 0;
            int id = buffer.method_10816();
            int entityID = buffer.method_10816();
            PackedWorldPos destination = PackedWorldPos.readBulk(buffer, worlds);
            PackedWorldPos displayPosition = isHyperspace ? PackedWorldPos.readPositionOnly(buffer, HyperspaceConstants.WORLD_KEY) : destination;
            class_2561 name = hasName ? TextCoding.read(buffer) : null;
            waypoints.add(new SyncedWaypointData(id, entityID, owned, destination, displayPosition, name));
        }
        return waypoints;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void process(List<SyncedWaypointData> waypoints, PacketSender responseSender) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            EntityVersions.setPortalCooldown((class_1297)player, 20);
            PlayerWaypointManager manager = PlayerWaypointManager.get((class_1657)player);
            if (manager != null) {
                manager.clear();
                for (SyncedWaypointData waypoint : waypoints) {
                    manager.addWaypoint(waypoint.resolve((class_1657)player), true);
                }
            }
        }
    }

    private static /* synthetic */ int lambda$send$0(Object2IntMap worlds, class_5321 $) {
        return worlds.size();
    }
}

