/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.networking.packets;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.PlayerWaypointData;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.ServerWaypointManager;
import builderb0y.bigglobe.items.BigGlobeItems;
import builderb0y.bigglobe.items.WaypointItem;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.networking.base.C2SPlayPacketHandler;
import builderb0y.bigglobe.versions.EntityVersions;
import builderb0y.bigglobe.versions.ItemStackVersions;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class WaypointRemoveC2SPacket
implements C2SPlayPacketHandler<Integer> {
    public static final WaypointRemoveC2SPacket INSTANCE = new WaypointRemoveC2SPacket();

    public void send(int id) {
        class_2540 buffer = this.buffer();
        buffer.method_10804(id);
        BigGlobeNetwork.INSTANCE.sendToServer(buffer);
    }

    @Override
    public Integer decode(class_3222 player, class_2540 buffer) {
        return buffer.method_10816();
    }

    @Override
    public void process(class_3222 player, Integer id, PacketSender responseSender) {
        if (!player.method_7325()) {
            ServerWaypointManager serverManager = ServerWaypointManager.get(EntityVersions.getServerWorld(player));
            if (serverManager != null) {
                PlayerWaypointManager serverPlayerManager = PlayerWaypointManager.get((class_1657)player);
                if (serverPlayerManager != null) {
                    PlayerWaypointData waypoint = (PlayerWaypointData)serverPlayerManager.getWaypoint(id);
                    if (waypoint != null) {
                        if (player.method_33571().method_1028(waypoint.displayPosition().x(), waypoint.displayPosition().y(), waypoint.displayPosition().z()) <= EntityVersions.getEntityReachDistanceSquared((class_1657)player)) {
                            WaypointItem drop;
                            serverManager.removeWaypoint(id, true);
                            WaypointItem waypointItem = drop = waypoint.owner() != null ? BigGlobeItems.PRIVATE_WAYPOINT : BigGlobeItems.PUBLIC_WAYPOINT;
                            if (drop != null && EntityVersions.getServerWorld(player).method_8450().method_8355(class_1928.field_19393)) {
                                class_1799 stack = new class_1799((class_1935)drop);
                                if (waypoint.destination().name() != null) {
                                    ItemStackVersions.setCustomName(stack, waypoint.destination().name());
                                }
                                class_1542 entity = new class_1542(EntityVersions.getWorld((class_1297)player), waypoint.displayPosition().x(), waypoint.displayPosition().y(), waypoint.displayPosition().z(), stack);
                                if (EntityVersions.getWorld((class_1297)player).method_27983() == HyperspaceConstants.WORLD_KEY) {
                                    entity.method_5875(true);
                                }
                                EntityVersions.getWorld((class_1297)player).method_8649((class_1297)entity);
                            }
                        } else {
                            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to destroy a waypoint without being near it: " + String.valueOf(waypoint));
                        }
                    } else {
                        BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to destroy a non-existent waypoint with ID " + id);
                    }
                } else {
                    BigGlobeMod.LOGGER.warn(String.valueOf(player) + " has no waypoint manager?");
                }
            } else {
                BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to destroy a waypoint while hyperspace is disabled.");
            }
        } else {
            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to destroy a waypoint while in spectator mode.");
        }
    }
}

