/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.util.InfoHolder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;

public class NumberArray
implements AutoCloseable {
    public static final boolean TRACE_ALLOCATIONS = Boolean.getBoolean("bigglobe.traceNumberArrayAllocations");
    public static final boolean CHECK_TYPE = Boolean.getBoolean("bigglobe.checkNumberArrayType");
    public static final byte BYTE_TYPE = 0;
    public static final byte SHORT_TYPE = 1;
    public static final byte INT_TYPE = 2;
    public static final byte LONG_TYPE = 3;
    public static final byte FLOAT_TYPE = 4;
    public static final byte DOUBLE_TYPE = 5;
    public static final byte BOOLEAN_TYPE = 6;
    public static final int BYTE_SHIFT = 0;
    public static final int SHORT_SHIFT = 1;
    public static final int INT_SHIFT = 2;
    public static final int LONG_SHIFT = 3;
    public static final int FLOAT_SHIFT = 2;
    public static final int DOUBLE_SHIFT = 3;
    public static final VarHandle BYTE_ACCESS = MethodHandles.arrayElementVarHandle(byte[].class).withInvokeExactBehavior();
    public static final VarHandle SHORT_ACCESS = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    public static final VarHandle INT_ACCESS = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    public static final VarHandle LONG_ACCESS = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    public static final VarHandle FLOAT_ACCESS = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    public static final VarHandle DOUBLE_ACCESS = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    public static final Info INFO = new Info();
    public static final NumberArray EMPTY_BYTE = new NumberArray(0);
    public static final NumberArray EMPTY_SHORT = new NumberArray(1);
    public static final NumberArray EMPTY_INT = new NumberArray(2);
    public static final NumberArray EMPTY_LONG = new NumberArray(3);
    public static final NumberArray EMPTY_FLOAT = new NumberArray(4);
    public static final NumberArray EMPTY_DOUBLE = new NumberArray(5);
    public static final NumberArray EMPTY_BOOLEAN = new NumberArray(6);
    public final byte type;
    public Manager manager;
    public final int byteOffset;
    public final int byteLength;
    public final int elementOffset;
    public final int elementCount;
    public final boolean freeable;
    public final Throwable allocator;
    public Throwable closing;

    public NumberArray(byte type) {
        this.type = type;
        this.elementCount = 0;
        this.elementOffset = 0;
        this.byteLength = 0;
        this.byteOffset = 0;
        this.freeable = false;
        this.allocator = null;
    }

    public NumberArray(byte type, Manager manager, int byteOffset, int byteLength, int elementOffset, int elementCount, boolean freeable) {
        if (manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if ((byteLength & 7) != 0) {
            throw new IllegalArgumentException("Invalid alignment for length " + byteLength);
        }
        if (freeable && manager.used + byteLength > manager.base.length) {
            throw new IllegalArgumentException("Manager has insufficient capacity for " + byteLength + " byte(s): " + String.valueOf(manager));
        }
        if (byteLength < 0) {
            throw new IllegalArgumentException("byteLength < 0: " + byteLength);
        }
        if (elementCount < 0) {
            throw new IllegalArgumentException("elementCount < 0: " + elementCount);
        }
        this.type = type;
        this.manager = manager;
        this.byteOffset = byteOffset;
        this.byteLength = byteLength;
        this.elementOffset = elementOffset;
        this.elementCount = elementCount;
        this.freeable = freeable;
        Throwable throwable = this.allocator = TRACE_ALLOCATIONS && freeable ? new Throwable("Allocation site:") : null;
        if (freeable) {
            manager.used += byteLength;
        }
    }

    public static NumberArray allocateBytesHeap(int bytes) {
        return new Manager(bytes << 0).allocateBytesHeap();
    }

    public static NumberArray allocateShortsHeap(int shorts) {
        return new Manager(shorts << 1).allocateShortsHeap();
    }

    public static NumberArray allocateIntsHeap(int ints) {
        return new Manager(ints << 2).allocateIntsHeap();
    }

    public static NumberArray allocateLongsHeap(int longs) {
        return new Manager(longs << 3).allocateLongsHeap();
    }

    public static NumberArray allocateFloatsHeap(int floats) {
        return new Manager(floats << 2).allocateFloatsHeap();
    }

    public static NumberArray allocateDoublesHeap(int doubles) {
        return new Manager(doubles << 3).allocateDoublesHeap();
    }

    public static NumberArray allocateBooleansHeap(int booleans) {
        return new Manager((booleans - 1 >> 3) + 1).allocateBooleansHeap(booleans);
    }

    public static NumberArray allocateBytesDirect(int bytes) {
        return Manager.INSTANCES.get().allocateBytesDirect(bytes);
    }

    public static NumberArray allocateShortsDirect(int shorts) {
        return Manager.INSTANCES.get().allocateShortsDirect(shorts);
    }

    public static NumberArray allocateIntsDirect(int ints) {
        return Manager.INSTANCES.get().allocateIntsDirect(ints);
    }

    public static NumberArray allocateLongsDirect(int longs) {
        return Manager.INSTANCES.get().allocateLongsDirect(longs);
    }

    public static NumberArray allocateFloatsDirect(int floats) {
        return Manager.INSTANCES.get().allocateFloatsDirect(floats);
    }

    public static NumberArray allocateDoublesDirect(int doubles) {
        return Manager.INSTANCES.get().allocateDoublesDirect(doubles);
    }

    public static NumberArray allocateBooleansDirect(int booleans) {
        return Manager.INSTANCES.get().allocateBooleansDirect(booleans);
    }

    public static NumberArray allocateBytesDirectZero(int bytes) {
        NumberArray array = NumberArray.allocateBytesDirect(bytes);
        array.implFillFromTo(0, bytes, (byte)0);
        return array;
    }

    public static NumberArray allocateShortsDirectZero(int shorts) {
        NumberArray array = NumberArray.allocateShortsDirect(shorts);
        array.implFillFromTo(0, shorts, (short)0);
        return array;
    }

    public static NumberArray allocateIntsDirectZero(int ints) {
        NumberArray array = NumberArray.allocateIntsDirect(ints);
        array.implFillFromTo(0, ints, 0);
        return array;
    }

    public static NumberArray allocateLongsDirectZero(int longs) {
        NumberArray array = NumberArray.allocateLongsDirect(longs);
        array.implFillFromTo(0, longs, 0L);
        return array;
    }

    public static NumberArray allocateFloatsDirectZero(int floats) {
        NumberArray array = NumberArray.allocateFloatsDirect(floats);
        array.implFillFromTo(0, floats, 0.0f);
        return array;
    }

    public static NumberArray allocateDoublesDirectZero(int doubles) {
        NumberArray array = NumberArray.allocateDoublesDirect(doubles);
        array.implFillFromTo(0, doubles, 0.0);
        return array;
    }

    public static NumberArray allocateBooleansDirectZero(int booleans) {
        NumberArray array = NumberArray.allocateBooleansDirect(booleans);
        array.implFillFromTo(0, booleans, false);
        return array;
    }

    public byte[] getBase() {
        try {
            return this.manager.base;
        }
        catch (NullPointerException exception) {
            throw new IllegalStateException("NumberArray already closed!", this.closing);
        }
    }

    public int byteIndexUnchecked(int index) {
        return (index + this.elementOffset << 0) + this.byteOffset;
    }

    public int shortIndexUnchecked(int index) {
        return (index + this.elementOffset << 1) + this.byteOffset;
    }

    public int intIndexUnchecked(int index) {
        return (index + this.elementOffset << 2) + this.byteOffset;
    }

    public int longIndexUnchecked(int index) {
        return (index + this.elementOffset << 3) + this.byteOffset;
    }

    public int floatIndexUnchecked(int index) {
        return (index + this.elementOffset << 2) + this.byteOffset;
    }

    public int doubleIndexUnchecked(int index) {
        return (index + this.elementOffset << 3) + this.byteOffset;
    }

    public int byteIndex(int index) {
        return this.byteIndexUnchecked(this.checkTypeIndex(0, index));
    }

    public int shortIndex(int index) {
        return this.shortIndexUnchecked(this.checkTypeIndex(1, index));
    }

    public int intIndex(int index) {
        return this.intIndexUnchecked(this.checkTypeIndex(2, index));
    }

    public int longIndex(int index) {
        return this.longIndexUnchecked(this.checkTypeIndex(3, index));
    }

    public int floatIndex(int index) {
        return this.floatIndexUnchecked(this.checkTypeIndex(4, index));
    }

    public int doubleIndex(int index) {
        return this.doubleIndexUnchecked(this.checkTypeIndex(5, index));
    }

    public int checkIndex(int index) {
        return Objects.checkIndex(index, this.elementCount);
    }

    public int checkRange(int from, int to) {
        return Objects.checkFromToIndex(from, to, this.elementCount);
    }

    public int checkTypeIndex(int type, int index) {
        this.checkType(type);
        return this.checkIndex(index);
    }

    public int checkTypeRange(int type, int from, int to) {
        this.checkType(type);
        return this.checkRange(from, to);
    }

    public void checkType(int type) {
        if (CHECK_TYPE && this.type != type) {
            throw new IllegalStateException("Incorrect type: expected " + NumberArray.typeName(type) + ", got " + NumberArray.typeName(this.type));
        }
    }

    public static String typeName(int type) {
        return switch (type) {
            case 0 -> "byte";
            case 1 -> "short";
            case 2 -> "int";
            case 3 -> "long";
            case 4 -> "float";
            case 5 -> "double";
            case 6 -> "boolean";
            default -> "unknown (" + type + ")";
        };
    }

    public byte implGetB(int index) {
        return BYTE_ACCESS.get(this.getBase(), this.byteIndex(index));
    }

    public short implGetS(int index) {
        return SHORT_ACCESS.get(this.getBase(), this.shortIndex(index));
    }

    public int implGetI(int index) {
        return INT_ACCESS.get(this.getBase(), this.intIndex(index));
    }

    public long implGetL(int index) {
        return LONG_ACCESS.get(this.getBase(), this.longIndex(index));
    }

    public float implGetF(int index) {
        return FLOAT_ACCESS.get(this.getBase(), this.floatIndex(index));
    }

    public double implGetD(int index) {
        return DOUBLE_ACCESS.get(this.getBase(), this.doubleIndex(index));
    }

    public boolean implGetZ(int index) {
        index = this.checkTypeIndex(6, index) + this.elementOffset;
        return (this.getBase()[(index >>> 3) + this.byteOffset] >>> (index & 7) & 1) != 0;
    }

    public byte getB(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> (byte)this.implGetS(index);
            case 2 -> (byte)this.implGetI(index);
            case 3 -> (byte)this.implGetL(index);
            case 4 -> (byte)this.implGetF(index);
            case 5 -> (byte)this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public short getS(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> this.implGetS(index);
            case 2 -> (short)this.implGetI(index);
            case 3 -> (short)this.implGetL(index);
            case 4 -> (short)this.implGetF(index);
            case 5 -> (short)this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public int getI(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> this.implGetS(index);
            case 2 -> this.implGetI(index);
            case 3 -> (int)this.implGetL(index);
            case 4 -> (int)this.implGetF(index);
            case 5 -> (int)this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public long getL(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> this.implGetS(index);
            case 2 -> this.implGetI(index);
            case 3 -> this.implGetL(index);
            case 4 -> (long)this.implGetF(index);
            case 5 -> (long)this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1L;
                }
                yield 0L;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public float getF(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> this.implGetS(index);
            case 2 -> this.implGetI(index);
            case 3 -> this.implGetL(index);
            case 4 -> this.implGetF(index);
            case 5 -> (float)this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public double getD(int index) {
        return switch (this.type) {
            case 0 -> this.implGetB(index);
            case 1 -> this.implGetS(index);
            case 2 -> this.implGetI(index);
            case 3 -> this.implGetL(index);
            case 4 -> this.implGetF(index);
            case 5 -> this.implGetD(index);
            case 6 -> {
                if (this.implGetZ(index)) {
                    yield 1.0;
                }
                yield 0.0;
            }
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public boolean getZ(int index) {
        return switch (this.type) {
            case 0 -> {
                if (this.implGetB(index) != 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (this.implGetS(index) != 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.implGetI(index) != 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.implGetL(index) != 0L) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (this.implGetF(index) != 0.0f) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (this.implGetD(index) != 0.0) {
                    yield true;
                }
                yield false;
            }
            case 6 -> this.implGetZ(index);
            default -> throw new IllegalStateException("Invalid type: " + this.type);
        };
    }

    public void implSetB(int index, byte value) {
        BYTE_ACCESS.set(this.getBase(), this.byteIndex(index), value);
    }

    public void implSetS(int index, short value) {
        SHORT_ACCESS.set(this.getBase(), this.shortIndex(index), value);
    }

    public void implSetI(int index, int value) {
        INT_ACCESS.set(this.getBase(), this.intIndex(index), value);
    }

    public void implSetL(int index, long value) {
        LONG_ACCESS.set(this.getBase(), this.longIndex(index), value);
    }

    public void implSetF(int index, float value) {
        FLOAT_ACCESS.set(this.getBase(), this.floatIndex(index), value);
    }

    public void implSetD(int index, double value) {
        DOUBLE_ACCESS.set(this.getBase(), this.doubleIndex(index), value);
    }

    public void implSetZ(int index, boolean value) {
        index = this.checkTypeIndex(6, index) + this.elementOffset;
        if (value) {
            byte[] byArray = this.getBase();
            int n = (index >>> 3) + this.byteOffset;
            byArray[n] = (byte)(byArray[n] | 1 << (index & 7));
        } else {
            byte[] byArray = this.getBase();
            int n = (index >>> 3) + this.byteOffset;
            byArray[n] = (byte)(byArray[n] & ~(1 << (index & 7)));
        }
    }

    public void setB(int index, byte value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, value);
                break;
            }
            case 1: {
                this.implSetS(index, value);
                break;
            }
            case 2: {
                this.implSetI(index, value);
                break;
            }
            case 3: {
                this.implSetL(index, value);
                break;
            }
            case 4: {
                this.implSetF(index, value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setS(int index, short value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, (byte)value);
                break;
            }
            case 1: {
                this.implSetS(index, value);
                break;
            }
            case 2: {
                this.implSetI(index, value);
                break;
            }
            case 3: {
                this.implSetL(index, value);
                break;
            }
            case 4: {
                this.implSetF(index, value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setI(int index, int value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, (byte)value);
                break;
            }
            case 1: {
                this.implSetS(index, (short)value);
                break;
            }
            case 2: {
                this.implSetI(index, value);
                break;
            }
            case 3: {
                this.implSetL(index, value);
                break;
            }
            case 4: {
                this.implSetF(index, value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setL(int index, long value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, (byte)value);
                break;
            }
            case 1: {
                this.implSetS(index, (short)value);
                break;
            }
            case 2: {
                this.implSetI(index, (int)value);
                break;
            }
            case 3: {
                this.implSetL(index, value);
                break;
            }
            case 4: {
                this.implSetF(index, value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0L);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setF(int index, float value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, (byte)value);
                break;
            }
            case 1: {
                this.implSetS(index, (short)value);
                break;
            }
            case 2: {
                this.implSetI(index, (int)value);
                break;
            }
            case 3: {
                this.implSetL(index, (long)value);
                break;
            }
            case 4: {
                this.implSetF(index, value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setD(int index, double value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, (byte)value);
                break;
            }
            case 1: {
                this.implSetS(index, (short)value);
                break;
            }
            case 2: {
                this.implSetI(index, (int)value);
                break;
            }
            case 3: {
                this.implSetL(index, (long)value);
                break;
            }
            case 4: {
                this.implSetF(index, (float)value);
                break;
            }
            case 5: {
                this.implSetD(index, value);
                break;
            }
            case 6: {
                this.implSetZ(index, value != 0.0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void setZ(int index, boolean value) {
        switch (this.type) {
            case 0: {
                this.implSetB(index, value ? (byte)1 : 0);
                break;
            }
            case 1: {
                this.implSetS(index, value ? (short)1 : 0);
                break;
            }
            case 2: {
                this.implSetI(index, value ? 1 : 0);
                break;
            }
            case 3: {
                this.implSetL(index, value ? 1L : 0L);
                break;
            }
            case 4: {
                this.implSetF(index, value ? 1.0f : 0.0f);
                break;
            }
            case 5: {
                this.implSetD(index, value ? 1.0 : 0.0);
                break;
            }
            case 6: {
                this.implSetZ(index, value);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void implFillFromTo(int from, int to, byte value) {
        byte[] base = this.getBase();
        this.checkTypeRange(0, from, to);
        if (from == to) {
            return;
        }
        from = this.byteIndexUnchecked(from);
        to = this.byteIndexUnchecked(to);
        for (int index = from; index < to; ++index) {
            BYTE_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, short value) {
        byte[] base = this.getBase();
        this.checkTypeRange(1, from, to);
        if (from == to) {
            return;
        }
        from = this.shortIndexUnchecked(from);
        to = this.shortIndexUnchecked(to);
        for (int index = from; index < to; index += 2) {
            SHORT_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, int value) {
        byte[] base = this.getBase();
        this.checkTypeRange(2, from, to);
        if (from == to) {
            return;
        }
        from = this.intIndexUnchecked(from);
        to = this.intIndexUnchecked(to);
        for (int index = from; index < to; index += 4) {
            INT_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, long value) {
        byte[] base = this.getBase();
        this.checkTypeRange(3, from, to);
        if (from == to) {
            return;
        }
        from = this.longIndexUnchecked(from);
        to = this.longIndexUnchecked(to);
        for (int index = from; index < to; index += 8) {
            LONG_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, float value) {
        byte[] base = this.getBase();
        this.checkTypeRange(4, from, to);
        if (from == to) {
            return;
        }
        from = this.floatIndexUnchecked(from);
        to = this.floatIndexUnchecked(to);
        for (int index = from; index < to; index += 4) {
            FLOAT_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, double value) {
        byte[] base = this.getBase();
        this.checkTypeRange(5, from, to);
        if (from == to) {
            return;
        }
        from = this.doubleIndexUnchecked(from);
        to = this.doubleIndexUnchecked(to);
        for (int index = from; index < to; index += 8) {
            DOUBLE_ACCESS.set(base, index, value);
        }
    }

    public void implFillFromTo(int from, int to, boolean value) {
        byte[] base = this.getBase();
        this.checkTypeRange(6, from, to);
        if (from == to) {
            return;
        }
        int firstByteIndex = ((from += this.elementOffset) >>> 3) + this.byteOffset;
        int lastByteIndex = ((to += this.elementOffset) - 1 >>> 3) + this.byteOffset;
        byte firstByteMask = (byte)(255 << (from & 7));
        byte lastByteMask = (byte)(255 >>> (-to & 7));
        if (value) {
            if (firstByteIndex == lastByteIndex) {
                int n = firstByteIndex;
                base[n] = (byte)(base[n] | (byte)(firstByteMask & lastByteMask));
            } else {
                int n = firstByteIndex;
                base[n] = (byte)(base[n] | firstByteMask);
                int index = firstByteIndex;
                while (++index < lastByteIndex) {
                    base[index] = -1;
                }
                int n2 = lastByteIndex;
                base[n2] = (byte)(base[n2] | lastByteMask);
            }
        } else if (firstByteIndex == lastByteIndex) {
            int n = firstByteIndex;
            base[n] = (byte)(base[n] & (byte)(~(firstByteMask & lastByteMask)));
        } else {
            int n = firstByteIndex;
            base[n] = (byte)(base[n] & (byte)(~firstByteMask));
            int index = firstByteIndex;
            while (++index < lastByteIndex) {
                base[index] = 0;
            }
            int n3 = lastByteIndex;
            base[n3] = (byte)(base[n3] & (byte)(~lastByteMask));
        }
    }

    public void fillB(byte value) {
        this.fillFromToB(0, this.elementCount, value);
    }

    public void fillS(short value) {
        this.fillFromToS(0, this.elementCount, value);
    }

    public void fillI(int value) {
        this.fillFromToI(0, this.elementCount, value);
    }

    public void fillL(long value) {
        this.fillFromToL(0, this.elementCount, value);
    }

    public void fillF(float value) {
        this.fillFromToF(0, this.elementCount, value);
    }

    public void fillD(double value) {
        this.fillFromToD(0, this.elementCount, value);
    }

    public void fillZ(boolean value) {
        this.fillFromToZ(0, this.elementCount, value);
    }

    public void fillFromToB(int from, int to, byte value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, (short)value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, (int)value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, (long)value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, (float)value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, (double)value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToS(int from, int to, short value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, (byte)value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, (int)value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, (long)value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, (float)value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, (double)value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToI(int from, int to, int value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, (byte)value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, (short)value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, (long)value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, (float)value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, (double)value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToL(int from, int to, long value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, (byte)value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, (short)value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, (int)value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, (float)value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, (double)value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0L);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToF(int from, int to, float value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, (byte)value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, (short)value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, (int)value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, (long)value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, (double)value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToD(int from, int to, double value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, (byte)value);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, (short)value);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, (int)value);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, (long)value);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, (float)value);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, value);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value != 0.0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void fillFromToZ(int from, int to, boolean value) {
        switch (this.type) {
            case 0: {
                this.implFillFromTo(from, to, value ? (byte)1 : 0);
                break;
            }
            case 1: {
                this.implFillFromTo(from, to, value ? (short)1 : 0);
                break;
            }
            case 2: {
                this.implFillFromTo(from, to, value ? 1 : 0);
                break;
            }
            case 3: {
                this.implFillFromTo(from, to, value ? 1L : 0L);
                break;
            }
            case 4: {
                this.implFillFromTo(from, to, value ? 1.0f : 0.0f);
                break;
            }
            case 5: {
                this.implFillFromTo(from, to, value ? 1.0 : 0.0);
                break;
            }
            case 6: {
                this.implFillFromTo(from, to, value);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void implAdd(int index, byte value) {
        byte[] base = this.getBase();
        index = this.byteIndex(index);
        BYTE_ACCESS.set(base, index, (byte)(BYTE_ACCESS.get(base, index) + value));
    }

    public void implAdd(int index, short value) {
        byte[] base = this.getBase();
        index = this.shortIndex(index);
        SHORT_ACCESS.set(base, index, (short)(SHORT_ACCESS.get(base, index) + value));
    }

    public void implAdd(int index, int value) {
        byte[] base = this.getBase();
        index = this.intIndex(index);
        INT_ACCESS.set(base, index, INT_ACCESS.get(base, index) + value);
    }

    public void implAdd(int index, long value) {
        byte[] base = this.getBase();
        index = this.longIndex(index);
        LONG_ACCESS.set(base, index, LONG_ACCESS.get(base, index) + value);
    }

    public void implAdd(int index, float value) {
        byte[] base = this.getBase();
        index = this.floatIndex(index);
        FLOAT_ACCESS.set(base, index, FLOAT_ACCESS.get(base, index) + value);
    }

    public void implAdd(int index, double value) {
        byte[] base = this.getBase();
        index = this.doubleIndex(index);
        DOUBLE_ACCESS.set(base, index, DOUBLE_ACCESS.get(base, index) + value);
    }

    public void add(int index, byte value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, value);
                break;
            }
            case 1: {
                this.implAdd(index, (short)value);
                break;
            }
            case 2: {
                this.implAdd(index, (int)value);
                break;
            }
            case 3: {
                this.implAdd(index, (long)value);
                break;
            }
            case 4: {
                this.implAdd(index, (float)value);
                break;
            }
            case 5: {
                this.implAdd(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void add(int index, short value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, (byte)value);
                break;
            }
            case 1: {
                this.implAdd(index, value);
                break;
            }
            case 2: {
                this.implAdd(index, (int)value);
                break;
            }
            case 3: {
                this.implAdd(index, (long)value);
                break;
            }
            case 4: {
                this.implAdd(index, (float)value);
                break;
            }
            case 5: {
                this.implAdd(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void add(int index, int value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, (byte)value);
                break;
            }
            case 1: {
                this.implAdd(index, (short)value);
                break;
            }
            case 2: {
                this.implAdd(index, value);
                break;
            }
            case 3: {
                this.implAdd(index, (long)value);
                break;
            }
            case 4: {
                this.implAdd(index, (float)value);
                break;
            }
            case 5: {
                this.implAdd(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void add(int index, long value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, (byte)value);
                break;
            }
            case 1: {
                this.implAdd(index, (short)value);
                break;
            }
            case 2: {
                this.implAdd(index, (int)value);
                break;
            }
            case 3: {
                this.implAdd(index, value);
                break;
            }
            case 4: {
                this.implAdd(index, (float)value);
                break;
            }
            case 5: {
                this.implAdd(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void add(int index, float value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, (byte)value);
                break;
            }
            case 1: {
                this.implAdd(index, (short)value);
                break;
            }
            case 2: {
                this.implAdd(index, (int)value);
                break;
            }
            case 3: {
                this.implAdd(index, (long)value);
                break;
            }
            case 4: {
                this.implAdd(index, value);
                break;
            }
            case 5: {
                this.implAdd(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void add(int index, double value) {
        switch (this.type) {
            case 0: {
                this.implAdd(index, (byte)value);
                break;
            }
            case 1: {
                this.implAdd(index, (short)value);
                break;
            }
            case 2: {
                this.implAdd(index, (int)value);
                break;
            }
            case 3: {
                this.implAdd(index, (long)value);
                break;
            }
            case 4: {
                this.implAdd(index, (float)value);
                break;
            }
            case 5: {
                this.implAdd(index, value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't add booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void implMul(int index, byte value) {
        byte[] base = this.getBase();
        index = this.byteIndex(index);
        BYTE_ACCESS.set(base, index, (byte)(BYTE_ACCESS.get(base, index) * value));
    }

    public void implMul(int index, short value) {
        byte[] base = this.getBase();
        index = this.shortIndex(index);
        SHORT_ACCESS.set(base, index, (short)(SHORT_ACCESS.get(base, index) * value));
    }

    public void implMul(int index, int value) {
        byte[] base = this.getBase();
        index = this.intIndex(index);
        INT_ACCESS.set(base, index, INT_ACCESS.get(base, index) * value);
    }

    public void implMul(int index, long value) {
        byte[] base = this.getBase();
        index = this.longIndex(index);
        LONG_ACCESS.set(base, index, LONG_ACCESS.get(base, index) * value);
    }

    public void implMul(int index, float value) {
        byte[] base = this.getBase();
        index = this.floatIndex(index);
        FLOAT_ACCESS.set(base, index, FLOAT_ACCESS.get(base, index) * value);
    }

    public void implMul(int index, double value) {
        byte[] base = this.getBase();
        index = this.doubleIndex(index);
        DOUBLE_ACCESS.set(base, index, DOUBLE_ACCESS.get(base, index) * value);
    }

    public void mul(int index, byte value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, value);
                break;
            }
            case 1: {
                this.implMul(index, (short)value);
                break;
            }
            case 2: {
                this.implMul(index, (int)value);
                break;
            }
            case 3: {
                this.implMul(index, (long)value);
                break;
            }
            case 4: {
                this.implMul(index, (float)value);
                break;
            }
            case 5: {
                this.implMul(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void mul(int index, short value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, (byte)value);
                break;
            }
            case 1: {
                this.implMul(index, value);
                break;
            }
            case 2: {
                this.implMul(index, (int)value);
                break;
            }
            case 3: {
                this.implMul(index, (long)value);
                break;
            }
            case 4: {
                this.implMul(index, (float)value);
                break;
            }
            case 5: {
                this.implMul(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void mul(int index, int value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, (byte)value);
                break;
            }
            case 1: {
                this.implMul(index, (short)value);
                break;
            }
            case 2: {
                this.implMul(index, value);
                break;
            }
            case 3: {
                this.implMul(index, (long)value);
                break;
            }
            case 4: {
                this.implMul(index, (float)value);
                break;
            }
            case 5: {
                this.implMul(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void mul(int index, long value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, (byte)value);
                break;
            }
            case 1: {
                this.implMul(index, (short)value);
                break;
            }
            case 2: {
                this.implMul(index, (int)value);
                break;
            }
            case 3: {
                this.implMul(index, value);
                break;
            }
            case 4: {
                this.implMul(index, (float)value);
                break;
            }
            case 5: {
                this.implMul(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void mul(int index, float value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, (byte)value);
                break;
            }
            case 1: {
                this.implMul(index, (short)value);
                break;
            }
            case 2: {
                this.implMul(index, (int)value);
                break;
            }
            case 3: {
                this.implMul(index, (long)value);
                break;
            }
            case 4: {
                this.implMul(index, value);
                break;
            }
            case 5: {
                this.implMul(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void mul(int index, double value) {
        switch (this.type) {
            case 0: {
                this.implMul(index, (byte)value);
                break;
            }
            case 1: {
                this.implMul(index, (short)value);
                break;
            }
            case 2: {
                this.implMul(index, (int)value);
                break;
            }
            case 3: {
                this.implMul(index, (long)value);
                break;
            }
            case 4: {
                this.implMul(index, (float)value);
                break;
            }
            case 5: {
                this.implMul(index, value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't mul booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void implMin(int index, byte value) {
        byte[] base = this.getBase();
        index = this.byteIndex(index);
        BYTE_ACCESS.set(base, index, (byte)Math.min(BYTE_ACCESS.get(base, index), value));
    }

    public void implMin(int index, short value) {
        byte[] base = this.getBase();
        index = this.shortIndex(index);
        SHORT_ACCESS.set(base, index, (short)Math.min(SHORT_ACCESS.get(base, index), value));
    }

    public void implMin(int index, int value) {
        byte[] base = this.getBase();
        index = this.intIndex(index);
        INT_ACCESS.set(base, index, Math.min(INT_ACCESS.get(base, index), value));
    }

    public void implMin(int index, long value) {
        byte[] base = this.getBase();
        index = this.longIndex(index);
        LONG_ACCESS.set(base, index, Math.min(LONG_ACCESS.get(base, index), value));
    }

    public void implMin(int index, float value) {
        byte[] base = this.getBase();
        index = this.floatIndex(index);
        FLOAT_ACCESS.set(base, index, Math.min(FLOAT_ACCESS.get(base, index), value));
    }

    public void implMin(int index, double value) {
        byte[] base = this.getBase();
        index = this.doubleIndex(index);
        DOUBLE_ACCESS.set(base, index, Math.min(DOUBLE_ACCESS.get(base, index), value));
    }

    public void min(int index, byte value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, value);
                break;
            }
            case 1: {
                this.implMin(index, (short)value);
                break;
            }
            case 2: {
                this.implMin(index, (int)value);
                break;
            }
            case 3: {
                this.implMin(index, (long)value);
                break;
            }
            case 4: {
                this.implMin(index, (float)value);
                break;
            }
            case 5: {
                this.implMin(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void min(int index, short value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, (byte)value);
                break;
            }
            case 1: {
                this.implMin(index, value);
                break;
            }
            case 2: {
                this.implMin(index, (int)value);
                break;
            }
            case 3: {
                this.implMin(index, (long)value);
                break;
            }
            case 4: {
                this.implMin(index, (float)value);
                break;
            }
            case 5: {
                this.implMin(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void min(int index, int value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, (byte)value);
                break;
            }
            case 1: {
                this.implMin(index, (short)value);
                break;
            }
            case 2: {
                this.implMin(index, value);
                break;
            }
            case 3: {
                this.implMin(index, (long)value);
                break;
            }
            case 4: {
                this.implMin(index, (float)value);
                break;
            }
            case 5: {
                this.implMin(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void min(int index, long value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, (byte)value);
                break;
            }
            case 1: {
                this.implMin(index, (short)value);
                break;
            }
            case 2: {
                this.implMin(index, (int)value);
                break;
            }
            case 3: {
                this.implMin(index, value);
                break;
            }
            case 4: {
                this.implMin(index, (float)value);
                break;
            }
            case 5: {
                this.implMin(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void min(int index, float value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, (byte)value);
                break;
            }
            case 1: {
                this.implMin(index, (short)value);
                break;
            }
            case 2: {
                this.implMin(index, (int)value);
                break;
            }
            case 3: {
                this.implMin(index, (long)value);
                break;
            }
            case 4: {
                this.implMin(index, value);
                break;
            }
            case 5: {
                this.implMin(index, (double)value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public void min(int index, double value) {
        switch (this.type) {
            case 0: {
                this.implMin(index, (byte)value);
                break;
            }
            case 1: {
                this.implMin(index, (short)value);
                break;
            }
            case 2: {
                this.implMin(index, (int)value);
                break;
            }
            case 3: {
                this.implMin(index, (long)value);
                break;
            }
            case 4: {
                this.implMin(index, (float)value);
                break;
            }
            case 5: {
                this.implMin(index, value);
                break;
            }
            case 6: {
                throw new IllegalStateException("Can't min booleans");
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.type);
            }
        }
    }

    public int length() {
        return this.elementCount;
    }

    public NumberArray prefix(int length) {
        return this.sliceOffsetLength(0, length);
    }

    public NumberArray sliceFromTo(int from, int to) {
        Objects.checkFromToIndex(from, to, this.elementCount);
        Manager manager = this.manager;
        if (manager == null) {
            throw new IllegalStateException("NumberArray already closed!", this.closing);
        }
        return new NumberArray(this.type, manager, this.byteOffset, this.byteLength, from, to - from, false);
    }

    public NumberArray sliceOffsetLength(int offset, int length) {
        Objects.checkFromIndexSize(offset, length, this.elementCount);
        Manager manager = this.manager;
        if (manager == null) {
            throw new IllegalStateException("NumberArray already closed!", this.closing);
        }
        return new NumberArray(this.type, manager, this.byteOffset, this.byteLength, offset, length, false);
    }

    @Override
    public void close() {
        if (this.freeable && this.manager != null) {
            if (this.manager.used != this.byteOffset + this.byteLength) {
                throw new IllegalStateException("Attempt to close NumberArray in wrong order!", this.allocator);
            }
            this.manager.used = this.byteOffset;
            if (TRACE_ALLOCATIONS) {
                this.closing = new Throwable("Stack trace");
            }
        }
        this.manager = null;
    }

    public String toString() {
        Manager manager = this.manager;
        if (manager == null) {
            return "NumberArray (closed)";
        }
        byte[] base = manager.base;
        int elementCount = this.elementCount;
        return switch (this.type) {
            case 0 -> {
                StringBuilder builder = new StringBuilder(elementCount * 6).append('[');
                int from = this.byteIndexUnchecked(0);
                int to = this.byteIndexUnchecked(elementCount);
                for (int index = from; index < to; ++index) {
                    builder.append(BYTE_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 1 -> {
                StringBuilder builder = new StringBuilder(elementCount * 8).append('[');
                int from = this.shortIndexUnchecked(0);
                int to = this.shortIndexUnchecked(elementCount);
                for (int index = from; index < to; index += 2) {
                    builder.append(SHORT_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 2 -> {
                StringBuilder builder = new StringBuilder(elementCount * 11).append('[');
                int from = this.intIndexUnchecked(0);
                int to = this.intIndexUnchecked(elementCount);
                for (int index = from; index < to; index += 4) {
                    builder.append(INT_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 3 -> {
                StringBuilder builder = new StringBuilder(elementCount * 22).append('[');
                int from = this.intIndexUnchecked(0);
                int to = this.intIndexUnchecked(elementCount);
                for (int index = from; index < to; index += 8) {
                    builder.append(LONG_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 4 -> {
                StringBuilder builder = new StringBuilder(elementCount * 22).append('[');
                int from = this.intIndexUnchecked(0);
                int to = this.intIndexUnchecked(elementCount);
                for (int index = from; index < to; index += 4) {
                    builder.append(FLOAT_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 5 -> {
                StringBuilder builder = new StringBuilder(elementCount * 22).append('[');
                int from = this.intIndexUnchecked(0);
                int to = this.intIndexUnchecked(elementCount);
                for (int index = from; index < to; index += 8) {
                    builder.append(DOUBLE_ACCESS.get(base, index));
                    if (index + 1 == to) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            case 6 -> {
                StringBuilder builder = new StringBuilder(elementCount * 7).append('[');
                for (int index = 0; index < elementCount; ++index) {
                    int offsetIndex = index + this.elementOffset;
                    builder.append((base[(offsetIndex >>> 3) + this.byteOffset] >>> (offsetIndex & 7) & 1) != 0);
                    if (index + 1 == elementCount) continue;
                    builder.append(", ");
                }
                yield builder.append(']').toString();
            }
            default -> "NumberArray: (invalid type: " + this.type + ")";
        };
    }

    public static class Manager {
        public static final String MIN_PROP = "bigglobe.NumberArray.Direct.minSize";
        public static final String MAX_PROP = "bigglobe.NumberArray.Direct.maxSize";
        public static final int MIN_SIZE;
        public static final int MAX_SIZE;
        public static final int FIRST_ALIGNED_INDEX;
        public static final ThreadLocal<Manager> INSTANCES;
        public byte[] base;
        public int used;

        public Manager() {
            this(MIN_SIZE);
        }

        public Manager(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Initial capacity must be non-negative: " + size);
            }
            size += -size & 7;
            this.base = new byte[size + FIRST_ALIGNED_INDEX];
            this.used = FIRST_ALIGNED_INDEX;
        }

        public void ensureCapacity(int capacity) {
            if (capacity > MAX_SIZE) {
                throw new OutOfMemoryError("Requested capacity " + capacity + " exceeds maximum allocation limit " + MAX_SIZE + " as defined by java argument -Dbigglobe.NumberArray.Direct.maxSize");
            }
            if (this.base.length < capacity) {
                capacity = Math.min(Math.max(capacity, this.base.length << 1), MAX_SIZE);
                this.base = Arrays.copyOf(this.base, capacity);
            }
        }

        public int beforeAllocate(int bytes) {
            if (bytes < 0) {
                throw new IllegalArgumentException("Attempt to allocate negative bytes: " + bytes);
            }
            bytes += -bytes & 7;
            this.ensureCapacity(this.used + bytes);
            return bytes;
        }

        public int checkUnusedAndGetRemaining() {
            if (this.used != FIRST_ALIGNED_INDEX) {
                throw new IllegalStateException("Multiple heap allocations from the same Manager");
            }
            return this.base.length - FIRST_ALIGNED_INDEX;
        }

        public static int rshiftExact(int bytes, int shift) {
            assert (bytes >= FIRST_ALIGNED_INDEX);
            int result = bytes >>> shift;
            if (result << shift != bytes) {
                throw new IllegalStateException("Incorrect tail alignment on Manager: " + bytes + " not divisible by " + (1 << shift));
            }
            return result;
        }

        public NumberArray allocateBytesHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(0, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 0), true);
        }

        public NumberArray allocateShortsHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(1, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 1), true);
        }

        public NumberArray allocateIntsHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(2, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 2), true);
        }

        public NumberArray allocateLongsHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(3, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 3), true);
        }

        public NumberArray allocateFloatsHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(4, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 2), true);
        }

        public NumberArray allocateDoublesHeap() {
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(5, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, Manager.rshiftExact(remainingBytes, 3), true);
        }

        public NumberArray allocateBooleansHeap(int exactNumber) {
            if (exactNumber < 0) {
                throw new IllegalArgumentException("Attempt to allocate negative booleans");
            }
            int remainingBytes = this.checkUnusedAndGetRemaining();
            return new NumberArray(6, this, FIRST_ALIGNED_INDEX, remainingBytes, 0, exactNumber, true);
        }

        public NumberArray allocateBytesDirect(int bytes) {
            return new NumberArray(0, this, this.used, this.beforeAllocate(bytes << 0), 0, bytes, true);
        }

        public NumberArray allocateShortsDirect(int shorts) {
            return new NumberArray(1, this, this.used, this.beforeAllocate(shorts << 1), 0, shorts, true);
        }

        public NumberArray allocateIntsDirect(int ints) {
            return new NumberArray(2, this, this.used, this.beforeAllocate(ints << 2), 0, ints, true);
        }

        public NumberArray allocateLongsDirect(int longs) {
            return new NumberArray(3, this, this.used, this.beforeAllocate(longs << 3), 0, longs, true);
        }

        public NumberArray allocateFloatsDirect(int floats) {
            return new NumberArray(4, this, this.used, this.beforeAllocate(floats << 2), 0, floats, true);
        }

        public NumberArray allocateDoublesDirect(int doubles) {
            return new NumberArray(5, this, this.used, this.beforeAllocate(doubles << 3), 0, doubles, true);
        }

        public NumberArray allocateBooleansDirect(int booleans) {
            if (booleans < 0) {
                throw new IllegalArgumentException("Attempt to allocate negative booleans: " + booleans);
            }
            return new NumberArray(6, this, this.used, this.beforeAllocate((booleans - 1 >> 3) + 1), 0, booleans, true);
        }

        public char hex(int shift) {
            int number;
            return (char)(number + ((number = System.identityHashCode(this.base) >>> shift & 0xF) >= 10 ? 55 : 48));
        }

        public String formatPointer() {
            return "0x" + this.hex(28) + this.hex(24) + this.hex(20) + this.hex(16) + this.hex(12) + this.hex(8) + this.hex(4) + this.hex(0);
        }

        public String toString() {
            return this.getClass().getName() + ": { base: " + this.formatPointer() + ", used: " + this.used + ", capacity: " + this.base.length + " }";
        }

        static {
            int firstAlignedIndex;
            block5: {
                MIN_SIZE = Integer.getInteger(MIN_PROP, 8192);
                MAX_SIZE = Integer.getInteger(MAX_PROP, 0x100000);
                if ((long)MIN_SIZE <= 0L) {
                    throw new IllegalStateException("-Dbigglobe.NumberArray.Direct.minSize must be positive.");
                }
                if (MAX_SIZE < MIN_SIZE) {
                    throw new IllegalStateException("-Dbigglobe.NumberArray.Direct.maxSize must be greater than or equal to -Dbigglobe.NumberArray.Direct.minSize");
                }
                ByteBuffer buffer = ByteBuffer.wrap(new byte[0]);
                for (int alignment : new int[]{8, 4, 2, 1}) {
                    try {
                        firstAlignedIndex = -buffer.alignmentOffset(0, alignment) & alignment - 1;
                        Testing.log("Got first aligned index " + firstAlignedIndex + " for alignment " + alignment);
                        break block5;
                    }
                    catch (Exception exception) {
                    }
                }
                firstAlignedIndex = 0;
                Testing.log("Failed to get alignment index. Assuming 0.");
            }
            FIRST_ALIGNED_INDEX = firstAlignedIndex;
            INSTANCES = ThreadLocal.withInitial(Manager::new);
        }

        public static class Testing {
            public static boolean TESTING = false;

            public static void log(String message) {
                if (TESTING) {
                    System.out.println(message);
                } else {
                    BigGlobeMod.LOGGER.info(message);
                }
            }
        }
    }

    public static class Info
    extends InfoHolder {
        public FieldInfo EMPTY_BYTE;
        public FieldInfo EMPTY_SHORT;
        public FieldInfo EMPTY_INT;
        public FieldInfo EMPTY_LONG;
        public FieldInfo EMPTY_FLOAT;
        public FieldInfo EMPTY_DOUBLE;
        public FieldInfo EMPTY_BOOLEAN;
        public MethodInfo allocateBytesHeap;
        public MethodInfo allocateShortsHeap;
        public MethodInfo allocateIntsHeap;
        public MethodInfo allocateLongsHeap;
        public MethodInfo allocateFloatsHeap;
        public MethodInfo allocateDoublesHeap;
        public MethodInfo allocateBooleansHeap;
        public MethodInfo allocateBytesDirectZero;
        public MethodInfo allocateShortsDirectZero;
        public MethodInfo allocateIntsDirectZero;
        public MethodInfo allocateLongsDirectZero;
        public MethodInfo allocateFloatsDirectZero;
        public MethodInfo allocateDoublesDirectZero;
        public MethodInfo allocateBooleansDirectZero;
        public MethodInfo getB;
        public MethodInfo getS;
        public MethodInfo getI;
        public MethodInfo getL;
        public MethodInfo getF;
        public MethodInfo getD;
        public MethodInfo getZ;
        public MethodInfo implGetB;
        public MethodInfo implGetS;
        public MethodInfo implGetI;
        public MethodInfo implGetL;
        public MethodInfo implGetF;
        public MethodInfo implGetD;
        public MethodInfo implGetZ;
        public MethodInfo setB;
        public MethodInfo setS;
        public MethodInfo setI;
        public MethodInfo setL;
        public MethodInfo setF;
        public MethodInfo setD;
        public MethodInfo setZ;
        public MethodInfo implSetB;
        public MethodInfo implSetS;
        public MethodInfo implSetI;
        public MethodInfo implSetL;
        public MethodInfo implSetF;
        public MethodInfo implSetD;
        public MethodInfo implSetZ;
        public MethodInfo fillB;
        public MethodInfo fillS;
        public MethodInfo fillI;
        public MethodInfo fillL;
        public MethodInfo fillF;
        public MethodInfo fillD;
        public MethodInfo fillZ;
        public MethodInfo fillFromToB;
        public MethodInfo fillFromToS;
        public MethodInfo fillFromToI;
        public MethodInfo fillFromToL;
        public MethodInfo fillFromToF;
        public MethodInfo fillFromToD;
        public MethodInfo fillFromToZ;
        public MethodInfo length;
        public MethodInfo prefix;
        public MethodInfo sliceFromTo;
        public MethodInfo sliceOffsetLength;
    }
}

