/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.polynomials;

import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.polynomials.Polynomial;
import builderb0y.bigglobe.noise.polynomials.Polynomial2;

public class SmootherPolynomial
extends Polynomial2 {
    public static final Form FORM = new Form();
    public double term0;
    public double term1;
    public double term2;

    public SmootherPolynomial(double value0, double value1, double rcp) {
        super(value0, value1, rcp);
    }

    @Override
    public void update(double value0, double value1, double rcp) {
        double diff = value1 - value0;
        this.term0 = diff * 6.0;
        this.term1 = diff * -15.0;
        this.term2 = diff * 10.0;
    }

    @Override
    public double interpolate(double fraction) {
        return ((fraction * this.term0 + this.term1) * fraction + this.term2) * fraction * fraction * fraction + this.value0;
    }

    @Override
    public Polynomial.PolyForm form() {
        return FORM;
    }

    public static class Form
    extends Polynomial2.PolyForm2 {
        @Override
        public double calcMinValue(double min, double max, double rcp) {
            return min;
        }

        @Override
        public double calcMaxValue(double min, double max, double rcp) {
            return max;
        }

        @Override
        public Polynomial createPolynomial(double value0, double value1, double rcp) {
            return new SmootherPolynomial(value0, value1, rcp);
        }

        @Override
        public double interpolate(double value0, double value1, double rcp, double fraction) {
            return Interpolator.mixSmootherUnchecked(value0, value1, fraction);
        }
    }
}

