/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.processing.LayeredGrid;

public interface LayeredGrid2D
extends LayeredGrid,
Grid2D {
    public Grid2D[] getLayers();

    @Override
    default public double getValue(long seed, int x, int y) {
        Grid2D[] layers = this.getLayers();
        double value = layers[0].getValue(seed, x, y);
        if (this.isProduct()) {
            int length = layers.length;
            for (int index = 1; index < length; ++index) {
                value *= layers[index].getValue(seed, x, y);
            }
        } else {
            int length = layers.length;
            for (int index = 1; index < length; ++index) {
                value += layers[index].getValue(seed, x, y);
            }
        }
        return value;
    }

    @Override
    default public void getBulkX(long seed, int startX, int y, NumberArray samples) {
        if (samples.length() <= 0) {
            return;
        }
        Grid2D[] layers = this.getLayers();
        layers[0].getBulkX(seed, startX, y, samples);
        try (NumberArray scratch = NumberArray.allocateDoublesDirect(samples.length());){
            int length = layers.length;
            for (int layerIndex = 1; layerIndex < length; ++layerIndex) {
                layers[layerIndex].getBulkX(seed, startX, y, scratch);
                this.accumulate(samples, scratch);
            }
        }
    }

    @Override
    default public void getBulkY(long seed, int x, int startY, NumberArray samples) {
        if (samples.length() <= 0) {
            return;
        }
        Grid2D[] layers = this.getLayers();
        layers[0].getBulkY(seed, x, startY, samples);
        try (NumberArray scratch = NumberArray.allocateDoublesDirect(samples.length());){
            int length = layers.length;
            for (int layerIndex = 1; layerIndex < length; ++layerIndex) {
                layers[layerIndex].getBulkY(seed, x, startY, scratch);
                this.accumulate(samples, scratch);
            }
        }
    }
}

