/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.processing.UnaryGrid;

public abstract class SquareGrid
implements UnaryGrid {
    public final transient double minValue;
    public final transient double maxValue;

    public SquareGrid(Grid grid) {
        double min = grid.minValue();
        double max = grid.maxValue();
        double squareMin = BigGlobeMath.squareD(min);
        double squareMax = BigGlobeMath.squareD(max);
        this.minValue = min <= 0.0 && max >= 0.0 ? 0.0 : Math.min(squareMin, squareMax);
        this.maxValue = Math.max(squareMin, squareMax);
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public double operate(double value) {
        return value * value;
    }
}

