/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.resample;

import builderb0y.autocodec.annotations.Alias;
import builderb0y.autocodec.annotations.VerifyIntRange;
import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.polynomials.Polynomial;

public abstract class ResampleGrid2D
implements Grid2D {
    public final Grid2D source;
    public final @VerifyIntRange(min=0L, minInclusive=false) @Alias(value={"scale"}) int scaleX;
    public final @VerifyIntRange(min=0L, minInclusive=false) @Alias(value={"scale"}) int scaleY;
    public final transient double rcpX;
    public final transient double rcpY;
    public final transient double minValue;
    public final transient double maxValue;

    public ResampleGrid2D(Grid2D source, int scaleX, int scaleY) {
        this.source = source;
        this.scaleX = scaleX;
        this.rcpX = 1.0 / (double)this.scaleX;
        this.scaleY = scaleY;
        this.rcpY = 1.0 / (double)this.scaleY;
        double minY = this.polyFormY().calcMinValue(source.minValue(), source.maxValue(), this.rcpY);
        double maxY = this.polyFormY().calcMaxValue(source.minValue(), source.maxValue(), this.rcpY);
        this.minValue = this.polyFormX().calcMinValue(minY, maxY, this.rcpX);
        this.maxValue = this.polyFormX().calcMaxValue(minY, maxY, this.rcpX);
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    public abstract Polynomial.PolyForm polyFormX();

    public abstract Polynomial.PolyForm polyFormY();
}

