/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.source;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Grid3D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.noise.source.WorleyGrid;
import builderb0y.bigglobe.settings.Seed;

public class WorleyGrid3D
extends WorleyGrid
implements Grid3D {
    public static final double SQRT_3 = Math.sqrt(3.0);
    public final transient double radius;

    public WorleyGrid3D(Seed salt, int scale, double amplitude) {
        super(salt, scale, amplitude, amplitude / (BigGlobeMath.squareD(scale) * 3.0));
        this.radius = (double)scale * SQRT_3;
    }

    public double getCenterX(long seed, int cellX, int cellY, int cellZ) {
        return ((double)cellX + Permuter.toPositiveDouble(Permuter.permute(seed ^ 0x4A15ABD55E2B33FAL, cellX, cellY, cellZ))) * (double)this.scale;
    }

    public double getCenterY(long seed, int cellX, int cellY, int cellZ) {
        return ((double)cellY + Permuter.toPositiveDouble(Permuter.permute(seed ^ 0xBD18E4990F501842L, cellX, cellY, cellZ))) * (double)this.scale;
    }

    public double getCenterZ(long seed, int cellX, int cellY, int cellZ) {
        return ((double)cellZ + Permuter.toPositiveDouble(Permuter.permute(seed ^ 0xDB0A05170C119521L, cellX, cellY, cellZ))) * (double)this.scale;
    }

    @Override
    public double getValue(long seed, int x, int y, int z) {
        seed ^= this.salt.value;
        int minCellX = Math.floorDiv(BigGlobeMath.ceilI((double)x - this.radius), this.scale);
        int maxCellX = Math.floorDiv(BigGlobeMath.floorI((double)x + this.radius), this.scale);
        int minCellY = Math.floorDiv(BigGlobeMath.ceilI((double)y - this.radius), this.scale);
        int maxCellY = Math.floorDiv(BigGlobeMath.floorI((double)y + this.radius), this.scale);
        int minCellZ = Math.floorDiv(BigGlobeMath.ceilI((double)z - this.radius), this.scale);
        int maxCellZ = Math.floorDiv(BigGlobeMath.floorI((double)z + this.radius), this.scale);
        double value = Double.POSITIVE_INFINITY;
        for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
            for (int cellY = minCellY; cellY <= maxCellY; ++cellY) {
                for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
                    double centerX = this.getCenterX(seed, cellX, cellY, cellZ);
                    double centerY = this.getCenterY(seed, cellX, cellY, cellZ);
                    double centerZ = this.getCenterZ(seed, cellX, cellY, cellZ);
                    value = Math.min(value, BigGlobeMath.squareD(centerX - (double)x, centerY - (double)y, centerZ - (double)z));
                }
            }
        }
        return value * this.rcp;
    }

    @Override
    public void getBulkX(long seed, int startX, int y, int z, NumberArray samples) {
        int sampleCount = samples.length();
        seed ^= this.salt.value;
        samples.fillD(Double.POSITIVE_INFINITY);
        int minCellX = Math.floorDiv(BigGlobeMath.ceilI((double)startX - this.radius), this.scale);
        int maxCellX = Math.floorDiv(BigGlobeMath.floorI((double)(startX + sampleCount) + this.radius), this.scale);
        int minCellY = Math.floorDiv(BigGlobeMath.ceilI((double)y - this.radius), this.scale);
        int maxCellY = Math.floorDiv(BigGlobeMath.floorI((double)y + this.radius), this.scale);
        int minCellZ = Math.floorDiv(BigGlobeMath.ceilI((double)z - this.radius), this.scale);
        int maxCellZ = Math.floorDiv(BigGlobeMath.floorI((double)z + this.radius), this.scale);
        double radius2 = BigGlobeMath.squareD(this.radius);
        for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
            for (int cellY = minCellY; cellY <= maxCellY; ++cellY) {
                for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
                    int index;
                    double distance;
                    int x;
                    double centerX = this.getCenterX(seed, cellX, cellY, cellZ);
                    double centerY = this.getCenterY(seed, cellX, cellY, cellZ);
                    double centerZ = this.getCenterZ(seed, cellX, cellY, cellZ);
                    double yz2 = BigGlobeMath.squareD(centerY - (double)y, centerZ - (double)z);
                    int limit = startX + sampleCount - 1;
                    for (x = Math.min(BigGlobeMath.floorI(centerX), limit); x >= startX && (distance = BigGlobeMath.squareD(centerX - (double)x) + yz2) < radius2; --x) {
                        index = x - startX;
                        samples.min(index, distance);
                    }
                    for (x = Math.max(BigGlobeMath.floorI(centerX) + 1, startX); x <= limit && (distance = BigGlobeMath.squareD(centerX - (double)x) + yz2) < radius2; ++x) {
                        index = x - startX;
                        samples.min(index, distance);
                    }
                }
            }
        }
        this.scale(samples);
    }

    @Override
    public void getBulkY(long seed, int x, int startY, int z, NumberArray samples) {
        int sampleCount = samples.length();
        seed ^= this.salt.value;
        samples.fillD(Double.POSITIVE_INFINITY);
        int minCellX = Math.floorDiv(BigGlobeMath.ceilI((double)x - this.radius), this.scale);
        int maxCellX = Math.floorDiv(BigGlobeMath.floorI((double)x + this.radius), this.scale);
        int minCellY = Math.floorDiv(BigGlobeMath.ceilI((double)startY - this.radius), this.scale);
        int maxCellY = Math.floorDiv(BigGlobeMath.floorI((double)(startY + sampleCount) + this.radius), this.scale);
        int minCellZ = Math.floorDiv(BigGlobeMath.ceilI((double)z - this.radius), this.scale);
        int maxCellZ = Math.floorDiv(BigGlobeMath.floorI((double)z + this.radius), this.scale);
        double radius2 = BigGlobeMath.squareD(this.radius);
        for (int cellY = minCellY; cellY <= maxCellY; ++cellY) {
            for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
                for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
                    int index;
                    double distance;
                    int y;
                    double centerX = this.getCenterX(seed, cellX, cellY, cellZ);
                    double centerY = this.getCenterY(seed, cellX, cellY, cellZ);
                    double centerZ = this.getCenterZ(seed, cellX, cellY, cellZ);
                    double xz2 = BigGlobeMath.squareD(centerX - (double)x, centerZ - (double)z);
                    int limit = startY + sampleCount - 1;
                    for (y = Math.min(BigGlobeMath.floorI(centerY), limit); y >= startY && (distance = BigGlobeMath.squareD(centerY - (double)y) + xz2) < radius2; --y) {
                        index = y - startY;
                        samples.min(index, distance);
                    }
                    for (y = Math.max(BigGlobeMath.floorI(centerY) + 1, startY); y <= limit && (distance = BigGlobeMath.squareD(centerY - (double)y) + xz2) < radius2; ++y) {
                        index = y - startY;
                        samples.min(index, distance);
                    }
                }
            }
        }
        this.scale(samples);
    }

    @Override
    public void getBulkZ(long seed, int x, int y, int startZ, NumberArray samples) {
        int sampleCount = samples.length();
        seed ^= this.salt.value;
        samples.fillD(Double.POSITIVE_INFINITY);
        int minCellX = Math.floorDiv(BigGlobeMath.ceilI((double)x - this.radius), this.scale);
        int maxCellX = Math.floorDiv(BigGlobeMath.floorI((double)x + this.radius), this.scale);
        int minCellY = Math.floorDiv(BigGlobeMath.ceilI((double)y - this.radius), this.scale);
        int maxCellY = Math.floorDiv(BigGlobeMath.floorI((double)y + this.radius), this.scale);
        int minCellZ = Math.floorDiv(BigGlobeMath.ceilI((double)startZ - this.radius), this.scale);
        int maxCellZ = Math.floorDiv(BigGlobeMath.floorI((double)(startZ + sampleCount) + this.radius), this.scale);
        double radius2 = BigGlobeMath.squareD(this.radius);
        for (int cellZ = minCellZ; cellZ <= maxCellZ; ++cellZ) {
            for (int cellX = minCellX; cellX <= maxCellX; ++cellX) {
                for (int cellY = minCellY; cellY <= maxCellY; ++cellY) {
                    int index;
                    double distance;
                    int z;
                    double centerX = this.getCenterX(seed, cellX, cellY, cellZ);
                    double centerY = this.getCenterY(seed, cellX, cellY, cellZ);
                    double centerZ = this.getCenterZ(seed, cellX, cellY, cellZ);
                    double xy2 = BigGlobeMath.squareD(centerX - (double)x, centerY - (double)y);
                    int limit = startZ + sampleCount - 1;
                    for (z = Math.min(BigGlobeMath.floorI(centerZ), limit); z >= startZ && (distance = BigGlobeMath.squareD(centerZ - (double)z) + xy2) < radius2; --z) {
                        index = z - startZ;
                        samples.min(index, distance);
                    }
                    for (z = Math.max(BigGlobeMath.floorI(centerZ) + 1, startZ); z <= limit && (distance = BigGlobeMath.squareD(centerZ - (double)z) + xy2) < radius2; ++z) {
                        index = z - startZ;
                        samples.min(index, distance);
                    }
                }
            }
        }
        this.scale(samples);
    }
}

