/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.overriders;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.Wrapper;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.overriders.Overrider;
import builderb0y.bigglobe.scripting.environments.NbtScriptEnvironment;
import builderb0y.bigglobe.scripting.environments.StructureScriptEnvironment;
import builderb0y.bigglobe.scripting.environments.WoodPaletteScriptEnvironment;
import builderb0y.bigglobe.scripting.wrappers.StructureStartWrapper;
import builderb0y.bigglobe.structures.ScriptStructures;
import builderb0y.bigglobe.structures.scripted.ScriptedStructure;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.environments.JavaUtilScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.input.ScriptUsage;
import builderb0y.scripting.util.ReflectionData;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Method;
import net.minecraft.class_3341;
import net.minecraft.class_3443;

public interface ColumnValueOverrider
extends ColumnScript {
    public void override(ScriptedColumn var1, ScriptStructures var2);

    public static double distanceToSquare(ScriptedColumn column, double minX, double minZ, double maxX, double maxZ) {
        double offsetX = Interpolator.clamp(minX, maxX, (double)column.x()) - (double)column.x();
        double offsetZ = Interpolator.clamp(minZ, maxZ, (double)column.z()) - (double)column.z();
        return Math.sqrt(BigGlobeMath.squareD(offsetX, offsetZ));
    }

    public static double distanceToSquare(ScriptedColumn column, StructureStartWrapper structure) {
        return ColumnValueOverrider.distanceToSquare(column, structure.minX(), structure.minZ(), structure.maxX(), structure.maxZ());
    }

    public static double distanceToSquare(ScriptedColumn column, class_3443 piece) {
        class_3341 box = piece.method_14935();
        return ColumnValueOverrider.distanceToSquare(column, box.method_35415(), box.method_35417(), box.method_35418(), box.method_35420());
    }

    public static double distanceToCircle(ScriptedColumn column, double centerX, double centerZ, double radius) {
        return Math.max(Math.sqrt(BigGlobeMath.squareD(centerX - (double)column.x(), centerZ - (double)column.z())) - radius, 0.0);
    }

    public static double _distanceToCircle(ScriptedColumn column, class_3341 box, double radius) {
        return ColumnValueOverrider.distanceToCircle(column, (double)(box.method_35415() + box.method_35418()) * 0.5, (double)(box.method_35417() + box.method_35420()) * 0.5, radius);
    }

    public static double _distanceToCircle(ScriptedColumn column, class_3341 box) {
        return ColumnValueOverrider._distanceToCircle(column, box, (double)Math.min(box.method_35418() - box.method_35415(), box.method_35420() - box.method_35417()) * 0.5);
    }

    public static double distanceToCircle(ScriptedColumn column, StructureStartWrapper structure, double radius) {
        return ColumnValueOverrider._distanceToCircle(column, structure.box(), radius);
    }

    public static double distanceToCircle(ScriptedColumn column, class_3443 piece, double radius) {
        return ColumnValueOverrider._distanceToCircle(column, piece.method_14935(), radius);
    }

    public static double distanceToCircle(ScriptedColumn column, StructureStartWrapper structure) {
        return ColumnValueOverrider._distanceToCircle(column, structure.box());
    }

    public static double distanceToCircle(ScriptedColumn column, class_3443 piece) {
        return ColumnValueOverrider._distanceToCircle(column, piece.method_14935());
    }

    @Wrapper
    public static class Holder
    extends ColumnScript.BaseHolder<ColumnValueOverrider>
    implements ColumnValueOverrider {
        public Holder(ScriptUsage usage) {
            super(usage);
        }

        @Override
        public boolean isColumnMutable() {
            return true;
        }

        @Override
        public Class<ColumnValueOverrider> getScriptClass() {
            return ColumnValueOverrider.class;
        }

        @Override
        public void addExtraFunctionsToEnvironment(ColumnScript.ImplParameters parameters, MutableScriptEnvironment environment) {
            super.addExtraFunctionsToEnvironment(parameters, environment);
            LoadInsnTree loadColumn = InsnTrees.load(parameters.actualColumn);
            environment.addAll(StructureScriptEnvironment.INSTANCE).configure(NbtScriptEnvironment.createImmutable()).addFieldGet(ScriptedStructure.Piece.class, "data").addVariableLoad("structures", InsnTrees.type(ScriptStructures.class)).configure(JavaUtilScriptEnvironment.withoutRandom()).addAll(WoodPaletteScriptEnvironment.BASE);
            for (String name : new String[]{"distanceToSquare", "distanceToCircle"}) {
                for (Method method : ReflectionData.forClass(ColumnValueOverrider.class).getDeclaredMethods(name)) {
                    MethodInfo info = MethodInfo.forMethod(method);
                    environment.addFunction(name, new MutableScriptEnvironment.FunctionHandler.Named(info.toString(), (parser, name1, arguments) -> {
                        InsnTree[] prefixedArguments = (InsnTree[])ObjectArrays.concat((Object)loadColumn, (Object[])arguments);
                        InsnTree[] castArguments = ScriptEnvironment.castArguments(parser, info, InsnTree.CastMode.IMPLICIT_NULL, prefixedArguments);
                        return castArguments == null ? null : new MutableScriptEnvironment.CastResult(InsnTrees.invokeStatic(info, castArguments), castArguments != prefixedArguments);
                    }));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void override(ScriptedColumn column, ScriptStructures structures) {
            NumberArray.Manager manager = NumberArray.Manager.INSTANCES.get();
            int used = manager.used;
            try {
                ((ColumnValueOverrider)this.script).override(column, structures);
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
            finally {
                manager.used = used;
            }
        }
    }

    public record Entry(Holder script, @DefaultBoolean(value=true) boolean raw_generation, @DefaultBoolean(value=true) boolean feature_generation) implements Overrider
    {
        @Override
        public Overrider.Type getOverriderType() {
            return Overrider.Type.COLUMN_VALUE;
        }
    }
}

