/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomLists;

import builderb0y.bigglobe.randomLists.IRandomList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractRandomList<E>
extends AbstractList<E>
implements IRandomList<E> {
    @Override
    public E set(int index, E element, double weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double setWeight(int index, double weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E element, double weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element, double weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRandomList.WeightedIterator<E> iterator() {
        return new Itr();
    }

    @Override
    public IRandomList.WeightedListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public IRandomList.WeightedListIterator<E> listIterator(int index) {
        this.checkIndexForAdd(index);
        return new ListItr(index);
    }

    @Override
    public IRandomList<E> subList(int fromIndex, int toIndex) {
        this.checkBoundsForSubList(fromIndex, toIndex);
        return this instanceof RandomAccess ? new RandomAccessSubList(fromIndex, toIndex) : new SubList(fromIndex, toIndex);
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public boolean equals(Object o) {
        return this.defaultEquals(o);
    }

    @Override
    public int hashCode() {
        return this.defaultHashCode();
    }

    public void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
    }

    public void checkIndexForAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMessage(index));
        }
    }

    public String outOfBoundsMessage(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    public void checkBoundsForSubList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex + ", size: " + this.size());
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex (" + fromIndex + ") > toIndex (" + toIndex + ")");
        }
    }

    static /* synthetic */ int access$000(AbstractRandomList x0) {
        return x0.modCount;
    }

    public class Itr
    implements IRandomList.WeightedIterator<E> {
        public int cursor = 0;
        public int lastRet = -1;
        public int expectedModCount = AbstractRandomList.access$000(AbstractRandomList.this);

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractRandomList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = AbstractRandomList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractRandomList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractRandomList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public double getWeight() {
            int lastRet = this.lastRet;
            if (lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            return AbstractRandomList.this.getWeight(lastRet);
        }

        public void checkForComodification() {
            if (AbstractRandomList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public class ListItr
    extends Itr
    implements IRandomList.WeightedListIterator<E> {
        public ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = AbstractRandomList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractRandomList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractRandomList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void setWeight(double weight) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractRandomList.this.setWeight(this.lastRet, weight);
                this.expectedModCount = AbstractRandomList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                AbstractRandomList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = AbstractRandomList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public class RandomAccessSubList
    extends SubList
    implements IRandomList.RandomAccessRandomList<E> {
        public RandomAccessSubList(int fromIndex, int toIndex) {
            super(fromIndex, toIndex);
        }
    }

    public class SubList
    extends AbstractRandomList<E> {
        public final int offset;
        public int size;

        public SubList(int fromIndex, int toIndex) {
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = AbstractRandomList.this.modCount;
        }

        @Override
        public E get(int index) {
            this.checkIndex(index);
            this.checkForComodification();
            return AbstractRandomList.this.get(index + this.offset);
        }

        @Override
        public double getWeight(int index) {
            this.checkIndex(index);
            this.checkForComodification();
            return AbstractRandomList.this.getWeight(index + this.offset);
        }

        @Override
        public E set(int index, E element) {
            this.checkIndex(index);
            this.checkForComodification();
            return AbstractRandomList.this.set(index + this.offset, element);
        }

        @Override
        public E set(int index, E element, double weight) {
            this.checkIndex(index);
            this.checkForComodification();
            return AbstractRandomList.this.set(index + this.offset, element, weight);
        }

        @Override
        public double setWeight(int index, double weight) {
            this.checkIndex(index);
            this.checkForComodification();
            return AbstractRandomList.this.setWeight(index + this.offset, weight);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.checkIndexForAdd(index);
            this.checkForComodification();
            AbstractRandomList.this.add(index + this.offset, element);
            this.modCount = AbstractRandomList.this.modCount;
            ++this.size;
        }

        @Override
        public boolean add(E element, double weight) {
            this.checkForComodification();
            AbstractRandomList.this.add(this.size + this.offset, element, weight);
            return true;
        }

        @Override
        public void add(int index, E element, double weight) {
            this.checkIndex(index);
            this.checkForComodification();
            AbstractRandomList.this.add(index + this.offset, element, weight);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.checkIndexForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            AbstractRandomList.this.addAll(this.offset + index, c);
            this.modCount = AbstractRandomList.this.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public E remove(int index) {
            this.checkIndex(index);
            this.checkForComodification();
            Object result = AbstractRandomList.this.remove(index + this.offset);
            this.modCount = AbstractRandomList.this.modCount;
            --this.size;
            return result;
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            AbstractRandomList.this.removeRange(fromIndex + this.offset, toIndex + this.offset);
            this.modCount = AbstractRandomList.this.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public IRandomList.WeightedIterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public IRandomList.WeightedListIterator<E> listIterator(int index) {
            this.checkForComodification();
            this.checkIndexForAdd(index);
            ListIterator delegate = AbstractRandomList.this.listIterator(index + this.offset);
            return new IRandomList.WeightedListIterator<E>(){
                final /* synthetic */ IRandomList.WeightedListIterator val$delegate;
                final /* synthetic */ SubList this$1;
                {
                    this.val$delegate = val$delegate;
                    this.this$1 = this$1;
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < this.this$1.size;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        return this.val$delegate.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public double getWeight() {
                    return this.val$delegate.getWeight();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public E previous() {
                    if (this.hasPrevious()) {
                        return this.val$delegate.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.val$delegate.nextIndex() - this.this$1.offset;
                }

                @Override
                public int previousIndex() {
                    return this.val$delegate.previousIndex() - this.this$1.offset;
                }

                @Override
                public void remove() {
                    this.val$delegate.remove();
                    this.this$1.modCount = this.this$1.AbstractRandomList.this.modCount;
                    --this.this$1.size;
                }

                @Override
                public void set(E e) {
                    this.val$delegate.set(e);
                }

                @Override
                public void setWeight(double weight) {
                    this.val$delegate.setWeight(weight);
                }

                @Override
                public void add(E e) {
                    this.val$delegate.add(e);
                    this.this$1.modCount = this.this$1.AbstractRandomList.this.modCount;
                    ++this.this$1.size;
                }
            };
        }

        @Override
        public IRandomList<E> subList(int fromIndex, int toIndex) {
            this.checkBoundsForSubList(fromIndex, toIndex);
            return AbstractRandomList.this.subList(this.offset + fromIndex, this.offset + toIndex);
        }

        public void checkForComodification() {
            if (this.modCount != AbstractRandomList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

