/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomLists;

import builderb0y.autocodec.annotations.EncodeInline;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.SingletonArray;
import builderb0y.autocodec.annotations.UseEncoder;
import builderb0y.autocodec.annotations.UseImprinter;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.PrimitiveCoders;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.decoders.AutoDecoder;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.AutoEncoder;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.imprinters.AutoImprinter;
import builderb0y.autocodec.imprinters.ImprintContext;
import builderb0y.autocodec.imprinters.ImprintException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.randomLists.AbstractRandomList;
import builderb0y.bigglobe.randomLists.IRandomList;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import java.util.random.RandomGenerator;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseImprinter(name="new", in=RandomListImprinter.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
@UseEncoder(name="new", in=RandomListEncoder.class, usage=MemberUsage.METHOD_IS_FACTORY, strict=false)
public class RandomList<E>
extends AbstractRandomList<E>
implements IRandomList.RandomAccessKnownTotalWeightRandomList<E>,
Cloneable {
    public Object[] elements;
    public double[] weights;
    public int size = 0;
    public double totalWeight = 0.0;

    public RandomList() {
        this.elements = ObjectArrays.DEFAULT_EMPTY_ARRAY;
        this.weights = DoubleArrays.DEFAULT_EMPTY_ARRAY;
    }

    public RandomList(int initialCapacity) {
        this.elements = initialCapacity == 0 ? ObjectArrays.DEFAULT_EMPTY_ARRAY : new Object[initialCapacity];
        this.weights = initialCapacity == 0 ? DoubleArrays.DEFAULT_EMPTY_ARRAY : new double[initialCapacity];
    }

    public RandomList(RandomList<? extends E> other) {
        if (other.isEmpty()) {
            this.elements = ObjectArrays.DEFAULT_EMPTY_ARRAY;
            this.weights = DoubleArrays.DEFAULT_EMPTY_ARRAY;
        } else {
            this.elements = java.util.Arrays.copyOf(other.elements, other.size);
            this.weights = java.util.Arrays.copyOf(other.weights, other.size);
            this.size = other.size;
            this.totalWeight = other.totalWeight;
        }
    }

    public final E getRawElement(int index) {
        return (E)this.elements[index];
    }

    public final void setRawElement(int index, E element) {
        this.elements[index] = element;
    }

    public final E[] castRawElements() {
        return this.elements;
    }

    public static double checkWeight(double weight) {
        if (Double.isNaN(weight)) {
            return 0.0;
        }
        if (weight >= 0.0) {
            return weight;
        }
        throw new IllegalArgumentException("weight must be greater than or equal to 0.0.");
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.getRawElement(index);
    }

    @Override
    public int getRandomIndex(RandomGenerator random) {
        return IRandomList.RandomAccessKnownTotalWeightRandomList.super.getRandomIndex(random);
    }

    @Override
    public int getRandomIndex(long seed) {
        return IRandomList.RandomAccessKnownTotalWeightRandomList.super.getRandomIndex(seed);
    }

    @Override
    public double getWeight(int index) {
        this.checkIndex(index);
        return this.weights[index];
    }

    @Override
    public double getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        E oldValue = this.getRawElement(index);
        this.setRawElement(index, element);
        return oldValue;
    }

    @Override
    public E set(int index, E element, double weight) {
        this.checkIndex(index);
        RandomList.checkWeight(weight);
        E oldValue = this.getRawElement(index);
        double oldWeight = this.weights[index];
        this.setRawElement(index, element);
        this.weights[index] = weight;
        this.totalWeight += weight - oldWeight;
        return oldValue;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        ++this.modCount;
        E[] elements = this.castRawElements();
        int size = this.size;
        for (int index = 0; index < size; ++index) {
            elements[index] = operator.apply(elements[index]);
        }
    }

    @Override
    public double setWeight(int index, double weight) {
        this.checkIndex(index);
        double oldWeight = this.weights[index];
        this.weights[index] = weight;
        return oldWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllWeights(ToDoubleFunction<? super E> updater) {
        int index;
        int size = this.size;
        if (size == 0) {
            return;
        }
        E[] elements = this.castRawElements();
        double[] weights = this.weights;
        double totalWeight = 0.0;
        try {
            for (index = 0; index < size; ++index) {
                weights[index] = RandomList.checkWeight(updater.applyAsDouble(elements[index]));
                totalWeight += weights[index];
            }
        }
        finally {
            while (index < size) {
                totalWeight += weights[index];
                ++index;
            }
            this.totalWeight = totalWeight;
        }
    }

    @Override
    public int indexOf(Object element) {
        E[] elements = this.castRawElements();
        if (element != null) {
            int size = this.size;
            for (int i = 0; i < size; ++i) {
                if (!element.equals(elements[i])) continue;
                return i;
            }
        } else {
            int size = this.size;
            for (int i = 0; i < size; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        E[] elements = this.castRawElements();
        if (element != null) {
            int i = this.size;
            while (i-- != 0) {
                if (!element.equals(elements[i])) continue;
                return i;
            }
        } else {
            int i = this.size;
            while (i-- != 0) {
                if (elements[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException("Must specify weight");
    }

    @Override
    public boolean add(E element, double weight) {
        RandomList.checkWeight(weight);
        ++this.modCount;
        int size = this.size;
        int newSize = size + 1;
        this.ensureCapacity(newSize);
        this.elements[size] = element;
        this.weights[size] = weight;
        this.size = newSize;
        this.totalWeight += weight;
        return true;
    }

    public RandomList<E> addSelf(E element, double weight) {
        this.add(element, weight);
        return this;
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException("Must specify weight");
    }

    @Override
    public void add(int index, E element, double weight) {
        this.checkIndexForAdd(index);
        RandomList.checkWeight(weight);
        ++this.modCount;
        int size = this.size;
        int newSize = size + 1;
        this.ensureCapacity(newSize);
        int moved = size - index;
        if (moved != 0) {
            System.arraycopy(this.elements, index, this.elements, index + 1, moved);
            System.arraycopy(this.weights, index, this.weights, index + 1, moved);
        }
        this.elements[index] = element;
        this.weights[index] = weight;
        this.size = newSize;
        this.totalWeight += weight;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c instanceof IRandomList) {
            return this.addAll(index, (IRandomList)c);
        }
        throw new UnsupportedOperationException("Added collection must be an IRandomList too, so that we know what weights its elements have.");
    }

    @Override
    public boolean addAll(IRandomList<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, IRandomList<? extends E> c) {
        double cTotalWeight;
        this.checkIndexForAdd(index);
        if (c.isEmpty()) {
            return false;
        }
        ++this.modCount;
        int cSize = c.size();
        this.ensureCapacity(this.size + cSize);
        if (index != this.size) {
            System.arraycopy(this.elements, index, this.elements, index + cSize, this.size - index);
            System.arraycopy(this.weights, index, this.weights, index + cSize, this.size - index);
        }
        if (c instanceof RandomList) {
            RandomList r = (RandomList)c;
            System.arraycopy(r.elements, 0, this.elements, index, cSize);
            System.arraycopy(r.weights, 0, this.weights, index, cSize);
            cTotalWeight = r.totalWeight;
        } else {
            cTotalWeight = 0.0;
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                this.elements[index] = iterator.next();
                this.weights[index] = iterator.getWeight();
                cTotalWeight += this.weights[index];
                ++index;
            }
        }
        this.size += cSize;
        this.totalWeight += cTotalWeight;
        return true;
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        ++this.modCount;
        E oldValue = this.getRawElement(index);
        double oldWeight = this.weights[index];
        int moved = this.size - index - 1;
        if (moved != 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moved);
            System.arraycopy(this.weights, index + 1, this.weights, index, moved);
        }
        this.elements[--this.size] = null;
        this.totalWeight -= oldWeight;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkBoundsForSubList(fromIndex, toIndex);
        ++this.modCount;
        double[] weights = this.weights;
        double totalWeight = this.totalWeight;
        for (int i = fromIndex; i < toIndex; ++i) {
            totalWeight -= weights[i];
        }
        this.totalWeight = totalWeight;
        int moved = this.size - toIndex;
        if (moved != 0) {
            System.arraycopy(this.elements, toIndex, this.elements, fromIndex, moved);
            System.arraycopy(weights, toIndex, weights, fromIndex, moved);
        }
        int newSize = this.size - (toIndex - fromIndex);
        java.util.Arrays.fill(this.elements, newSize, this.size, null);
        this.size = newSize;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        ++this.modCount;
        java.util.Arrays.fill(this.elements, 0, this.size, null);
        this.size = 0;
        this.totalWeight = 0.0;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 0, this.size, 16);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        E[] elements = this.castRawElements();
        int modCount = this.modCount;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elements[i]);
            if (modCount == this.modCount) continue;
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Object[] toArray() {
        return java.util.Arrays.copyOf(this.elements, this.size, Object[].class);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(this.elements, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.elements.length) {
            return;
        }
        int capacity = this.elements.length << 1;
        if (capacity < 0) {
            capacity = 0x7FFFFFF7;
        }
        if (capacity < minCapacity) {
            capacity = minCapacity;
        }
        this.elements = java.util.Arrays.copyOf(this.elements, capacity);
        this.weights = java.util.Arrays.copyOf(this.weights, capacity);
    }

    public void trimToSize() {
        int size = this.size;
        if (size < this.elements.length) {
            if (size == 0) {
                this.elements = ObjectArrays.EMPTY_ARRAY;
                this.weights = DoubleArrays.EMPTY_ARRAY;
            } else {
                this.elements = java.util.Arrays.copyOf(this.elements, size);
                this.weights = java.util.Arrays.copyOf(this.weights, size);
            }
        }
    }

    public Swapper swapper() {
        Object[] elements = this.elements;
        double[] weights = this.weights;
        return (index1, index2) -> {
            ObjectArrays.swap((Object[])elements, (int)index1, (int)index2);
            DoubleArrays.swap((double[])weights, (int)index1, (int)index2);
        };
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.size <= 1) {
            return;
        }
        ++this.modCount;
        Object[] elements = this.castRawElements();
        Arrays.quickSort((int)0, (int)this.size, (IntComparator)(comparator != null ? (index1, index2) -> comparator.compare((Object)elements[index1], (Object)elements[index2]) : (index1, index2) -> ((Comparable)elements[index1]).compareTo(elements[index2])), (Swapper)this.swapper());
    }

    public void sortByWeight(boolean largestWeightFirst) {
        if (this.size <= 1) {
            return;
        }
        ++this.modCount;
        double[] weights = this.weights;
        Arrays.quickSort((int)0, (int)this.size, (IntComparator)(largestWeightFirst ? (index1, index2) -> Double.compare(weights[index2], weights[index1]) : (index1, index2) -> Double.compare(weights[index1], weights[index2])), (Swapper)this.swapper());
    }

    public RandomList<E> clone() {
        try {
            RandomList clone = (RandomList)super.clone();
            clone.elements = java.util.Arrays.copyOf(clone.elements, clone.size);
            clone.weights = java.util.Arrays.copyOf(clone.weights, clone.size);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Nullable
    public static String elementName(ReifiedType<?> elementType) {
        UseName useName = (UseName)elementType.getAnnotations().getFirst(UseName.class);
        if (useName != null) {
            return useName.value();
        }
        if (elementType.getAnnotations().has(EncodeInline.class)) {
            return null;
        }
        return "element";
    }

    public static class RandomListEncoder<T>
    extends AutoEncoder.NamedEncoder<RandomList<T>> {
        @NotNull
        public final AutoCoder<T> elementCoder;
        @Nullable
        public final String elementName;
        public final boolean singletonArray;

        public RandomListEncoder(@NotNull ReifiedType<RandomList<T>> type, @NotNull AutoCoder<T> elementCoder, @Nullable String elementName, boolean singletonArray) {
            super(type);
            this.elementCoder = elementCoder;
            this.elementName = elementName;
            this.singletonArray = singletonArray;
        }

        public RandomListEncoder(FactoryContext<RandomList<T>> context) {
            super(context.type);
            ReifiedType elementType = context.type.resolveParameter(RandomList.class);
            this.elementCoder = context.type(elementType).forceCreateCoder();
            this.elementName = RandomList.elementName(elementType);
            this.singletonArray = elementType.getAnnotations().has(SingletonArray.class);
        }

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, RandomList<T>> context) throws EncodeException {
            RandomList list = (RandomList)context.object;
            if (list == null) {
                return EmptyData.INSTANCE;
            }
            if (this.singletonArray && list.size() == 1) {
                return this.encodeElement(context, list.get(0), list.getWeight(0));
            }
            return ListData.collect(IntStream.range(0, list.size()).mapToObj(index -> this.encodeElement(context, list.get(index), list.getWeight(index))));
        }

        @NotNull
        public <T_Encoded> Data encodeElement(EncodeContext<T_Encoded, RandomList<T>> context, T element, double weight) {
            Data encodedElement = context.object(element).encodeWith(this.elementCoder);
            Data encodedWeight = context.object((Object)weight).encodeWith((AutoEncoder)PrimitiveCoders.DOUBLE);
            if (this.elementName != null) {
                MapData data = new MapData(2);
                data.put(this.elementName, encodedElement);
                data.put("weight", encodedWeight);
                return data;
            }
            ((MapData)encodedElement).put("weight", encodedWeight);
            return encodedElement;
        }
    }

    public static class RandomListImprinter<T>
    extends AutoImprinter.NamedImprinter<RandomList<T>> {
        public static final AutoDecoder<Double> WEIGHT_DECODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder((ReifiedType)new ReifiedType<Double>(){});
        @NotNull
        public final AutoCoder<T> elementCoder;
        @Nullable
        public final String elementName;
        public final boolean allowSingleton;

        public RandomListImprinter(@NotNull ReifiedType<RandomList<T>> type, @NotNull AutoCoder<T> elementCoder, @Nullable String elementName, boolean allowSingleton) {
            super(type);
            this.elementCoder = elementCoder;
            this.elementName = elementName;
            this.allowSingleton = allowSingleton;
        }

        public RandomListImprinter(FactoryContext<RandomList<T>> context) {
            super(context.type);
            ReifiedType elementType = context.type.resolveParameter(RandomList.class);
            this.elementCoder = context.type(elementType).forceCreateCoder();
            this.elementName = RandomList.elementName(elementType);
            this.allowSingleton = elementType.getAnnotations().has(SingletonArray.class);
        }

        public <T_Encoded> void imprint(@NotNull ImprintContext<T_Encoded, RandomList<T>> context) throws ImprintException {
            try {
                RandomList result = (RandomList)context.object;
                for (ImprintContext entry : context.listIterableMaybeSingleton(this.allowSingleton)) {
                    result.add((this.elementName != null ? (ImprintContext)entry.forceGetMember(this.elementName) : entry).decodeWith(this.elementCoder), (Double)((ImprintContext)entry.forceGetMember("weight")).decodeWith(WEIGHT_DECODER));
                }
            }
            catch (ImprintException exception) {
                throw exception;
            }
            catch (DecodeException exception) {
                throw new ImprintException((Throwable)exception);
            }
        }
    }
}

