/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomSources;

import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.common.FactoryException;
import builderb0y.autocodec.verifiers.AutoVerifier;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.randomSources.RandomSource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomRangeVerifier
implements AutoVerifier<RandomSource> {
    public final double min;
    public final double max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public RandomRangeVerifier(double min, double max, boolean minInclusive, boolean maxInclusive) {
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public RandomRangeVerifier(VerifyRandomRange annotation) {
        this(annotation.min(), annotation.max(), annotation.minInclusive(), annotation.maxInclusive());
    }

    @ApiStatus.OverrideOnly
    public <T_Encoded> void verify(@NotNull VerifyContext<T_Encoded, RandomSource> context) throws VerifyException {
        if (context.object == null) {
            return;
        }
        double min = ((RandomSource)context.object).minValue();
        double max = ((RandomSource)context.object).maxValue();
        if (Double.isNaN(min)) {
            throw new VerifyException(() -> context.pathToStringBuilder().append(".min cannot be NaN").toString());
        }
        if (Double.isNaN(max)) {
            throw new VerifyException(() -> context.pathToStringBuilder().append(".max cannot be NaN").toString());
        }
        if ((this.minInclusive ? Double.compare(min, this.min) >= 0 : Double.compare(min, this.min) > 0) && (this.maxInclusive ? Double.compare(max, this.max) <= 0 : Double.compare(max, this.max) < 0)) {
            return;
        }
        throw new VerifyException(() -> {
            boolean haveMax;
            StringBuilder message = context.pathToStringBuilder();
            boolean haveMin = this.min != Double.NEGATIVE_INFINITY || !this.minInclusive;
            boolean bl = haveMax = this.max != Double.POSITIVE_INFINITY || !this.maxInclusive;
            assert (haveMin || haveMax) : "No bounds, but still failed?";
            message.append(" must be ");
            if (haveMin) {
                message.append("greater than ");
                if (this.minInclusive) {
                    message.append("or equal to ");
                }
                message.append(this.min);
            }
            if (haveMin && haveMax) {
                message.append(" and ");
            }
            if (haveMax) {
                message.append("less than ");
                if (this.maxInclusive) {
                    message.append("or equal to ");
                }
                message.append(this.max);
            }
            return message.toString();
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + (this.minInclusive ? (char)'[' : '(') + this.min + ", " + this.max + (this.maxInclusive ? (char)']' : ')');
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface VerifyRandomRange {
        public double min() default -Infinity;

        public double max() default Infinity;

        public boolean minInclusive() default true;

        public boolean maxInclusive() default true;
    }

    public static class Factory
    extends AutoVerifier.NamedVerifierFactory {
        public static final Factory INSTANCE = new Factory();

        @ApiStatus.OverrideOnly
        @Nullable
        public <T_HandledType> AutoVerifier<?> tryCreate(@NotNull FactoryContext<T_HandledType> context) throws FactoryException {
            VerifyRandomRange range;
            if (context.type.getRawClass() != null && RandomSource.class.isAssignableFrom(context.type.getRawClass()) && (range = (VerifyRandomRange)context.type.getAnnotations().getFirst(VerifyRandomRange.class)) != null) {
                return new RandomRangeVerifier(range);
            }
            return null;
        }
    }
}

